/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.logging;

import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.logging.ILoggerCallback;

public class Logger {
    private static final String ANDROID_LOGCAT_LOGGER_IDENTIFIER = "ANDROID_LOGCAT_LOGGER";
    private static final String ANDROID_EXTERNAL_LOGGER_IDENTIFIER = "ANDROID_EXTERNAL_LOGGER";
    private static final Logger INSTANCE = new Logger();
    private static boolean sAllowLogcat = false;

    public static void setAndroidLogger() {
        com.microsoft.identity.common.java.logging.Logger.setLogger((String)ANDROID_LOGCAT_LOGGER_IDENTIFIER, (com.microsoft.identity.common.java.logging.ILoggerCallback)new com.microsoft.identity.common.java.logging.ILoggerCallback(){

            public void log(String tag, Logger.LogLevel logLevel, String message, boolean containsPII) {
                if (sAllowLogcat) {
                    switch (logLevel) {
                        case ERROR: {
                            Log.e((String)tag, (String)message);
                            break;
                        }
                        case WARN: {
                            Log.w((String)tag, (String)message);
                            break;
                        }
                        case INFO: {
                            Log.i((String)tag, (String)message);
                            break;
                        }
                        case VERBOSE: {
                            Log.v((String)tag, (String)message);
                            break;
                        }
                    }
                }
            }
        });
        com.microsoft.identity.common.java.logging.Logger.setPlatformString((String)(" Android " + Build.VERSION.SDK_INT));
    }

    public static Logger getInstance() {
        return INSTANCE;
    }

    public static void setAllowPii(boolean allowPii) {
        com.microsoft.identity.common.java.logging.Logger.setAllowPii((boolean)allowPii);
    }

    public static void setAllowLogcat(boolean allowLogcat) {
        sAllowLogcat = allowLogcat;
    }

    public static boolean getAllowPii() {
        return com.microsoft.identity.common.java.logging.Logger.isAllowPii();
    }

    public static boolean getAllowLogcat() {
        return sAllowLogcat;
    }

    public void setLogLevel(LogLevel logLevel) {
        com.microsoft.identity.common.java.logging.Logger.setLogLevel((Logger.LogLevel)logLevel.convertToJavaLogLevel());
    }

    public void setExternalLogger(final ILoggerCallback externalLogger) {
        com.microsoft.identity.common.java.logging.Logger.setLogger((String)ANDROID_EXTERNAL_LOGGER_IDENTIFIER, (com.microsoft.identity.common.java.logging.ILoggerCallback)new com.microsoft.identity.common.java.logging.ILoggerCallback(){

            public void log(String tag, Logger.LogLevel logLevel, String message, boolean containsPII) {
                externalLogger.log(tag, LogLevel.convertFromJavaLogLevel(logLevel), message, containsPII);
            }
        });
    }

    public static String getDiagnosticContextMetadata() {
        return com.microsoft.identity.common.java.logging.Logger.getDiagnosticContextMetadata();
    }

    public static void error(String tag, @Nullable String errorMessage, @Nullable Throwable exception) {
        com.microsoft.identity.common.java.logging.Logger.error((String)tag, (String)errorMessage, (Throwable)exception);
    }

    public static void error(String tag, @Nullable String correlationID, @Nullable String errorMessage, @Nullable Throwable exception) {
        com.microsoft.identity.common.java.logging.Logger.error((String)tag, (String)correlationID, (String)errorMessage, (Throwable)exception);
    }

    public static void errorPII(String tag, @Nullable String errorMessage, @Nullable Throwable exception) {
        com.microsoft.identity.common.java.logging.Logger.errorPII((String)tag, (String)errorMessage, (Throwable)exception);
    }

    public static void errorPII(String tag, @Nullable String correlationID, @Nullable String errorMessage, @Nullable Throwable exception) {
        com.microsoft.identity.common.java.logging.Logger.errorPII((String)tag, (String)correlationID, (String)errorMessage, (Throwable)exception);
    }

    public static void warn(String tag, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.warn((String)tag, (String)message);
    }

    public static void warn(String tag, @Nullable String correlationID, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.warn((String)tag, (String)correlationID, (String)message);
    }

    public static void warnPII(String tag, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.warnPII((String)tag, (String)message);
    }

    public static void warnPII(String tag, @Nullable String correlationID, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.warnPII((String)tag, (String)correlationID, (String)message);
    }

    public static void info(String tag, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.info((String)tag, (String)message);
    }

    public static void info(String tag, @Nullable String correlationID, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.info((String)tag, (String)correlationID, (String)message);
    }

    public static void infoPII(String tag, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.infoPII((String)tag, (String)message);
    }

    public static void infoPII(String tag, @Nullable String correlationID, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.infoPII((String)tag, (String)correlationID, (String)message);
    }

    public static void verbose(String tag, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.verbose((String)tag, (String)message);
    }

    public static void verbose(String tag, @Nullable String correlationID, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.verbose((String)tag, (String)correlationID, (String)message);
    }

    public static void verbosePII(String tag, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.verbosePII((String)tag, (String)message);
    }

    public static void verbosePII(String tag, String correlationID, @Nullable String message) {
        com.microsoft.identity.common.java.logging.Logger.verbosePII((String)tag, (String)correlationID, (String)message);
    }

    static {
        Logger.setAndroidLogger();
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        VERBOSE;


        private Logger.LogLevel convertToJavaLogLevel() {
            switch (this) {
                case INFO: {
                    return Logger.LogLevel.INFO;
                }
                case WARN: {
                    return Logger.LogLevel.WARN;
                }
                case ERROR: {
                    return Logger.LogLevel.ERROR;
                }
            }
            return Logger.LogLevel.VERBOSE;
        }

        private static LogLevel convertFromJavaLogLevel(@NonNull Logger.LogLevel logLevel) {
            switch (logLevel) {
                case INFO: {
                    return INFO;
                }
                case WARN: {
                    return WARN;
                }
                case ERROR: {
                    return ERROR;
                }
            }
            return VERBOSE;
        }
    }
}

