/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.internal.ui.CurrentTaskBrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.ui.browser.DefaultBrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.webview.EmbeddedWebViewAuthorizationStrategy;
import com.microsoft.identity.common.java.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.providers.oauth2.IAuthorizationStrategy;
import com.microsoft.identity.common.java.strategies.IAuthorizationStrategyFactory;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;

public class AndroidAuthorizationStrategyFactory
implements IAuthorizationStrategyFactory {
    private static final String TAG = AndroidAuthorizationStrategyFactory.class.getSimpleName();
    private final Context mContext;
    private final Activity mActivity;
    private final Fragment mFragment;

    public IAuthorizationStrategy getAuthorizationStrategy(@NonNull InteractiveTokenCommandParameters parameters) {
        AuthorizationAgent validatedAuthorizationAgent = this.validAuthorizationAgent(parameters.getAuthorizationAgent());
        boolean isBrokerRequest = parameters instanceof BrokerInteractiveTokenCommandParameters;
        if (validatedAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
            Logger.info(TAG, "Use webView for authorization.");
            return this.getGenericAuthorizationStrategy();
        }
        if (validatedAuthorizationAgent == AuthorizationAgent.DEFAULT) {
            block4: {
                try {
                    BrowserSelector.select(this.mContext, parameters.getBrowserSafeList());
                }
                catch (ClientException exception) {
                    Logger.info(TAG, "No supported browser available found. Fallback to the webView authorization agent.");
                    if (!"No available browser installed on the device.".equalsIgnoreCase(exception.getErrorCode())) break block4;
                    return this.getGenericAuthorizationStrategy();
                }
            }
            Logger.info(TAG, "Use browser for authorization.");
            return this.getBrowserAuthorizationStrategy(isBrokerRequest, parameters.getBrowserSafeList());
        }
        Logger.info(TAG, "Use browser for authorization.");
        return this.getBrowserAuthorizationStrategy(isBrokerRequest, parameters.getBrowserSafeList());
    }

    private IAuthorizationStrategy getBrowserAuthorizationStrategy(@NonNull boolean isBrokerRequest, @NonNull List<BrowserDescriptor> browserSafeList) {
        if (LibraryConfiguration.getInstance().isAuthorizationInCurrentTask()) {
            CurrentTaskBrowserAuthorizationStrategy currentTaskBrowserAuthorizationStrategy = new CurrentTaskBrowserAuthorizationStrategy(this.mContext, this.mActivity, this.mFragment);
            currentTaskBrowserAuthorizationStrategy.setBrowserSafeList(browserSafeList);
            return currentTaskBrowserAuthorizationStrategy;
        }
        DefaultBrowserAuthorizationStrategy defaultBrowserAuthorizationStrategy = new DefaultBrowserAuthorizationStrategy(this.mContext, this.mActivity, this.mFragment, isBrokerRequest);
        defaultBrowserAuthorizationStrategy.setBrowserSafeList(browserSafeList);
        return defaultBrowserAuthorizationStrategy;
    }

    private IAuthorizationStrategy getGenericAuthorizationStrategy() {
        return new EmbeddedWebViewAuthorizationStrategy(this.mContext, this.mActivity, this.mFragment);
    }

    private AuthorizationAgent validAuthorizationAgent(AuthorizationAgent agent) {
        if (agent != AuthorizationAgent.WEBVIEW && BrowserSelector.getAllBrowsers(this.mContext).isEmpty()) {
            Logger.verbose(TAG, "Unable to use browser to do the authorization because No available browser installed on the device. Use embedded webView instead.");
            return AuthorizationAgent.WEBVIEW;
        }
        return agent;
    }

    AndroidAuthorizationStrategyFactory(Context context, Activity activity, Fragment fragment) {
        this.mContext = context;
        this.mActivity = activity;
        this.mFragment = fragment;
    }

    public static AndroidAuthorizationStrategyFactoryBuilder builder() {
        return new AndroidAuthorizationStrategyFactoryBuilder();
    }

    public static class AndroidAuthorizationStrategyFactoryBuilder {
        private Context context;
        private Activity activity;
        private Fragment fragment;

        AndroidAuthorizationStrategyFactoryBuilder() {
        }

        public AndroidAuthorizationStrategyFactoryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public AndroidAuthorizationStrategyFactoryBuilder activity(Activity activity) {
            this.activity = activity;
            return this;
        }

        public AndroidAuthorizationStrategyFactoryBuilder fragment(Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public AndroidAuthorizationStrategyFactory build() {
            return new AndroidAuthorizationStrategyFactory(this.context, this.activity, this.fragment);
        }

        public String toString() {
            return "AndroidAuthorizationStrategyFactory.AndroidAuthorizationStrategyFactoryBuilder(context=" + this.context + ", activity=" + this.activity + ", fragment=" + this.fragment + ")";
        }
    }
}

