/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.core.content.pm.PackageInfoCompat;
import com.microsoft.identity.common.internal.telemetry.AndroidTelemetryPropertiesCache;
import com.microsoft.identity.common.java.telemetry.AbstractTelemetryContext;
import com.microsoft.identity.common.java.telemetry.TelemetryPropertiesCache;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.NonNull;

public class AndroidTelemetryContext
extends AbstractTelemetryContext {
    private static final String TAG = AndroidTelemetryContext.class.getName();

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="Lombok inserts nullchecks")
    public AndroidTelemetryContext(@NonNull Context context) {
        super((TelemetryPropertiesCache)new AndroidTelemetryPropertiesCache(context));
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.addApplicationInfo(context);
        this.addDeviceInfo(Build.MANUFACTURER, Build.MODEL, Build.DEVICE);
        this.addOsInfo();
    }

    private void addApplicationInfo(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            long versionCode = PackageInfoCompat.getLongVersionCode((PackageInfo)packageInfo);
            super.addApplicationInfo(packageInfo.applicationInfo.packageName, packageInfo.versionName, String.valueOf(versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn(TAG, "Unable to find the app's package name from PackageManager.");
        }
    }

    private void addOsInfo() {
        super.addOsInfo("android", Build.VERSION.RELEASE);
        if (Build.VERSION.SDK_INT >= 23) {
            this.put("Microsoft.MSAL.security_patch", Build.VERSION.SECURITY_PATCH);
        }
    }

    public void isNetworkDisabledFromOptimizations(boolean isDozed) {
        this.put("Microsoft.MSAL.power_optimization", String.valueOf(isDozed));
    }

    public void isNetworkConnected(boolean isConnected) {
        this.put("Microsoft.MSAL.network_connection", String.valueOf(isConnected));
    }
}

