/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.result;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.ADALError;
import com.microsoft.identity.common.internal.result.IBrokerResultAdapter;
import com.microsoft.identity.common.java.commands.AcquirePrtSsoTokenResult;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.exception.UserCancelException;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.logging.Logger;
import java.io.Serializable;

public class AdalBrokerResultAdapter
implements IBrokerResultAdapter {
    private static final String TAG = AdalBrokerResultAdapter.class.getName();

    @Override
    @NonNull
    public Bundle bundleFromAuthenticationResult(@NonNull ILocalAuthenticationResult authenticationResult, @Nullable String negotiatedBrokerProtocolVersion) {
        Logger.verbose(TAG, "Constructing success bundle from Authentication Result.");
        Bundle resultBundle = new Bundle();
        IAccountRecord accountRecord = authenticationResult.getAccountRecord();
        resultBundle.putString("account.login.hint", accountRecord.getUsername());
        resultBundle.putString("account.userinfo.userid", accountRecord.getLocalAccountId());
        resultBundle.putString("account.userinfo.userid.displayable", accountRecord.getUsername());
        resultBundle.putString("account.userinfo.given.name", accountRecord.getFirstName());
        resultBundle.putString("account.userinfo.family.name", accountRecord.getFamilyName());
        resultBundle.putString("account.userinfo.identity.provider", SchemaUtil.getIdentityProvider((String)authenticationResult.getIdToken()));
        resultBundle.putString("account.userinfo.tenantid", authenticationResult.getTenantId());
        resultBundle.putLong("account.expiredate", authenticationResult.getExpiresOn().getTime());
        resultBundle.putString("account.authority", this.getAuthority(authenticationResult));
        resultBundle.putString("account.access.token", authenticationResult.getAccessToken());
        resultBundle.putString("account.idtoken", authenticationResult.getIdToken());
        resultBundle.putString("cliteleminfo.spe_ring", authenticationResult.getSpeRing());
        resultBundle.putString("cliteleminfo.rt_age", authenticationResult.getRefreshTokenAge());
        return resultBundle;
    }

    @Override
    @NonNull
    public Bundle bundleFromBaseException(@NonNull BaseException baseException, @Nullable String negotiatedBrokerProtocolVersion) {
        Logger.verbose(TAG, "Constructing error bundle from exception.");
        Bundle resultBundle = new Bundle();
        resultBundle.putString("com.microsoft.aad.adal:BrowserErrorCode", baseException.getErrorCode());
        resultBundle.putString("com.microsoft.aad.adal:BrowserErrorMessage", baseException.getMessage());
        resultBundle.putString("cliteleminfo.spe_ring", baseException.getSpeRing());
        resultBundle.putString("cliteleminfo.rt_age", baseException.getRefreshTokenAge());
        resultBundle.putString("cliteleminfo.server_error", baseException.getCliTelemErrorCode());
        resultBundle.putString("cliteleminfo.server_suberror", baseException.getCliTelemSubErrorCode());
        this.mapExceptionToBundle(resultBundle, baseException);
        return resultBundle;
    }

    @Override
    @NonNull
    public ILocalAuthenticationResult authenticationResultFromBundle(Bundle resultBundle) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public BaseException getBaseExceptionFromBundle(Bundle resultBundle) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public AcquirePrtSsoTokenResult getAcquirePrtSsoTokenResultFromBundle(Bundle resultBundle) {
        throw new UnsupportedOperationException();
    }

    private void mapExceptionToBundle(@NonNull Bundle resultBundle, @NonNull BaseException exception) {
        if (exception instanceof UserCancelException) {
            Logger.info(TAG, "Setting Bundle result from UserCancelException.");
            this.setErrorToResultBundle(resultBundle, 4, exception.getMessage());
        } else if (exception instanceof ArgumentException) {
            Logger.info(TAG, "Setting Bundle result from ArgumentException.");
            this.setErrorToResultBundle(resultBundle, 7, exception.getMessage());
        } else if (exception instanceof ClientException) {
            this.setClientExceptionPropertiesToBundle(resultBundle, (ClientException)exception);
        } else if (exception instanceof ServiceException) {
            this.setServiceExceptionPropertiesToBundle(resultBundle, (ServiceException)exception);
        } else {
            Logger.info(TAG, "Setting Bundle result for Unknown Exception/Bad result.");
            this.setErrorToResultBundle(resultBundle, 8, exception.getMessage());
        }
    }

    private String getAuthority(@NonNull ILocalAuthenticationResult authenticationResult) {
        String protocol = "https";
        Uri.Builder builder = new Uri.Builder().scheme("https");
        builder.authority(authenticationResult.getAccessTokenRecord().getEnvironment());
        if (!TextUtils.isEmpty((CharSequence)authenticationResult.getTenantId())) {
            builder.appendPath(authenticationResult.getTenantId());
        } else {
            builder.appendPath("common");
        }
        return builder.build().toString();
    }

    private void setClientExceptionPropertiesToBundle(@NonNull Bundle resultBundle, @NonNull ClientException clientException) {
        Logger.info(TAG, "Setting properties from ClientException.");
        if ("device_network_not_available".equalsIgnoreCase(clientException.getErrorCode())) {
            this.setErrorToResultBundle(resultBundle, 3, ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE.getDescription());
        } else if ("device_network_not_available_doze_mode".equalsIgnoreCase(clientException.getErrorCode())) {
            this.setErrorToResultBundle(resultBundle, 3, ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION.getDescription());
        } else if ("io_error".equalsIgnoreCase(clientException.getErrorCode())) {
            this.setErrorToResultBundle(resultBundle, 3, ADALError.IO_EXCEPTION.getDescription());
        }
    }

    private void setServiceExceptionPropertiesToBundle(@NonNull Bundle resultBundle, @NonNull ServiceException serviceException) {
        Logger.info(TAG, "Setting properties from ServiceException.");
        resultBundle.putString("error", serviceException.getErrorCode());
        resultBundle.putString("error_description", serviceException.getMessage());
        resultBundle.putString("suberror", serviceException.getOAuthSubErrorCode());
        if (null != serviceException.getHttpResponseBody()) {
            resultBundle.putSerializable("response_body", (Serializable)serviceException.getHttpResponseBody());
        }
        if (null != serviceException.getHttpResponseHeaders()) {
            resultBundle.putSerializable("response_headers", (Serializable)serviceException.getHttpResponseHeaders());
        }
        resultBundle.putInt("status_code", serviceException.getHttpStatusCode());
        if (serviceException instanceof IntuneAppProtectionPolicyRequiredException) {
            Logger.verbose(TAG, "Exception was IntuneAppProtectionPolicyRequired");
            this.setIntuneAppProtectionPropertiesToBundle(resultBundle, (IntuneAppProtectionPolicyRequiredException)serviceException);
        }
        if ("invalid_grant".equalsIgnoreCase(serviceException.getErrorCode()) || "interaction_required".equalsIgnoreCase(serviceException.getErrorCode())) {
            resultBundle.putString("error", ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED.getDescription());
            resultBundle.putString("error_description", serviceException.getMessage());
        }
    }

    private void setIntuneAppProtectionPropertiesToBundle(@NonNull Bundle resultBundle, @NonNull IntuneAppProtectionPolicyRequiredException exception) {
        Logger.info(TAG, "Setting properties from IntuneAppProtectionPolicyRequiredException.");
        resultBundle.putString("com.microsoft.aad.adal:BrowserErrorCode", ADALError.AUTH_FAILED_INTUNE_POLICY_REQUIRED.name());
        resultBundle.putString("account.userinfo.tenantid", exception.getTenantId());
        resultBundle.putString("account.authority", exception.getAuthorityUrl());
        resultBundle.putString("account.userinfo.userid", exception.getAccountUserId());
        resultBundle.putString("account.name", exception.getAccountUpn());
    }

    private void setErrorToResultBundle(@NonNull Bundle resultBundle, @NonNull int error, @NonNull String errorDescription) {
        resultBundle.putInt("errorCode", error);
        resultBundle.putString("errorMessage", errorDescription);
    }
}

