/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyInfo;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.StrongBoxUnavailableException;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.adal.internal.AuthenticationConstants;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.internal.platform.DeviceKeyManager;
import com.microsoft.identity.common.internal.util.Supplier;
import com.microsoft.identity.common.java.crypto.IAndroidKeyStoreKeyManager;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.crypto.SigningAlgorithm;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.marker.CodeMarkerManager;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.java.util.ported.DateUtilities;
import com.microsoft.identity.common.logging.Logger;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.impl.RSAKeyUtils;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.x500.X500Principal;
import org.json.JSONException;
import org.json.JSONObject;

public class DevicePopManager
implements IDevicePopManager {
    private static final String TAG = DevicePopManager.class.getSimpleName();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String DEFAULT_KEYSTORE_ENTRY_ALIAS = "microsoft-device-pop";
    private static final int RSA_KEY_SIZE = 2048;
    private static final String PRIVATE_KEY_NOT_FOUND = "Not an instance of a PrivateKeyEntry";
    public static final Type MAP_STRING_STRING_TYPE = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class}).getType();
    public static final Gson GSON = new Gson();
    public static final String STRONG_BOX_UNAVAILABLE_EXCEPTION = "StrongBoxUnavailableException";
    public static final String FAILED_TO_GENERATE_ATTESTATION_CERTIFICATE_CHAIN = "Failed to generate attestation certificate chain";
    private final IAndroidKeyStoreKeyManager<KeyStore.PrivateKeyEntry> mKeyManager;
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    private static final ExecutorService sThreadExecutor = Executors.newFixedThreadPool(5);
    private static final CodeMarkerManager sCodeMarkerManager = CodeMarkerManager.getInstance();
    private final Context mContext;

    public DevicePopManager(@NonNull Context context) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this(context, DEFAULT_KEYSTORE_ENTRY_ALIAS);
    }

    public IAndroidKeyStoreKeyManager<KeyStore.PrivateKeyEntry> getKeyManager() {
        return this.mKeyManager;
    }

    public DevicePopManager(@NonNull Context context, @NonNull String alias) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore instance = KeyStore.getInstance(ANDROID_KEYSTORE);
        instance.load(null);
        this.mKeyManager = DeviceKeyManager.builder().keyAlias(alias).keyStore(instance).thumbprintSupplier(new Supplier<byte[]>(){

            @Override
            public byte[] get() {
                return DevicePopManager.this.getAsymmetricKeyThumbprint().getBytes(UTF8);
            }
        }).build();
        this.mContext = context;
    }

    public boolean asymmetricKeyExists() {
        return this.mKeyManager.exists();
    }

    public boolean asymmetricKeyExists(@NonNull String thumbprint) {
        return this.mKeyManager.hasThumbprint(thumbprint.getBytes(UTF8));
    }

    public String getAsymmetricKeyThumbprint() throws ClientException {
        String errCode;
        Throwable exception;
        try {
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry();
            return DevicePopManager.getRsaThumbprint(entry);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    public static String getRsaThumbprint(@NonNull KeyStore.PrivateKeyEntry entry) throws JOSEException {
        KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(entry);
        RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
        return DevicePopManager.getThumbprintForRsaKey(rsaKey);
    }

    public void generateAsymmetricKey(final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onTaskCompleted((Object)DevicePopManager.this.generateAsymmetricKey());
                }
                catch (ClientException e) {
                    callback.onError((Object)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateAsymmetricKey() throws ClientException {
        String errCode;
        Throwable exception;
        try {
            sCodeMarkerManager.markCode("30001");
            KeyPair keyPair = this.generateNewRsaKeyPair(this.mContext, 2048);
            RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(keyPair);
            String string2 = DevicePopManager.getThumbprintForRsaKey(rsaKey);
            return string2;
        }
        catch (UnsupportedOperationException e) {
            exception = e;
            errCode = "keystore_produced_invalid_cert";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (NoSuchProviderException e) {
            exception = e;
            errCode = "android_keystore_unavailable";
        }
        catch (InvalidAlgorithmParameterException e) {
            exception = e;
            errCode = "keystore_initialization_failed";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        finally {
            sCodeMarkerManager.markCode("30002");
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Nullable
    public Date getAsymmetricKeyCreationDate() throws ClientException {
        return this.mKeyManager.getCreationDate();
    }

    public boolean clearAsymmetricKey() {
        return this.mKeyManager.clear();
    }

    public String getRequestConfirmation() throws ClientException {
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] result = new String[1];
        final ClientException[] errorResult = new ClientException[1];
        this.getRequestConfirmation(new TaskCompletedCallbackWithError<String, ClientException>(){

            public void onTaskCompleted(@NonNull String reqCnf) {
                result[0] = reqCnf;
                latch.countDown();
            }

            public void onError(@NonNull ClientException error) {
                errorResult[0] = error;
                latch.countDown();
            }
        });
        try {
            latch.await();
            if (null != result[0]) {
                return result[0];
            }
            throw errorResult[0];
        }
        catch (InterruptedException e) {
            Logger.error(TAG, "Interrupted while waiting on callback.", e);
            throw new ClientException("operation_interrupted", e.getMessage(), (Throwable)e);
        }
    }

    public void getRequestConfirmation(final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                String errCode;
                Throwable exception;
                try {
                    KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)DevicePopManager.this.mKeyManager.getEntry();
                    KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
                    RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
                    String base64UrlEncodedJwkJsonStr = DevicePopManager.getReqCnfForRsaKey(rsaKey);
                    callback.onTaskCompleted((Object)base64UrlEncodedJwkJsonStr);
                    return;
                }
                catch (KeyStoreException e) {
                    exception = e;
                    errCode = "keystore_not_initialized";
                }
                catch (NoSuchAlgorithmException e) {
                    exception = e;
                    errCode = "no_such_algorithm";
                }
                catch (UnrecoverableEntryException e) {
                    exception = e;
                    errCode = "protection_params_invalid";
                }
                catch (JOSEException e) {
                    exception = e;
                    errCode = "failed_to_compute_thumbprint_with_sha256";
                }
                catch (JSONException e) {
                    exception = e;
                    errCode = "json_construction_failed";
                }
                ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
                Logger.error(TAG, clientException.getMessage(), clientException);
                callback.onError((Object)clientException);
            }
        });
    }

    @NonNull
    public String sign(@NonNull SigningAlgorithm alg, @NonNull String input) throws ClientException {
        return Base64.encodeToString((byte[])this.sign(alg, input.getBytes(UTF8)), (int)2);
    }

    public byte[] sign(@NonNull SigningAlgorithm alg, @NonNull byte[] inputBytesToSign) throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        String methodName = ":sign";
        try {
            KeyStore.Entry keyEntry = this.mKeyManager.getEntry();
            if (!(keyEntry instanceof KeyStore.PrivateKeyEntry)) {
                Logger.warn(TAG + ":sign", PRIVATE_KEY_NOT_FOUND);
                throw new ClientException("invalid_key_private_key_missing");
            }
            Signature signature = Signature.getInstance(alg.toString());
            signature.initSign(((KeyStore.PrivateKeyEntry)keyEntry).getPrivateKey());
            signature.update(inputBytesToSign);
            return signature.sign();
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (InvalidKeyException e) {
            exception = e;
            errCode = "invalid_key";
        }
        catch (SignatureException e) {
            exception = e;
            errCode = "failed_to_sign";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error(TAG + ":sign", clientException.getMessage(), clientException);
        throw clientException;
    }

    public boolean verify(@NonNull SigningAlgorithm alg, @NonNull String plainText, @NonNull String signatureStr) {
        return this.verify(alg, plainText.getBytes(UTF8), Base64.decode((String)signatureStr, (int)2));
    }

    public boolean verify(@NonNull SigningAlgorithm alg, @NonNull byte[] inputBytesToVerify, @NonNull byte[] signatureBytes) {
        GeneralSecurityException exception;
        String errCode;
        String methodName = ":verify";
        try {
            KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry();
            if (keyEntry == null) {
                Logger.warn(TAG + methodName, PRIVATE_KEY_NOT_FOUND);
                return false;
            }
            Signature signature = Signature.getInstance(alg.toString());
            signature.initVerify(keyEntry.getCertificate());
            signature.update(inputBytesToVerify);
            return signature.verify(signatureBytes);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (SignatureException e) {
            errCode = "failed_to_sign";
            exception = e;
        }
        Logger.error(TAG + methodName, errCode, exception);
        return false;
    }

    public String encrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull String plaintext) throws ClientException {
        return Base64.encodeToString((byte[])this.encrypt(cipher, plaintext.getBytes(UTF8)), (int)3);
    }

    public byte[] encrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull byte[] plaintext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        String methodName = ":encrypt";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry();
            PublicKey publicKey = privateKeyEntry.getCertificate().getPublicKey();
            Cipher input = Cipher.getInstance(cipher.toString());
            if (cipher.getParameters() != null) {
                input.init(1, (Key)publicKey, cipher.getParameters());
            } else {
                input.init(1, publicKey);
            }
            return input.doFinal(plaintext);
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error(TAG + ":encrypt", errCode, exception);
        throw clientException;
    }

    public String decrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull String ciphertext) throws ClientException {
        return new String(this.decrypt(cipher, Base64.decode((String)ciphertext, (int)3)), UTF8);
    }

    public byte[] decrypt(@NonNull IDevicePopManager.Cipher cipher, byte[] ciphertext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        String methodName = ":decrypt";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry();
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            Cipher outputCipher = Cipher.getInstance(cipher.toString());
            if (cipher.getParameters() != null) {
                outputCipher.init(2, (Key)privateKey, cipher.getParameters());
            } else {
                outputCipher.init(2, privateKey);
            }
            return outputCipher.doFinal(ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error(TAG + ":decrypt", errCode, exception);
        throw clientException;
    }

    public SecureHardwareState getSecureHardwareState() throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        try {
            KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry((KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry());
            return this.getSecureHardwareState(rsaKeyPair);
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error(TAG + ":getSecureHardwareState", errCode, exception);
        throw clientException;
    }

    @NonNull
    public String getPublicKey(@NonNull IDevicePopManager.PublicKeyFormat format) throws ClientException {
        String methodName = ":getPublicKey";
        switch (format) {
            case X_509_SubjectPublicKeyInfo_ASN_1: {
                return this.getX509SubjectPublicKeyInfo();
            }
            case JWK: {
                return this.getJwkPublicKey();
            }
        }
        String errMsg = "Unrecognized or unsupported key format: " + format;
        ClientException clientException = new ClientException("unknown_public_key_export_format", errMsg);
        Logger.error(TAG + ":getPublicKey", errMsg, clientException);
        throw clientException;
    }

    public Certificate[] getCertificateChain() throws ClientException {
        return this.mKeyManager.getCertificateChain();
    }

    @NonNull
    private String getJwkPublicKey() throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        try {
            Map<String, Object> jwkMap = this.getDevicePopJwkMinifiedJson();
            return GSON.toJson(jwkMap.get("jwk"), MAP_STRING_STRING_TYPE);
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    private String getX509SubjectPublicKeyInfo() throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        try {
            KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry();
            KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
            PublicKey publicKey = rsaKeyPair.getPublic();
            byte[] publicKeybytes = publicKey.getEncoded();
            byte[] bytesBase64Encoded = Base64.encode((byte[])publicKeybytes, (int)0);
            return new String(bytesBase64Encoded, AuthenticationConstants.CHARSET_UTF8);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    public String mintSignedAccessToken(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @NonNull String accessToken, @Nullable String nonce) throws ClientException {
        return this.mintSignedAccessToken(httpMethod, timestamp, requestUrl, accessToken, nonce, null);
    }

    public String mintSignedAccessToken(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @NonNull String accessToken, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        return this.mintSignedHttpRequestInternal(httpMethod, timestamp, requestUrl, accessToken, nonce, clientClaims);
    }

    public String mintSignedHttpRequest(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        return this.mintSignedHttpRequestInternal(httpMethod, timestamp, requestUrl, null, nonce, clientClaims);
    }

    private String mintSignedHttpRequestInternal(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @Nullable String accessToken, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        String errCode;
        Throwable exception;
        try {
            JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder();
            if (!TextUtils.isEmpty((CharSequence)accessToken)) {
                claimsBuilder.claim("at", (Object)accessToken);
            }
            claimsBuilder.claim("ts", (Object)timestamp);
            claimsBuilder.claim("u", (Object)requestUrl.getAuthority());
            claimsBuilder.claim("cnf", this.getDevicePopJwkMinifiedJson());
            if (!TextUtils.isEmpty((CharSequence)requestUrl.getPath())) {
                claimsBuilder.claim("p", (Object)requestUrl.getPath());
            }
            if (!TextUtils.isEmpty((CharSequence)httpMethod)) {
                claimsBuilder.claim("m", (Object)httpMethod);
            }
            if (!TextUtils.isEmpty((CharSequence)nonce)) {
                claimsBuilder.claim("nonce", (Object)nonce);
            }
            if (!TextUtils.isEmpty((CharSequence)clientClaims)) {
                claimsBuilder.claim("client_claims", (Object)clientClaims);
            }
            JWTClaimsSet claimsSet = claimsBuilder.build();
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry();
            PrivateKey privateKey = entry.getPrivateKey();
            RSASSASigner signer = new RSASSASigner(privateKey);
            SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.getAsymmetricKeyThumbprint()).build(), claimsSet);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_sign_jwt";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        if (Build.VERSION.SDK_INT >= 23 && exception.getCause() instanceof KeyPermanentlyInvalidatedException) {
            Logger.warn(TAG, "Unable to access asymmetric key - clearing.");
            this.clearAsymmetricKey();
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @SuppressLint(value={"NewApi"})
    private KeyPair generateNewRsaKeyPair(@NonNull Context context, int minKeySize) throws UnsupportedOperationException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        int MAX_RETRIES = 4;
        for (int ii = 0; ii < 4; ++ii) {
            KeyPair kp = null;
            boolean tryStrongBox = true;
            boolean tryImport = true;
            boolean trySetAttestationChallenge = true;
            boolean generated = false;
            while (!generated) {
                try {
                    kp = this.generateNewKeyPair(context, tryStrongBox, tryImport, trySetAttestationChallenge);
                    generated = true;
                }
                catch (ProviderException e) {
                    if (tryStrongBox && DevicePopManager.isStrongBoxUnavailableException(e)) {
                        tryStrongBox = false;
                        continue;
                    }
                    if (tryImport && e.getClass().getSimpleName().equals("SecureKeyImportUnavailableException")) {
                        Logger.error(TAG, "Import unsupported - skipping import flags.", e);
                        tryImport = false;
                        if (!tryStrongBox || null == e.getCause() || !DevicePopManager.isStrongBoxUnavailableException(e.getCause())) continue;
                        tryStrongBox = false;
                        continue;
                    }
                    if (trySetAttestationChallenge && FAILED_TO_GENERATE_ATTESTATION_CERTIFICATE_CHAIN.equalsIgnoreCase(e.getMessage())) {
                        Logger.error(TAG, "Failed to generate attestation cert - skipping flag.", e);
                        trySetAttestationChallenge = false;
                        continue;
                    }
                    this.clearAsymmetricKey();
                    throw e;
                }
            }
            int length = RSAKeyUtils.keyBitLength((PrivateKey)kp.getPrivate());
            if (length < minKeySize && length >= 0) continue;
            this.getSecureHardwareState(kp);
            return kp;
        }
        this.clearAsymmetricKey();
        throw new UnsupportedOperationException("Failed to generate valid KeyPair. Attempted 4 times.");
    }

    private static boolean isStrongBoxUnavailableException(@NonNull Throwable t) {
        boolean isStrongBoxException = t.getClass().getSimpleName().equals(STRONG_BOX_UNAVAILABLE_EXCEPTION);
        if (isStrongBoxException) {
            Logger.error(TAG + ":isStrongBoxUnavailableException", "StrongBox not supported.", t);
        }
        return isStrongBoxException;
    }

    private SecureHardwareState getSecureHardwareState(@NonNull KeyPair kp) {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                PrivateKey privateKey = kp.getPrivate();
                KeyFactory factory = KeyFactory.getInstance(privateKey.getAlgorithm(), ANDROID_KEYSTORE);
                KeyInfo info = factory.getKeySpec(privateKey, KeyInfo.class);
                boolean isInsideSecureHardware = info.isInsideSecureHardware();
                Logger.info(TAG, "SecretKey is secure hardware backed? " + isInsideSecureHardware);
                return isInsideSecureHardware ? SecureHardwareState.TRUE_UNATTESTED : SecureHardwareState.FALSE;
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                Logger.error(TAG, "Failed to query secure hardware state.", e);
                return SecureHardwareState.UNKNOWN_QUERY_ERROR;
            }
        }
        Logger.info(TAG, "Cannot query secure hardware state (API unavailable <23)");
        return SecureHardwareState.UNKNOWN_DOWNLEVEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=18)
    private KeyPair generateNewKeyPair(@NonNull Context context, boolean useStrongbox, boolean enableImport, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StrongBoxUnavailableException {
        Object object = DateUtilities.isLocaleCalendarNonGregorian((Locale)Locale.getDefault()) ? DateUtilities.LOCALE_CHANGE_LOCK : new Object();
        synchronized (object) {
            KeyPair keyPair;
            Locale currentLocale = Locale.getDefault();
            StorageHelper.applyKeyStoreLocaleWorkarounds(currentLocale);
            try {
                KeyPair keyPair2;
                KeyPairGenerator kpg = this.getInitializedRsaKeyPairGenerator(context, 2048, useStrongbox, enableImport, trySetAttestationChallenge);
                keyPair = keyPair2 = kpg.generateKeyPair();
            }
            catch (Throwable throwable) {
                Locale.setDefault(currentLocale);
                throw throwable;
            }
            Locale.setDefault(currentLocale);
            return keyPair;
        }
    }

    @RequiresApi(api=18)
    private KeyPairGenerator getInitializedRsaKeyPairGenerator(@NonNull Context context, int keySize, boolean useStrongbox, boolean enableImport, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE);
        this.initialize(context, keyPairGenerator, keySize, useStrongbox, enableImport, trySetAttestationChallenge);
        return keyPairGenerator;
    }

    @RequiresApi(api=18)
    private void initialize(@NonNull Context context, @NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox, boolean enableImport, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException {
        if (Build.VERSION.SDK_INT < 23) {
            this.initializePre23(context, keyPairGenerator, keySize);
        } else if (Build.VERSION.SDK_INT < 28) {
            this.initialize23(keyPairGenerator, keySize, useStrongbox, trySetAttestationChallenge);
        } else {
            this.initialize28(keyPairGenerator, keySize, useStrongbox, enableImport, trySetAttestationChallenge);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresApi(api=23)
    private void initialize23(@NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.mKeyManager.getKeyAlias(), 15).setKeySize(keySize).setSignaturePaddings(new String[]{"PKCS1"}).setDigests(new String[]{"NONE", "SHA-1", "SHA-256"}).setEncryptionPaddings(new String[]{"OAEPPadding", "PKCS1Padding"});
        if (trySetAttestationChallenge && Build.VERSION.SDK_INT >= 24) {
            builder = this.setAttestationChallenge(builder);
        }
        if (Build.VERSION.SDK_INT >= 28 && useStrongbox) {
            Logger.verbose(TAG, "Attempting to apply StrongBox isolation.");
            builder = DevicePopManager.applyHardwareIsolation(builder);
        }
        KeyGenParameterSpec spec = builder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=24)
    @NonNull
    private KeyGenParameterSpec.Builder setAttestationChallenge(@NonNull KeyGenParameterSpec.Builder builder) {
        return builder.setAttestationChallenge(new byte[0]);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=28)
    @NonNull
    private static KeyGenParameterSpec.Builder applyHardwareIsolation(@NonNull KeyGenParameterSpec.Builder builder) {
        return builder.setIsStrongBoxBacked(true);
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresApi(api=28)
    private void initialize28(@NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox, boolean enableImport, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException {
        int purposes = 15;
        if (enableImport && Build.VERSION.SDK_INT >= 28) {
            purposes |= 0x20;
        }
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.mKeyManager.getKeyAlias(), purposes).setKeySize(keySize).setSignaturePaddings(new String[]{"PKCS1"}).setDigests(new String[]{"NONE", "SHA-1", "SHA-256"}).setEncryptionPaddings(new String[]{"OAEPPadding", "PKCS1Padding"});
        if (trySetAttestationChallenge && Build.VERSION.SDK_INT >= 24) {
            builder = this.setAttestationChallenge(builder);
        }
        if (Build.VERSION.SDK_INT >= 28 && useStrongbox) {
            Logger.verbose(TAG, "Attempting to apply StrongBox isolation.");
            builder = DevicePopManager.applyHardwareIsolation(builder);
        }
        KeyGenParameterSpec spec = builder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=18)
    private void initializePre23(@NonNull Context context, @NonNull KeyPairGenerator keyPairGenerator, int keySize) throws InvalidAlgorithmParameterException {
        Calendar calendar = Calendar.getInstance();
        Date start = DevicePopManager.getNow(calendar);
        calendar.add(1, 99);
        Date end = calendar.getTime();
        KeyPairGeneratorSpec.Builder specBuilder = new KeyPairGeneratorSpec.Builder(context).setAlias(this.mKeyManager.getKeyAlias()).setStartDate(start).setEndDate(end).setSerialNumber(CertificateProperties.SERIAL_NUMBER).setSubject(new X500Principal("CN=device-pop"));
        if (Build.VERSION.SDK_INT >= 19) {
            specBuilder.setAlgorithmParameterSpec((AlgorithmParameterSpec)new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4));
        }
        KeyPairGeneratorSpec spec = specBuilder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    private static Date getNow(@NonNull Calendar calendar) {
        return calendar.getTime();
    }

    private static KeyPair getKeyPairForEntry(@NonNull KeyStore.PrivateKeyEntry entry) {
        PrivateKey privateKey = entry.getPrivateKey();
        PublicKey publicKey = entry.getCertificate().getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public PublicKey getPublicKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry();
        return keyEntry.getCertificate().getPublicKey();
    }

    private static RSAKey getRsaKeyForKeyPair(@NonNull KeyPair keyPair) {
        return new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).keyUse(null).build();
    }

    private static String getReqCnfForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException, JSONException {
        String thumbprintStr = DevicePopManager.getThumbprintForRsaKey(rsaKey);
        String thumbprintMinifiedJson = new JSONObject().put("kid", (Object)thumbprintStr).toString();
        return DevicePopManager.base64UrlEncode(thumbprintMinifiedJson);
    }

    private static String getThumbprintForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException {
        Base64URL thumbprint = rsaKey.computeThumbprint();
        return thumbprint.toString();
    }

    private static String base64UrlEncode(@NonNull String input) {
        byte[] encodeBytes = input.getBytes(UTF8);
        return Base64.encodeToString((byte[])encodeBytes, (int)11);
    }

    private Map<String, Object> getDevicePopJwkMinifiedJson() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)this.mKeyManager.getEntry();
        KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
        RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
        RSAKey publicRsaKey = rsaKey.toPublicJWK();
        Map jwkContents = publicRsaKey.toJSONObject();
        HashMap<String, Object> wrappedJwk = new HashMap<String, Object>();
        wrappedJwk.put("jwk", jwkContents);
        return wrappedJwk;
    }

    static final class KeyPairGeneratorAlgorithms {
        static final String RSA = "RSA";

        KeyPairGeneratorAlgorithms() {
        }
    }

    private static final class SignedHttpRequestJwtClaims {
        private static final String ACCESS_TOKEN = "at";
        private static final String TIMESTAMP = "ts";
        private static final String HTTP_METHOD = "m";
        private static final String HTTP_HOST = "u";
        private static final String HTTP_PATH = "p";
        private static final String CNF = "cnf";
        private static final String NONCE = "nonce";
        private static final String CLIENT_CLAIMS = "client_claims";
        public static final String JWK = "jwk";

        private SignedHttpRequestJwtClaims() {
        }
    }

    private static final class CertificateProperties {
        static final int CERTIFICATE_VALIDITY_YEARS = 99;
        static final BigInteger SERIAL_NUMBER = BigInteger.ONE;
        static final String COMMON_NAME = "CN=device-pop";

        private CertificateProperties() {
        }
    }
}

