/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.os.Build;
import android.security.keystore.KeyInfo;
import com.microsoft.identity.common.internal.util.Supplier;
import com.microsoft.identity.common.java.crypto.IAndroidKeyStoreKeyManager;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.logging.Logger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import lombok.NonNull;

public class DeviceKeyManager<K extends KeyStore.Entry>
implements IAndroidKeyStoreKeyManager<K> {
    private static final String TAG = DeviceKeyManager.class.getSimpleName();
    private final KeyStore mKeyStore;
    private final String mKeyAlias;
    private final Supplier<byte[]> mThumbprintSupplier;

    public DeviceKeyManager(@NonNull KeyStore keyStore, @NonNull String keyAlias, @NonNull Supplier<byte[]> thumbprintSupplier) throws KeyStoreException {
        if (keyStore == null) {
            throw new NullPointerException("keyStore is marked non-null but is null");
        }
        if (keyAlias == null) {
            throw new NullPointerException("keyAlias is marked non-null but is null");
        }
        if (thumbprintSupplier == null) {
            throw new NullPointerException("thumbprintSupplier is marked non-null but is null");
        }
        this.mKeyAlias = keyAlias;
        this.mThumbprintSupplier = thumbprintSupplier;
        this.mKeyStore = keyStore;
    }

    public boolean exists() {
        boolean exists = false;
        try {
            exists = this.mKeyStore.containsAlias(this.mKeyAlias);
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while querying KeyStore", e);
        }
        return exists;
    }

    public boolean hasThumbprint(@NonNull byte[] thumbprint) {
        if (thumbprint == null) {
            throw new NullPointerException("thumbprint is marked non-null but is null");
        }
        return Arrays.equals(thumbprint, this.mThumbprintSupplier.get());
    }

    public Date getCreationDate() throws ClientException {
        try {
            return this.mKeyStore.getCreationDate(this.mKeyAlias);
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while getting creation date for alias " + this.mKeyAlias, e);
            throw new ClientException("keystore_not_initialized", e.getMessage(), (Throwable)e);
        }
    }

    public boolean clear() {
        boolean deleted = false;
        try {
            this.mKeyStore.deleteEntry(this.mKeyAlias);
            deleted = true;
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while clearing KeyStore", e);
        }
        return deleted;
    }

    public K getEntry() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        return (K)this.mKeyStore.getEntry(this.mKeyAlias, null);
    }

    public void importKey(@NonNull byte[] jwk, @NonNull String algorithm) throws ClientException {
        if (jwk == null) {
            throw new NullPointerException("jwk is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        throw new UnsupportedOperationException("This is not currently supported");
    }

    public byte[] getThumbprint() {
        return this.mThumbprintSupplier.get();
    }

    public Certificate[] getCertificateChain() throws ClientException {
        try {
            return this.mKeyStore.getCertificateChain(this.mKeyAlias);
        }
        catch (KeyStoreException e) {
            KeyStoreException exception = e;
            String errCode = "keystore_not_initialized";
            ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
            Logger.error(TAG, clientException.getMessage(), clientException);
            throw clientException;
        }
    }

    public SecureHardwareState getSecureHardwareState() throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        try {
            K entry = this.getEntry();
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                if (Build.VERSION.SDK_INT >= 23) {
                    try {
                        PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
                        KeyFactory factory = KeyFactory.getInstance(privateKey.getAlgorithm(), this.mKeyStore.getProvider());
                        KeyInfo info = factory.getKeySpec(privateKey, KeyInfo.class);
                        boolean isInsideSecureHardware = info.isInsideSecureHardware();
                        Logger.info(TAG, "PrivateKey is secure hardware backed? " + isInsideSecureHardware);
                        return isInsideSecureHardware ? SecureHardwareState.TRUE_UNATTESTED : SecureHardwareState.FALSE;
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        Logger.error(TAG, "Failed to query secure hardware state.", e);
                        return SecureHardwareState.UNKNOWN_QUERY_ERROR;
                    }
                }
                Logger.info(TAG, "Cannot query secure hardware state (API unavailable <23)");
                return SecureHardwareState.UNKNOWN_DOWNLEVEL;
            }
            if (entry instanceof KeyStore.SecretKeyEntry) {
                if (Build.VERSION.SDK_INT >= 23) {
                    try {
                        SecretKey privateKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                        SecretKeyFactory factory = SecretKeyFactory.getInstance(privateKey.getAlgorithm(), this.mKeyStore.getProvider());
                        KeyInfo info = (KeyInfo)factory.getKeySpec(privateKey, KeyInfo.class);
                        boolean isInsideSecureHardware = info.isInsideSecureHardware();
                        Logger.info(TAG, "SecretKey is secure hardware backed? " + isInsideSecureHardware);
                        return isInsideSecureHardware ? SecureHardwareState.TRUE_UNATTESTED : SecureHardwareState.FALSE;
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        Logger.error(TAG, "Failed to query secure hardware state.", e);
                        return SecureHardwareState.UNKNOWN_QUERY_ERROR;
                    }
                }
                Logger.info(TAG, "Cannot query secure hardware state (API unavailable <23)");
                return SecureHardwareState.UNKNOWN_DOWNLEVEL;
            }
            throw new ClientException("unknown_error", "Cannot handle entries of type " + entry.getClass().getCanonicalName());
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error(TAG + ":getSecureHardwareState", errCode, exception);
        throw clientException;
    }

    public static <K extends KeyStore.Entry> DeviceKeyManagerBuilder<K> builder() {
        return new DeviceKeyManagerBuilder();
    }

    public String getKeyAlias() {
        return this.mKeyAlias;
    }

    public static class DeviceKeyManagerBuilder<K extends KeyStore.Entry> {
        private KeyStore keyStore;
        private String keyAlias;
        private Supplier<byte[]> thumbprintSupplier;

        DeviceKeyManagerBuilder() {
        }

        public DeviceKeyManagerBuilder<K> keyStore(@NonNull KeyStore keyStore) {
            if (keyStore == null) {
                throw new NullPointerException("keyStore is marked non-null but is null");
            }
            this.keyStore = keyStore;
            return this;
        }

        public DeviceKeyManagerBuilder<K> keyAlias(@NonNull String keyAlias) {
            if (keyAlias == null) {
                throw new NullPointerException("keyAlias is marked non-null but is null");
            }
            this.keyAlias = keyAlias;
            return this;
        }

        public DeviceKeyManagerBuilder<K> thumbprintSupplier(@NonNull Supplier<byte[]> thumbprintSupplier) {
            if (thumbprintSupplier == null) {
                throw new NullPointerException("thumbprintSupplier is marked non-null but is null");
            }
            this.thumbprintSupplier = thumbprintSupplier;
            return this;
        }

        public DeviceKeyManager<K> build() throws KeyStoreException {
            return new DeviceKeyManager(this.keyStore, this.keyAlias, this.thumbprintSupplier);
        }

        public String toString() {
            return "DeviceKeyManager.DeviceKeyManagerBuilder(keyStore=" + this.keyStore + ", keyAlias=" + this.keyAlias + ", thumbprintSupplier=" + this.thumbprintSupplier + ")";
        }
    }
}

