/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.commands.DeviceCodeFlowCommandCallback;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.TokenCommand;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DeviceCodeFlowCommand
extends TokenCommand {
    private static final String TAG = DeviceCodeFlowCommand.class.getSimpleName();

    public DeviceCodeFlowCommand(@NonNull DeviceCodeFlowCommandParameters parameters, @NonNull BaseController controller, @NonNull DeviceCodeFlowCommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controller, (CommandCallback)callback, publicApiId);
    }

    public AcquireTokenResult execute() throws Exception {
        String methodName = ":execute";
        Logger.verbose((String)(TAG + ":execute"), (String)"Device Code Flow command initiating...");
        BaseController controller = this.getDefaultController();
        DeviceCodeFlowCommandParameters commandParameters = (DeviceCodeFlowCommandParameters)this.getParameters();
        AuthorizationResult authorizationResult = controller.deviceCodeFlowAuthRequest(commandParameters);
        MicrosoftStsAuthorizationResponse authorizationResponse = (MicrosoftStsAuthorizationResponse)authorizationResult.getAuthorizationResponse();
        Date expiredDate = new Date();
        try {
            long expiredInInMilliseconds = TimeUnit.SECONDS.toMillis(Long.parseLong(authorizationResponse.getExpiresIn()));
            expiredDate.setTime(expiredDate.getTime() + expiredInInMilliseconds);
        }
        catch (NumberFormatException e) {
            Logger.error((String)(TAG + ":execute"), (String)"Failed to parse authorizationResponse.getExpiresIn()", (Throwable)e);
        }
        DeviceCodeFlowCommandCallback deviceCodeFlowCommandCallback = (DeviceCodeFlowCommandCallback)this.getCallback();
        deviceCodeFlowCommandCallback.onUserCodeReceived(authorizationResponse.getVerificationUri(), authorizationResponse.getUserCode(), authorizationResponse.getMessage(), expiredDate);
        AcquireTokenResult tokenResult = controller.acquireDeviceCodeFlowToken(authorizationResult, commandParameters);
        Logger.verbose((String)(TAG + ":execute"), (String)"Device Code Flow command exiting with token...");
        return tokenResult;
    }

    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    public void onFinishAuthorizationSession(int requestCode, int resultCode, @NonNull PropertyBag data) {
        throw new UnsupportedOperationException();
    }
}

