/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.logging.Logger;

public class HelloCache {
    private static final String TAG = HelloCache.class.getSimpleName();
    private static final String SHARED_PREFERENCE_NAME = "com.microsoft.common.ipc.hello.cache";
    private final INameValueStorage<String> mFileManager;
    private final Context mContext;
    private final String mProtocolName;
    private final String mTargetAppPackageName;
    private static boolean sIsEnabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIsEnabled(boolean value) {
        Class<HelloCache> clazz = HelloCache.class;
        synchronized (HelloCache.class) {
            sIsEnabled = value;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public HelloCache(@NonNull Context context, @NonNull String protocolName, @NonNull String targetAppPackageName, @NonNull IPlatformComponents components) {
        this.mFileManager = components.getNameValueStore(SHARED_PREFERENCE_NAME, String.class);
        this.mContext = context;
        this.mProtocolName = protocolName;
        this.mTargetAppPackageName = targetAppPackageName;
    }

    @Nullable
    public String tryGetNegotiatedProtocolVersion(@Nullable String clientMinimumProtocolVersion, @NonNull String clientMaximumProtocolVersion) {
        String key;
        String methodName = ":tryGetNegotiatedProtocolVersion";
        if (!sIsEnabled) {
            Logger.infoPII(TAG + ":tryGetNegotiatedProtocolVersion", "hello cache is not enabled.");
            return null;
        }
        try {
            key = this.getNegotiatedProtocolVersionCacheKey(clientMinimumProtocolVersion, clientMaximumProtocolVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(TAG + ":tryGetNegotiatedProtocolVersion", "Failed to retrieve key", e);
            return null;
        }
        return (String)this.mFileManager.get(key);
    }

    public void saveNegotiatedProtocolVersion(@Nullable String clientMinimumProtocolVersion, @NonNull String clientMaximumProtocolVersion, @NonNull String negotiatedProtocolVersion) {
        String key;
        String methodName = ":saveNegotiatedProtocolVersion";
        if (!sIsEnabled) {
            Logger.infoPII(TAG + ":saveNegotiatedProtocolVersion", "hello cache is not enabled.");
            return;
        }
        try {
            key = this.getNegotiatedProtocolVersionCacheKey(clientMinimumProtocolVersion, clientMaximumProtocolVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(TAG + ":saveNegotiatedProtocolVersion", "Failed to retrieve key", e);
            return;
        }
        this.mFileManager.put(key, (Object)negotiatedProtocolVersion);
    }

    @NonNull
    private String getNegotiatedProtocolVersionCacheKey(@Nullable String clientMinimumProtocolVersion, @NonNull String clientMaximumProtocolVersion) throws PackageManager.NameNotFoundException {
        return this.mProtocolName + "[" + clientMinimumProtocolVersion + "," + clientMaximumProtocolVersion + "]:" + this.mTargetAppPackageName + "[" + this.getVersionCode() + "]";
    }

    @VisibleForTesting
    public void clearCache() {
        this.mFileManager.clear();
    }

    @VisibleForTesting
    @NonNull
    public String getVersionCode() throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(this.mTargetAppPackageName, 0);
        if (Build.VERSION.SDK_INT >= 28) {
            return String.valueOf(packageInfo.getLongVersionCode());
        }
        return String.valueOf(packageInfo.versionCode);
    }
}

