/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.tokensharing;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.cache.ADALTokenCacheItem;
import com.microsoft.identity.common.adal.internal.tokensharing.ITokenShareInternal;
import com.microsoft.identity.common.adal.internal.tokensharing.ITokenShareResultInternal;
import com.microsoft.identity.common.adal.internal.tokensharing.TokenShareResultInternal;
import com.microsoft.identity.common.adal.tokensharing.SSOStateSerializer;
import com.microsoft.identity.common.internal.migration.AdalMigrationAdapter;
import com.microsoft.identity.common.internal.migration.TokenCacheItemMigrationAdapter;
import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.ITokenCacheItem;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.logging.Logger;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class TokenShareUtility
implements ITokenShareInternal {
    private static final String TAG = TokenShareUtility.class.getSimpleName();
    private static final Map<String, String> sClaimRemapper = new HashMap<String, String>();
    private static final String CONSUMERS_ENDPOINT = "https://login.microsoftonline.com/consumers";
    private final String mClientId;
    private final String mRedirectUri;
    private final MsalOAuth2TokenCache mTokenCache;

    private static void applyV1ToV2Mappings() {
        sClaimRemapper.put("preferred_username", "upn");
    }

    public TokenShareUtility(@NonNull String clientId, @NonNull String redirectUri, @NonNull MsalOAuth2TokenCache cache) {
        this.mClientId = clientId;
        this.mRedirectUri = redirectUri;
        this.mTokenCache = cache;
    }

    @Override
    public ITokenShareResultInternal getOrgIdFamilyRefreshTokenWithMetadata(@NonNull String identifier) throws BaseException {
        ICacheRecord cacheRecord = this.getCacheRecordForIdentifier(identifier);
        this.throwIfCacheRecordIncomplete(identifier, cacheRecord);
        ADALTokenCacheItem cacheItemToExport = TokenShareUtility.adapt(cacheRecord.getIdToken(), cacheRecord.getRefreshToken());
        return new TokenShareResultInternal(cacheRecord, SSOStateSerializer.serialize(cacheItemToExport), "SSO_STATE_SERIALIZER_BLOB");
    }

    @Override
    @NonNull
    public String getOrgIdFamilyRefreshToken(@NonNull String identifier) throws BaseException {
        return this.getOrgIdFamilyRefreshTokenWithMetadata(identifier).getRefreshToken();
    }

    private void throwIfCacheRecordIncomplete(@NonNull String identifier, @NonNull ICacheRecord cacheRecord) throws ClientException {
        if (null == cacheRecord.getRefreshToken() || null == cacheRecord.getIdToken()) {
            String methodName = ":throwIfCacheRecordIncomplete";
            Logger.warn(TAG + ":throwIfCacheRecordIncomplete", "That's strange, we had an AccountRecord for identifier: " + identifier + " but couldn't find tokens for them.");
            throw new ClientException("token_cache_item_not_found");
        }
    }

    private ICacheRecord getCacheRecordForIdentifier(@NonNull String identifier) throws ClientException {
        AccountRecord localAccountRecord = this.getAccountRecordForIdentifier(identifier);
        return this.mTokenCache.load(this.mClientId, null, localAccountRecord, (AbstractAuthenticationScheme)new BearerAuthenticationSchemeInternal());
    }

    private AccountRecord getAccountRecordForIdentifier(@NonNull String identifier) throws ClientException {
        List accountRecords;
        AccountRecord localAccountRecord = this.mTokenCache.getAccountByLocalAccountId(null, this.mClientId, identifier);
        if (null == localAccountRecord && !(accountRecords = this.mTokenCache.getAccountsByUsername(null, this.mClientId, identifier)).isEmpty()) {
            localAccountRecord = (AccountRecord)accountRecords.get(0);
        }
        if (null == localAccountRecord) {
            throw new ClientException("token_cache_item_not_found");
        }
        return localAccountRecord;
    }

    @Override
    public void saveOrgIdFamilyRefreshToken(final @NonNull String ssoStateSerializerBlob) throws Exception {
        String methodName = "saveOrgIdFamilyRefreshToken";
        Future<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>> resultFuture = TokenCacheItemMigrationAdapter.sBackgroundExecutor.submit(new Callable<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>>(){

            @Override
            public Map.Entry<MicrosoftAccount, MicrosoftRefreshToken> call() throws ClientException {
                ADALTokenCacheItem cacheItemToRenew = SSOStateSerializer.deserialize(ssoStateSerializerBlob);
                cacheItemToRenew.setClientId(TokenShareUtility.this.mClientId);
                cacheItemToRenew.setResource(null);
                boolean cloudMetadataLoaded = AdalMigrationAdapter.loadCloudDiscoveryMetadata();
                if (!cloudMetadataLoaded) {
                    Logger.warn(TAG + "saveOrgIdFamilyRefreshToken", "Failed to load cloud metadata, aborting.");
                    return null;
                }
                return TokenCacheItemMigrationAdapter.renewToken(TokenShareUtility.this.mRedirectUri, (ITokenCacheItem)cacheItemToRenew);
            }
        });
        Map.Entry<MicrosoftAccount, MicrosoftRefreshToken> result = resultFuture.get();
        this.saveResult(result);
    }

    @Override
    public ITokenShareResultInternal getMsaFamilyRefreshTokenWithMetadata(@NonNull String identifier) throws Exception {
        ICacheRecord cacheRecord = this.getCacheRecordForIdentifier(identifier);
        this.throwIfCacheRecordIncomplete(identifier, cacheRecord);
        TokenShareResultInternal result = new TokenShareResultInternal(cacheRecord, cacheRecord.getRefreshToken().getSecret(), "RAW");
        return result;
    }

    private void saveResult(@Nullable Map.Entry<MicrosoftAccount, MicrosoftRefreshToken> result) throws ClientException {
        if (null != result) {
            this.mTokenCache.setSingleSignOnState((BaseAccount)result.getKey(), (RefreshToken)result.getValue());
        }
    }

    @Override
    public String getMsaFamilyRefreshToken(@NonNull String identifier) throws Exception {
        return this.getMsaFamilyRefreshTokenWithMetadata(identifier).getRefreshToken();
    }

    @Override
    public void saveMsaFamilyRefreshToken(final @NonNull String refreshToken) throws Exception {
        String methodName = "saveMsaFamilyRefreshToken";
        Future<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>> resultFuture = TokenCacheItemMigrationAdapter.sBackgroundExecutor.submit(new Callable<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>>(){

            @Override
            public Map.Entry<MicrosoftAccount, MicrosoftRefreshToken> call() throws ClientException {
                ADALTokenCacheItem cacheItemToRenew = TokenShareUtility.this.createTokenCacheItem(refreshToken, TokenShareUtility.CONSUMERS_ENDPOINT);
                boolean cloudMetadataLoaded = AdalMigrationAdapter.loadCloudDiscoveryMetadata();
                if (!cloudMetadataLoaded) {
                    Logger.warn(TAG + "saveMsaFamilyRefreshToken", "Failed to load cloud metadata, aborting.");
                    return null;
                }
                return TokenCacheItemMigrationAdapter.renewToken(TokenShareUtility.this.mRedirectUri, (ITokenCacheItem)cacheItemToRenew);
            }
        });
        Map.Entry<MicrosoftAccount, MicrosoftRefreshToken> resultKeyValuePair = resultFuture.get();
        this.saveResult(resultKeyValuePair);
    }

    private ADALTokenCacheItem createTokenCacheItem(@NonNull String refreshToken, @NonNull String authority) {
        ADALTokenCacheItem cacheItem = new ADALTokenCacheItem();
        cacheItem.setAuthority(authority);
        cacheItem.setClientId(this.mClientId);
        cacheItem.setRefreshToken(refreshToken);
        return cacheItem;
    }

    @NonNull
    private static ADALTokenCacheItem adapt(@NonNull IdTokenRecord idTokenRecord, @NonNull RefreshTokenRecord refreshTokenRecord) throws BaseException {
        ADALTokenCacheItem tokenCacheItem = new ADALTokenCacheItem();
        tokenCacheItem.setClientId(refreshTokenRecord.getClientId());
        tokenCacheItem.setRefreshToken(refreshTokenRecord.getSecret());
        tokenCacheItem.setRawIdToken(TokenShareUtility.mintV1IdTokenFromRawV2IdToken(idTokenRecord.getSecret()));
        tokenCacheItem.setFamilyClientId(refreshTokenRecord.getFamilyId());
        String authority = TokenShareUtility.isFromHomeTenant(idTokenRecord) ? Environment.toEnvironment(refreshTokenRecord.getEnvironment()).getCommonEndpoint() : idTokenRecord.getAuthority();
        tokenCacheItem.setAuthority(authority);
        return tokenCacheItem;
    }

    private static boolean isFromHomeTenant(@NonNull IdTokenRecord idTokenRecord) {
        boolean isHomeTenant;
        String methodName = ":isFromHomeTenant";
        String homeAccountId = idTokenRecord.getHomeAccountId();
        try {
            Map tokenClaims = IDToken.parseJWT((String)idTokenRecord.getSecret());
            String oid = (String)tokenClaims.get("oid");
            if (null != oid) {
                isHomeTenant = homeAccountId.contains(oid);
            } else {
                Logger.warn(TAG + ":isFromHomeTenant", "OID claims was missing from token.");
                isHomeTenant = false;
            }
        }
        catch (ServiceException e) {
            Logger.warn(TAG + ":isFromHomeTenant", "Failed to parse IdToken.");
            isHomeTenant = false;
        }
        return isHomeTenant;
    }

    @NonNull
    private static String mintV1IdTokenFromRawV2IdToken(@NonNull String rawV2IdToken) throws ServiceException {
        Map v2TokenClaims = IDToken.parseJWT((String)rawV2IdToken);
        JWTClaimsSet.Builder claimsSetBuilder = new JWTClaimsSet.Builder();
        for (Map.Entry claimEntry : v2TokenClaims.entrySet()) {
            String claimKey = (String)claimEntry.getKey();
            Object claimValue = claimEntry.getValue();
            if ("ver".equals(claimKey)) {
                claimValue = "1";
            }
            claimsSetBuilder.claim(TokenShareUtility.remap(claimKey), claimValue);
        }
        JWTClaimsSet v1TokenClaims = claimsSetBuilder.build();
        PlainHeader plainHeader = new PlainHeader(JOSEObjectType.JWT, null, null, null, null);
        PlainJWT outboundJwt = new PlainJWT(plainHeader, v1TokenClaims);
        return outboundJwt.serialize();
    }

    @NonNull
    private static String remap(@NonNull String claimKey) {
        String remappedValue = sClaimRemapper.get(claimKey);
        if (null == remappedValue) {
            remappedValue = claimKey;
        }
        return remappedValue;
    }

    static {
        TokenShareUtility.applyV1ToV2Mappings();
    }

    private static enum Environment {
        WORLDWIDE("https://login.windows.net/common"),
        GALLATIN("https://login.partner.microsoftonline.cn/common"),
        BLACKFOREST("https://login.microsoftonline.de/common"),
        ITAR("https://login.microsoftonline.us/common");

        private String mCommonEndpoint;

        private Environment(String commonEndpoint) {
            this.mCommonEndpoint = commonEndpoint;
        }

        @NonNull
        static Environment toEnvironment(@NonNull String envString) throws ClientException {
            switch (envString) {
                case "login.microsoftonline.com": 
                case "login.windows.net": 
                case "login.microsoft.com": 
                case "sts.windows.net": {
                    return WORLDWIDE;
                }
                case "login.chinacloudapi.cn": 
                case "login.partner.microsoftonline.cn": {
                    return GALLATIN;
                }
                case "login.usgovcloudapi.net": 
                case "login.microsoftonline.us": {
                    return ITAR;
                }
                case "login.microsoftonline.de": {
                    return BLACKFOREST;
                }
            }
            Logger.warn(TAG, "Unable to map provided env to enum: " + envString);
            throw new ClientException("Unrecognized environment");
        }

        String getCommonEndpoint() {
            return this.mCommonEndpoint;
        }
    }
}

