/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.ui.webview.authorization.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.logging.Logger;
import java.util.Map;

public final class PKeyAuthChallengeHandler
implements IChallengeHandler<PKeyAuthChallenge, Void> {
    private static final String TAG = PKeyAuthChallengeHandler.class.getSimpleName();
    private final WebView mWebView;
    private final IAuthorizationCompletionCallback mChallengeCallback;

    public PKeyAuthChallengeHandler(@NonNull WebView view, @NonNull IAuthorizationCompletionCallback completionCallback) {
        this.mWebView = view;
        this.mChallengeCallback = completionCallback;
    }

    @Override
    public Void processChallenge(final PKeyAuthChallenge pKeyAuthChallenge) {
        block3: {
            this.mWebView.stopLoading();
            this.mChallengeCallback.setPKeyAuthStatus(true);
            try {
                final Map header = pKeyAuthChallenge.getChallengeHeader();
                this.mWebView.post(new Runnable(){

                    @Override
                    public void run() {
                        String loadUrl = pKeyAuthChallenge.getSubmitUrl();
                        Logger.info(TAG, "Respond to pkeyAuth challenge");
                        Logger.infoPII(TAG, "Challenge submit url:" + pKeyAuthChallenge.getSubmitUrl());
                        PKeyAuthChallengeHandler.this.mWebView.loadUrl(loadUrl, header);
                    }
                });
            }
            catch (Throwable e) {
                this.mChallengeCallback.onChallengeResponseReceived(RawAuthorizationResult.fromThrowable((Throwable)e));
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(e instanceof Error)) break block3;
                throw (Error)e;
            }
        }
        return null;
    }
}

