/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.ui.webview.ProcessUtil;
import com.microsoft.identity.common.logging.Logger;

public class WebViewUtil {
    private static final String TAG = WebViewUtil.class.getSimpleName();

    @SuppressLint(value={"NewApi"})
    public static void setDataDirectorySuffix(@NonNull Context context) {
        String methodName = ":setDataDirectorySuffix";
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                if (ProcessUtil.isRunningOnAuthService(context)) {
                    WebView.setDataDirectorySuffix((String)"auth");
                }
            }
            catch (IllegalStateException e) {
                Logger.warn(TAG + ":setDataDirectorySuffix", "WebView is already initialized. IllegalStateException is expected when setDataDirectorySuffix() is invoked");
            }
        }
    }

    public static void setAcceptCookie(boolean acceptCookie, Context context) {
        CookieManager cookieManager = WebViewUtil.getCookieManager(context);
        cookieManager.setAcceptCookie(acceptCookie);
    }

    public static void removeCookiesFromWebView(Context context) {
        CookieManager cookieManager = WebViewUtil.getCookieManager(context);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeAllCookies(null);
            cookieManager.flush();
        } else {
            CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
            cookieManager.removeAllCookie();
            syncManager.sync();
        }
    }

    public static void removeSessionCookiesFromWebView(Context context) {
        CookieManager cookieManager = WebViewUtil.getCookieManager(context);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeAllCookies(null);
            cookieManager.flush();
        } else {
            CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
            cookieManager.removeSessionCookie();
            syncManager.sync();
        }
    }

    private static CookieManager getCookieManager(Context context) {
        WebViewUtil.setDataDirectorySuffix(context);
        return CookieManager.getInstance();
    }
}

