/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry;

import android.content.Context;
import android.content.pm.PackageManager;
import com.microsoft.identity.common.internal.telemetry.AndroidTelemetryContext;
import com.microsoft.identity.common.internal.telemetry.TelemetryConfiguration;
import com.microsoft.identity.common.java.telemetry.AbstractTelemetryContext;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.telemetry.observers.ITelemetryObserver;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import lombok.NonNull;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public class Telemetry
extends com.microsoft.identity.common.java.telemetry.Telemetry {
    private static final String TAG = Telemetry.class.getSimpleName();
    private static final Telemetry instance = new Telemetry();
    private static final com.microsoft.identity.common.java.telemetry.Telemetry actualInstance = com.microsoft.identity.common.java.telemetry.Telemetry.getInstance();

    public static synchronized Telemetry getInstance() {
        return instance;
    }

    public void addObserver(ITelemetryObserver observer) {
        actualInstance.addObserver(observer);
    }

    public void removeAllObservers() {
        actualInstance.removeAllObservers();
    }

    public void removeObserver(Class<?> cls) {
        actualInstance.removeObserver(cls);
    }

    public void removeObserver(ITelemetryObserver observer) {
        actualInstance.removeObserver(observer);
    }

    public List<ITelemetryObserver> getObservers() {
        return actualInstance.getObservers();
    }

    public void flush() {
        actualInstance.flush();
    }

    public void flush(@NonNull String correlationId) {
        if (correlationId == null) {
            throw new NullPointerException("correlationId is marked non-null but is null");
        }
        actualInstance.flush(correlationId);
    }

    public static class Builder {
        private com.microsoft.identity.common.java.telemetry.TelemetryConfiguration mDefaultConfiguration;
        private AndroidTelemetryContext mTelemetryContext;
        private Boolean mIsDebugging;

        public Builder withContext(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            Context mContext = context.getApplicationContext();
            if (mContext == null) {
                throw new IllegalArgumentException("Application context must not be null.");
            }
            this.mTelemetryContext = new AndroidTelemetryContext(mContext);
            try {
                String packageName = context.getPackageName();
                int flags = context.getPackageManager().getApplicationInfo((String)packageName, (int)0).flags;
                this.mIsDebugging = (flags & 2) != 0;
            }
            catch (PackageManager.NameNotFoundException exception) {
                Logger.warn(TAG, "The application is not found from PackageManager.");
                this.mIsDebugging = false;
            }
            return this;
        }

        public Builder defaultConfiguration(TelemetryConfiguration configuration) {
            this.mDefaultConfiguration = configuration;
            return this;
        }

        public Telemetry build() throws IllegalArgumentException {
            new Telemetry.Builder().defaultConfiguration(this.mDefaultConfiguration).isDebugging(this.mIsDebugging.booleanValue()).withTelemetryContext((AbstractTelemetryContext)this.mTelemetryContext).build();
            return instance;
        }
    }
}

