/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiEndEvent;
import com.microsoft.identity.common.java.logging.IRequestContext;
import com.microsoft.identity.common.java.logging.RequestContext;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.ported.LocalBroadcaster;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import com.microsoft.identity.common.logging.DiagnosticContext;
import com.microsoft.identity.common.logging.Logger;
import java.io.Serializable;

public abstract class AuthorizationFragment
extends Fragment {
    private static final String TAG = AuthorizationFragment.class.getSimpleName();
    private Bundle mInstanceState;
    protected boolean mAuthResultSent = false;
    private final LocalBroadcaster.IReceiverCallback mCancelRequestReceiver = new LocalBroadcaster.IReceiverCallback(){

        public void onReceive(@NonNull PropertyBag propertyBag) {
            AuthorizationFragment.this.cancelAuthorization((Boolean)propertyBag.getOrDefault("cancel_authorization_request", (Serializable)Boolean.valueOf(false)));
        }
    };

    void setInstanceState(@NonNull Bundle instanceStateBundle) {
        this.mInstanceState = instanceStateBundle;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        String methodName = "#onCreate";
        super.onCreate(savedInstanceState);
        LocalBroadcaster.INSTANCE.registerCallback("cancel_authorization_request", this.mCancelRequestReceiver);
        if (savedInstanceState == null && this.mInstanceState == null) {
            Logger.warn(TAG, "No stored state. Unable to handle response");
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            Logger.verbose(TAG + "#onCreate", "Extract state from the intent bundle.");
            this.extractState(this.mInstanceState);
        } else {
            Logger.verbose(TAG + "#onCreate", "Extract state from the saved bundle.");
            this.extractState(savedInstanceState);
        }
    }

    void finish() {
        LocalBroadcaster.INSTANCE.unregisterCallback("cancel_authorization_request");
        FragmentActivity activity = this.getActivity();
        if (activity instanceof AuthorizationActivity) {
            activity.finish();
        } else {
            FragmentManager fragmentManager = this.getFragmentManager();
            if (fragmentManager != null) {
                fragmentManager.beginTransaction().setTransitionStyle(4099).remove((Fragment)this).commit();
            }
        }
    }

    void extractState(@NonNull Bundle state) {
        AuthorizationFragment.setDiagnosticContextForNewThread(state.getString("correlation_id"));
    }

    private static void setDiagnosticContextForNewThread(String correlationId) {
        String methodName = ":setDiagnosticContextForAuthorizationActivity";
        RequestContext rc = new RequestContext();
        rc.put((Object)"correlation_id", (Object)correlationId);
        DiagnosticContext.setRequestContext((IRequestContext)rc);
        Logger.verbose(TAG + ":setDiagnosticContextForAuthorizationActivity", "Initializing diagnostic context for AuthorizationActivity");
    }

    public void onStop() {
        String methodName = ":onStop";
        FragmentActivity activity = this.getActivity();
        if (!this.mAuthResultSent && (activity == null || activity.isFinishing())) {
            Logger.info(TAG + ":onStop", "Hosting Activity is destroyed before Auth request is completed, sending request cancel");
            Telemetry.emit((BaseEvent)new UiEndEvent().isUserCancelled());
            this.sendResult(RawAuthorizationResult.ResultCode.SDK_CANCELLED);
        }
        super.onStop();
    }

    public void onDestroy() {
        String methodName = "#onDestroy";
        Logger.info(TAG + "#onDestroy", "");
        if (!this.mAuthResultSent) {
            Logger.info(TAG + "#onDestroy", "Hosting Activity is destroyed before Auth request is completed, sending request cancel");
            Telemetry.emit((BaseEvent)new UiEndEvent().isUserCancelled());
            this.sendResult(RawAuthorizationResult.ResultCode.SDK_CANCELLED);
        }
        LocalBroadcaster.INSTANCE.unregisterCallback("cancel_authorization_request");
        super.onDestroy();
    }

    public boolean onBackPressed() {
        return false;
    }

    void sendResult(RawAuthorizationResult.ResultCode resultCode) {
        this.sendResult(RawAuthorizationResult.fromResultCode((RawAuthorizationResult.ResultCode)resultCode));
    }

    void sendResult(@NonNull RawAuthorizationResult result) {
        Logger.info(TAG, "Sending result from Authorization Activity, resultCode: " + result.getResultCode());
        PropertyBag propertyBag = RawAuthorizationResult.toPropertyBag((RawAuthorizationResult)result);
        propertyBag.put("com.microsoft.identity.client.request.code", (Serializable)Integer.valueOf(1001));
        LocalBroadcaster.INSTANCE.broadcast("return_authorization_request_result", propertyBag);
        this.mAuthResultSent = true;
    }

    void cancelAuthorization(boolean isCancelledByUser) {
        if (isCancelledByUser) {
            Logger.info(TAG, "Received Authorization flow cancelled by the user");
            this.sendResult(RawAuthorizationResult.ResultCode.CANCELLED);
        } else {
            Logger.info(TAG, "Received Authorization flow cancel request from SDK");
            this.sendResult(RawAuthorizationResult.ResultCode.SDK_CANCELLED);
        }
        Telemetry.emit((BaseEvent)new UiEndEvent().isUserCancelled());
        this.finish();
    }
}

