/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.client.IMicrosoftAuthService;
import com.microsoft.identity.common.AndroidPlatformComponents;
import com.microsoft.identity.common.PropertyBagUtil;
import com.microsoft.identity.common.adal.internal.AuthenticationConstants;
import com.microsoft.identity.common.internal.broker.BrokerActivity;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.broker.ipc.AccountManagerAddAccountStrategy;
import com.microsoft.identity.common.internal.broker.ipc.BoundServiceStrategy;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.ContentProviderStrategy;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.cache.HelloCache;
import com.microsoft.identity.common.internal.commands.parameters.AndroidActivityInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BrokerOperationExecutor;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.util.AccountManagerUtil;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.commands.AcquirePrtSsoTokenResult;
import com.microsoft.identity.common.java.commands.parameters.AcquirePrtSsoTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.ResultFuture;
import com.microsoft.identity.common.java.util.ported.LocalBroadcaster;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import com.microsoft.identity.common.logging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class BrokerMsalController
extends BaseController {
    private static final String TAG = BrokerMsalController.class.getSimpleName();
    protected final MsalBrokerRequestAdapter mRequestAdapter = new MsalBrokerRequestAdapter();
    protected final MsalBrokerResultAdapter mResultAdapter = new MsalBrokerResultAdapter();
    private ResultFuture<Bundle> mBrokerResultFuture;
    private final String mActiveBrokerPackageName;
    private final BrokerOperationExecutor mBrokerOperationExecutor;
    private final HelloCache mHelloCache;
    private final IPlatformComponents mComponents;
    private final Context mApplicationContext;

    @VisibleForTesting(otherwise=5)
    public BrokerMsalController(@NonNull Context applicationContext, @NonNull IPlatformComponents components) {
        this.mComponents = components;
        this.mApplicationContext = applicationContext;
        this.mActiveBrokerPackageName = this.getActiveBrokerPackageName();
        if (StringUtil.isEmpty(this.mActiveBrokerPackageName)) {
            throw new IllegalStateException("Active Broker not found. This class should not be initialized.");
        }
        this.mBrokerOperationExecutor = new BrokerOperationExecutor(this.getIpcStrategies(this.mApplicationContext, this.mActiveBrokerPackageName));
        this.mHelloCache = this.getHelloCache();
    }

    public BrokerMsalController(@NonNull Context applicationContext) {
        this.mComponents = AndroidPlatformComponents.createFromContext(applicationContext);
        this.mApplicationContext = applicationContext;
        this.mActiveBrokerPackageName = this.getActiveBrokerPackageName();
        if (TextUtils.isEmpty((CharSequence)this.mActiveBrokerPackageName)) {
            throw new IllegalStateException("Active Broker not found. This class should not be initialized.");
        }
        this.mBrokerOperationExecutor = new BrokerOperationExecutor(this.getIpcStrategies(this.mApplicationContext, this.mActiveBrokerPackageName));
        this.mHelloCache = this.getHelloCache();
    }

    @VisibleForTesting
    public HelloCache getHelloCache() {
        return new HelloCache(this.mApplicationContext, "msal.to.broker", this.mActiveBrokerPackageName, this.mComponents);
    }

    @VisibleForTesting
    public String getActiveBrokerPackageName() {
        return new BrokerValidator(this.mApplicationContext).getCurrentActiveBrokerPackageName();
    }

    @VisibleForTesting(otherwise=2)
    @NonNull
    protected List<IIpcStrategy> getIpcStrategies(Context applicationContext, String activeBrokerPackageName) {
        MicrosoftAuthClient client;
        ArrayList<IIpcStrategy> strategies = new ArrayList<IIpcStrategy>();
        StringBuilder sb = new StringBuilder(100);
        sb.append("Broker Strategies added : ");
        ContentProviderStrategy contentProviderStrategy = new ContentProviderStrategy(applicationContext);
        if (contentProviderStrategy.isBrokerContentProviderAvailable(activeBrokerPackageName)) {
            sb.append("ContentProviderStrategy, ");
            strategies.add(contentProviderStrategy);
        }
        if ((client = new MicrosoftAuthClient(applicationContext)).isBoundServiceSupported(activeBrokerPackageName)) {
            sb.append("BoundServiceStrategy, ");
            strategies.add(new BoundServiceStrategy<IMicrosoftAuthService>(client));
        }
        if (AccountManagerUtil.canUseAccountManagerOperation(applicationContext)) {
            sb.append("AccountManagerStrategy.");
            strategies.add(new AccountManagerAddAccountStrategy(applicationContext));
        }
        Logger.info(TAG, sb.toString());
        return strategies;
    }

    @VisibleForTesting
    @NonNull
    public String hello(@NonNull IIpcStrategy strategy, @Nullable String minRequestedVersion) throws BaseException {
        String cachedProtocolVersion = this.mHelloCache.tryGetNegotiatedProtocolVersion(minRequestedVersion, AuthenticationConstants.Broker.MSAL_TO_BROKER_PROTOCOL_VERSION_CODE);
        if (!StringUtil.isEmpty(cachedProtocolVersion)) {
            return cachedProtocolVersion;
        }
        Bundle bundle = new Bundle();
        bundle.putString("broker.protocol.version.name", AuthenticationConstants.Broker.MSAL_TO_BROKER_PROTOCOL_VERSION_CODE);
        if (!StringUtil.isEmpty(minRequestedVersion)) {
            bundle.putString("required.broker.protocol.version.name", minRequestedVersion);
        }
        BrokerOperationBundle helloBundle = new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_HELLO, this.mActiveBrokerPackageName, bundle);
        String negotiatedProtocolVersion = this.mResultAdapter.verifyHelloFromResultBundle(strategy.communicateToBroker(helloBundle));
        this.mHelloCache.saveNegotiatedProtocolVersion(minRequestedVersion, AuthenticationConstants.Broker.MSAL_TO_BROKER_PROTOCOL_VERSION_CODE, negotiatedProtocolVersion);
        return negotiatedProtocolVersion;
    }

    public AcquireTokenResult acquireToken(@NonNull InteractiveTokenCommandParameters parameters) throws BaseException, InterruptedException, ExecutionException {
        AcquireTokenResult result;
        String methodName = ":acquireToken";
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((CommandParameters)parameters).putApiId("201"));
        this.mBrokerResultFuture = new ResultFuture();
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntent(parameters);
        Activity activity = null;
        if (parameters instanceof AndroidActivityInteractiveTokenCommandParameters) {
            activity = ((AndroidActivityInteractiveTokenCommandParameters)parameters).getActivity();
        }
        Intent brokerActivityIntent = new Intent(this.mApplicationContext, BrokerActivity.class);
        brokerActivityIntent.putExtra("broker_intent", (Parcelable)interactiveRequestIntent);
        LocalBroadcaster.INSTANCE.registerCallback("return_broker_interactive_acquire_token_result", new LocalBroadcaster.IReceiverCallback(){

            public void onReceive(@NonNull PropertyBag propertyBag) {
                Logger.verbose(TAG + ":acquireToken", "Received result from Broker...");
                Telemetry.emit((BaseEvent)new ApiStartEvent().putApiId("202").put("Microsoft.MSAL.request_code", ((Integer)propertyBag.getOrDefault("com.microsoft.identity.client.request.code", (Serializable)Integer.valueOf(-1))).toString()).put("Microsoft.MSAL.result_code", ((Integer)propertyBag.getOrDefault("com.microsoft.identity.client.result.code", (Serializable)Integer.valueOf(-1))).toString()));
                BrokerMsalController.this.mBrokerResultFuture.setResult((Object)PropertyBagUtil.toBundle(propertyBag));
                Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("202"));
                LocalBroadcaster.INSTANCE.unregisterCallback("return_broker_interactive_acquire_token_result");
            }
        });
        if (null == activity) {
            brokerActivityIntent.addFlags(0x10000000);
            this.mApplicationContext.startActivity(brokerActivityIntent);
        } else {
            activity.startActivity(brokerActivityIntent);
        }
        try {
            Bundle resultBundle = (Bundle)this.mBrokerResultFuture.get();
            if (parameters.getOAuth2TokenCache() != null) {
                this.saveMsaAccountToCache(resultBundle, (MsalOAuth2TokenCache)parameters.getOAuth2TokenCache());
            }
            result = new MsalBrokerResultAdapter().getAcquireTokenResultFromResultBundle(resultBundle);
        }
        catch (BaseException | ExecutionException e) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)e).putApiId("201"));
            throw e;
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(result).putApiId("201"));
        return result;
    }

    public void onFinishAuthorizationSession(int requestCode, int resultCode, @NonNull PropertyBag data) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    private Intent getBrokerAuthorizationIntent(final @NonNull InteractiveTokenCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Intent>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_INTENT_FOR_INTERACTIVE_REQUEST, BrokerMsalController.this.mActiveBrokerPackageName, null);
            }

            @Override
            @NonNull
            public Intent extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                Intent intent = BrokerMsalController.this.mResultAdapter.getIntentForInteractiveRequestFromResultBundle(resultBundle, this.negotiatedBrokerProtocolVersion);
                intent.putExtras(BrokerMsalController.this.mRequestAdapter.getRequestBundleForAcquireTokenInteractive(parameters, this.negotiatedBrokerProtocolVersion));
                return intent;
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getBrokerAuthorizationIntent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull Intent result) {
            }
        });
    }

    @NonNull
    public AcquireTokenResult acquireTokenSilent(final @NonNull SilentTokenCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<AcquireTokenResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_ACQUIRE_TOKEN_SILENT, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForAcquireTokenSilent(BrokerMsalController.this.mApplicationContext, parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public AcquireTokenResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getAcquireTokenResultFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":acquireTokenSilent";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "203";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull AcquireTokenResult result) {
                event.putResult(result);
            }
        });
    }

    @NonNull
    public List<ICacheRecord> getAccounts(final @NonNull CommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<List<ICacheRecord>>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_ACCOUNTS, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public List<ICacheRecord> extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getAccountsFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getAccounts";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "206";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    public boolean removeAccount(final @NonNull RemoveAccountCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_REMOVE_ACCOUNT, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForRemoveAccount(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                BrokerMsalController.this.mResultAdapter.verifyRemoveAccountResultFromBundle(resultBundle);
                return true;
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":removeAccount";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "207";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull Boolean result) {
            }
        });
    }

    public boolean getDeviceMode(@NonNull CommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) {
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_DEVICE_MODE, BrokerMsalController.this.mActiveBrokerPackageName, null);
            }

            @Override
            @NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getDeviceModeFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getDeviceMode";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "204";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull Boolean result) {
                event.put("Microsoft.MSAL.is_device_shared", Boolean.toString(result));
            }
        });
    }

    @NonNull
    public List<ICacheRecord> getCurrentAccount(final @NonNull CommandParameters parameters) throws BaseException {
        String methodName = ":getCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose(TAG + ":getCurrentAccount", "Not a shared device, invoke getAccounts() instead of getCurrentAccount()");
            return this.getAccounts(parameters);
        }
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<List<ICacheRecord>>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_CURRENT_ACCOUNT_IN_SHARED_DEVICE, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public List<ICacheRecord> extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getAccountsFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getCurrentAccount";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "205";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    public boolean removeCurrentAccount(final @NonNull RemoveAccountCommandParameters parameters) throws BaseException {
        String methodName = ":removeCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose(TAG + ":removeCurrentAccount", "Not a shared device, invoke removeAccount() instead of removeCurrentAccount()");
            return this.removeAccount(parameters);
        }
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_SIGN_OUT_FROM_SHARED_DEVICE, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForRemoveAccountFromSharedDevice(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                BrokerMsalController.this.mResultAdapter.verifyRemoveAccountResultFromBundle(resultBundle);
                BrokerMsalController.this.logOutFromBrowser(BrokerMsalController.this.mApplicationContext, parameters);
                return true;
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":removeCurrentAccount";
            }

            @Override
            @NonNull
            public String getTelemetryApiId() {
                return "208";
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull Boolean result) {
            }
        });
    }

    private void logOutFromBrowser(@NonNull Context context, @NonNull RemoveAccountCommandParameters parameters) {
        String methodName = ":logOutFromBrowser";
        String browserPackageName = null;
        try {
            Browser browser = BrowserSelector.select(context, parameters.getBrowserSafeList());
            browserPackageName = browser.getPackageName();
        }
        catch (ClientException e) {
            Logger.error(TAG, e.getErrorCode(), e);
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.setData(Uri.parse((String)"https://login.microsoftonline.com/common/oauth2/v2.0/logout"));
            if (browserPackageName != null) {
                intent.setPackage(browserPackageName);
            }
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(TAG + ":logOutFromBrowser", "Failed to launch browser sign out with browser=[" + browserPackageName + "]. Skipping.", e);
        }
    }

    public AuthorizationResult deviceCodeFlowAuthRequest(DeviceCodeFlowCommandParameters parameters) throws ClientException {
        throw new ClientException("deviceCodeFlowAuthRequest() not supported in BrokerMsalController");
    }

    public AcquireTokenResult acquireDeviceCodeFlowToken(AuthorizationResult authorizationResult, DeviceCodeFlowCommandParameters commandParameters) throws ClientException {
        throw new ClientException("acquireDeviceCodeFlowToken() not supported in BrokerMsalController");
    }

    public GenerateShrResult generateSignedHttpRequest(final @NonNull GenerateShrCommandParameters parameters) throws Exception {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<GenerateShrResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() throws ClientException {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GENERATE_SHR, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForGenerateShr(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public GenerateShrResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (null == resultBundle) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getGenerateShrResultFromResultBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":generateSignedHttpRequest";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull GenerateShrResult result) {
            }
        });
    }

    public AcquirePrtSsoTokenResult getSsoToken(final @NonNull AcquirePrtSsoTokenCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<AcquirePrtSsoTokenResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @NonNull
            public BrokerOperationBundle getBundle() throws ClientException {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_SSO_TOKEN, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForSsoToken(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @NonNull
            public AcquirePrtSsoTokenResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (null == resultBundle) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getAcquirePrtSsoTokenResultFromBundle(resultBundle);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return ":getSsoToken";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@NonNull ApiEndEvent event, @NonNull AcquirePrtSsoTokenResult result) {
            }
        });
    }

    private void saveMsaAccountToCache(@NonNull Bundle resultBundle, @NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) throws BaseException {
        String methodName = ":saveMsaAccountToCache";
        BrokerResult brokerResult = new MsalBrokerResultAdapter().brokerResultFromBundle(resultBundle);
        if (resultBundle.getBoolean("broker_request_v2_success") && "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(brokerResult.getTenantId())) {
            Logger.info(TAG + ":saveMsaAccountToCache", "Result returned for MSA Account, saving to cache");
            if (StringUtil.isEmpty(brokerResult.getClientInfo())) {
                Logger.error(TAG + ":saveMsaAccountToCache", "ClientInfo is empty.", null);
                throw new ClientException("unknown_error", "ClientInfo is empty.");
            }
            try {
                ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
                MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
                microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
                MicrosoftRefreshToken microsoftRefreshToken = new MicrosoftRefreshToken(brokerResult.getRefreshToken(), clientInfo, brokerResult.getScope(), brokerResult.getClientId(), brokerResult.getEnvironment(), brokerResult.getFamilyId());
                this.msalOAuth2TokenCacheSetSingleSignOnState(msalOAuth2TokenCache, microsoftStsAccount, microsoftRefreshToken);
            }
            catch (ServiceException e) {
                Logger.errorPII(TAG + ":saveMsaAccountToCache", "Exception while creating Idtoken or ClientInfo, cannot save MSA account tokens", e);
                throw new ClientException("invalid_jwt", e.getMessage(), (Throwable)e);
            }
        }
    }

    private void msalOAuth2TokenCacheSetSingleSignOnState(@NonNull MsalOAuth2TokenCache msalOAuth2TokenCache, MicrosoftStsAccount microsoftStsAccount, MicrosoftRefreshToken microsoftRefreshToken) throws ClientException {
        msalOAuth2TokenCache.setSingleSignOnState((BaseAccount)microsoftStsAccount, (RefreshToken)microsoftRefreshToken);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerMsalController)) {
            return false;
        }
        BrokerMsalController other = (BrokerMsalController)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerMsalController;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

