/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import android.util.Log;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.commands.RefreshOnCallback;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.providers.oauth2.TokenResult;
import com.microsoft.identity.common.java.result.VoidResult;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;

public class RefreshOnCommand
extends BaseCommand<VoidResult> {
    private static final String TAG = RefreshOnCommand.class.getSimpleName();

    public RefreshOnCommand(@NonNull CommandParameters parameters, @NonNull BaseController controller, @NonNull String publicApiId) {
        super(parameters, controller, (CommandCallback)new RefreshOnCallback(), publicApiId);
    }

    public VoidResult execute() throws IOException, ClientException, ServiceException {
        String methodName = ":execute";
        BaseController controller = this.getDefaultController();
        Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
        SilentTokenCommandParameters commandParameters = (SilentTokenCommandParameters)this.getParameters();
        TokenResult result = controller.renewAccessToken(commandParameters);
        if (!result.getSuccess()) {
            Log.e((String)TAG, (String)result.getErrorResponse().getError());
        }
        return new VoidResult();
    }

    public boolean isEligibleForEstsTelemetry() {
        return false;
    }

    public boolean isEligibleForCaching() {
        return false;
    }
}

