/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.microsoft.identity.common.PropertyBagUtil;
import com.microsoft.identity.common.internal.result.BrokerResultAdapterFactory;
import com.microsoft.identity.common.internal.result.IBrokerResultAdapter;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.util.ported.LocalBroadcaster;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import com.microsoft.identity.common.logging.Logger;
import java.io.Serializable;

public final class BrokerActivity
extends Activity {
    public static final String BROKER_INTENT = "broker_intent";
    static final String BROKER_INTENT_STARTED = "broker_intent_started";
    static final int BROKER_INTENT_REQUEST_CODE = 1001;
    private static final String TAG = BrokerActivity.class.getSimpleName();
    private Intent mBrokerInteractiveRequestIntent;
    private Boolean mBrokerIntentStarted = false;
    private Boolean mBrokerResultReceived = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.mBrokerInteractiveRequestIntent = (Intent)this.getIntent().getExtras().getParcelable(BROKER_INTENT);
        } else {
            this.mBrokerInteractiveRequestIntent = (Intent)savedInstanceState.getParcelable(BROKER_INTENT);
            this.mBrokerIntentStarted = savedInstanceState.getBoolean(BROKER_INTENT_STARTED);
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.mBrokerIntentStarted.booleanValue()) {
            this.mBrokerIntentStarted = true;
            this.startActivityForResult(this.mBrokerInteractiveRequestIntent, 1001);
        }
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        if (!this.mBrokerResultReceived.booleanValue()) {
            this.returnsExceptionOnActivityUnexpectedlyKilled();
        }
        super.onDestroy();
    }

    private void returnsExceptionOnActivityUnexpectedlyKilled() {
        IBrokerResultAdapter resultAdapter = BrokerResultAdapterFactory.getBrokerResultAdapter(SdkType.MSAL);
        Bundle resultBundle = resultAdapter.bundleFromBaseException((BaseException)((Object)new ClientException("Broker request cancelled", "The activity is killed unexpectedly.")), null);
        PropertyBag propertyBag = PropertyBagUtil.fromBundle(resultBundle);
        propertyBag.put("com.microsoft.identity.client.request.code", (Serializable)Integer.valueOf(1003));
        propertyBag.put("com.microsoft.identity.client.result.code", (Serializable)Integer.valueOf(2001));
        LocalBroadcaster.INSTANCE.broadcast("return_broker_interactive_acquire_token_result", propertyBag);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(BROKER_INTENT, (Parcelable)this.mBrokerInteractiveRequestIntent);
        outState.putBoolean(BROKER_INTENT_STARTED, this.mBrokerIntentStarted.booleanValue());
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        String methodName = ":onActivityResult";
        Logger.info(TAG + ":onActivityResult", "Result received from Broker Request code: " + requestCode + " Result code: " + requestCode);
        this.mBrokerResultReceived = true;
        if (resultCode == 2004 || resultCode == 2001 || resultCode == 2002) {
            Logger.verbose(TAG + ":onActivityResult", "Completing interactive request ");
            PropertyBag propertyBag = PropertyBagUtil.fromBundle(data.getExtras());
            propertyBag.put("com.microsoft.identity.client.request.code", (Serializable)Integer.valueOf(1003));
            propertyBag.put("com.microsoft.identity.client.result.code", (Serializable)Integer.valueOf(resultCode));
            LocalBroadcaster.INSTANCE.broadcast("return_broker_interactive_acquire_token_result", propertyBag);
        } else {
            this.returnsExceptionOnActivityUnexpectedlyKilled();
        }
        this.finish();
    }
}

