/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.exception;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.java.exception.BaseException;

public class BrokerCommunicationException
extends BaseException {
    private static final long serialVersionUID = 4959278068787428329L;
    private final Category category;
    private final IIpcStrategy.Type strategyType;

    public BrokerCommunicationException(Category category, IIpcStrategy.Type strategyType, String errorMessage, Throwable throwable) {
        super(category.toString(), errorMessage, throwable);
        this.category = category;
        this.strategyType = strategyType;
    }

    public String getMessage() {
        return "[" + this.category.toString() + "] [" + this.strategyType.toString() + "] :" + super.getMessage();
    }

    public boolean isCacheable() {
        return this.category != Category.CONNECTION_ERROR;
    }

    public Category getCategory() {
        return this.category;
    }

    public IIpcStrategy.Type getStrategyType() {
        return this.strategyType;
    }

    public static enum Category {
        OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE("ipc_operation_not_supported_on_client_side"),
        OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE("ipc_operation_not_supported_on_server_side"),
        CONNECTION_ERROR("ipc_connection_error");

        final String name;

        private Category(String name) {
            this.name = name;
        }

        @NonNull
        public String toString() {
            return this.name;
        }
    }
}

