/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry;

import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.internal.telemetry.TelemetryConfiguration;
import com.microsoft.identity.common.internal.telemetry.TelemetryContext;
import com.microsoft.identity.common.internal.telemetry.adapter.TelemetryAggregationAdapter;
import com.microsoft.identity.common.internal.telemetry.adapter.TelemetryDefaultAdapter;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.telemetry.observers.ITelemetryAggregatedObserver;
import com.microsoft.identity.common.internal.telemetry.observers.ITelemetryDefaultObserver;
import com.microsoft.identity.common.internal.telemetry.observers.ITelemetryObserver;
import com.microsoft.identity.common.internal.telemetry.rules.TelemetryPiiOiiRules;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.logging.DiagnosticContext;
import com.microsoft.identity.common.logging.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;

public class Telemetry {
    private static final String TAG = Telemetry.class.getSimpleName();
    private static volatile Telemetry sTelemetryInstance = null;
    private static Queue<ITelemetryObserver> mObservers;
    private Queue<Map<String, String>> mTelemetryRawDataMap;
    private TelemetryConfiguration mDefaultConfiguration;
    private TelemetryContext mTelemetryContext;
    private boolean mIsDebugging;
    private final boolean mIsTelemetryEnabled;

    private Telemetry(Builder builder) {
        if (builder == null || builder.mTelemetryContext == null || builder.mDefaultConfiguration == null) {
            Logger.warn(TAG, "Telemetry is disabled because the Telemetry context or configuration is null");
            this.mIsTelemetryEnabled = false;
        } else {
            this.mIsTelemetryEnabled = true;
            this.mDefaultConfiguration = builder.mDefaultConfiguration;
            this.mTelemetryContext = builder.mTelemetryContext;
            this.mIsDebugging = builder.mIsDebugging;
            this.mTelemetryRawDataMap = new ConcurrentLinkedQueue<Map<String, String>>();
        }
    }

    private static synchronized Telemetry prepareInstance(Builder builder) {
        sTelemetryInstance = new Telemetry(builder);
        return sTelemetryInstance;
    }

    public static synchronized Telemetry getInstance() {
        if (sTelemetryInstance == null) {
            new Builder().build();
        }
        return sTelemetryInstance;
    }

    private Queue<Map<String, String>> getRequestMap() {
        return this.mTelemetryRawDataMap;
    }

    public void addObserver(ITelemetryObserver observer) {
        if (null == observer) {
            throw new IllegalArgumentException("Telemetry Observer instance cannot be null");
        }
        if (null == mObservers) {
            mObservers = new ConcurrentLinkedQueue<ITelemetryObserver>();
        }
        mObservers.add(observer);
    }

    public void removeObserver(Class<?> cls) {
        if (null == cls || null == mObservers) {
            Logger.warn(TAG, "Unable to remove the observe. Either the observer is null or the observer list is empty.");
            return;
        }
        Iterator observerIterator = mObservers.iterator();
        while (observerIterator.hasNext()) {
            if (((ITelemetryObserver)observerIterator.next()).getClass() != cls) continue;
            Logger.verbose(TAG, "The [" + cls.getSimpleName() + "] observer is removed.");
            observerIterator.remove();
        }
    }

    public void removeObserver(ITelemetryObserver observer) {
        if (null == observer || null == mObservers) {
            Logger.warn(TAG, "Unable to remove the observer. Either the observer is null or the observer list is empty.");
            return;
        }
        mObservers.remove(observer);
    }

    @VisibleForTesting
    void removeAllObservers() {
        if (mObservers == null) {
            return;
        }
        mObservers.clear();
    }

    public List<ITelemetryObserver> getObservers() {
        CopyOnWriteArrayList<Object> observersList = mObservers != null ? new CopyOnWriteArrayList<ITelemetryObserver>(mObservers) : new CopyOnWriteArrayList();
        return Collections.unmodifiableList(observersList);
    }

    public static void emit(BaseEvent event) {
        if (Telemetry.getInstance().mIsTelemetryEnabled) {
            Telemetry.getInstance().getRequestMap().add(event.getProperties());
        }
    }

    public void flush() {
        if (Telemetry.getInstance().mIsTelemetryEnabled) {
            this.flush((String)DiagnosticContext.getRequestContext().get("correlation_id"));
        }
    }

    public void flush(@NonNull String correlationId) {
        if (!this.mIsTelemetryEnabled) {
            return;
        }
        if (null == mObservers) {
            Logger.warn(TAG, "No telemetry observer set.");
            return;
        }
        if (StringUtil.isEmpty(correlationId)) {
            Logger.warn(TAG, "No correlation id set.");
            return;
        }
        if (!this.mDefaultConfiguration.isDebugEnabled() && this.mIsDebugging) {
            return;
        }
        CopyOnWriteArrayList<Map<String, String>> finalRawMap = new CopyOnWriteArrayList<Map<String, String>>();
        Iterator iterator = this.mTelemetryRawDataMap.iterator();
        while (iterator.hasNext()) {
            Map event = (Map)iterator.next();
            if (!correlationId.equalsIgnoreCase((String)event.get("Microsoft.MSAL.correlation_id"))) continue;
            finalRawMap.add(this.applyPiiOiiRule(event));
            iterator.remove();
        }
        finalRawMap.add(this.applyPiiOiiRule(this.mTelemetryContext.getProperties()));
        for (ITelemetryObserver observer : mObservers) {
            if (observer instanceof ITelemetryAggregatedObserver) {
                new TelemetryAggregationAdapter((ITelemetryAggregatedObserver)observer).process((List<Map<String, String>>)finalRawMap);
                continue;
            }
            if (observer instanceof ITelemetryDefaultObserver) {
                new TelemetryDefaultAdapter((ITelemetryDefaultObserver)observer).process((List<Map<String, String>>)finalRawMap);
                continue;
            }
            Logger.warn(TAG, "Unknown observer type: " + observer.getClass());
        }
    }

    private Map<String, String> applyPiiOiiRule(Map<String, String> properties) {
        if (this.mDefaultConfiguration.isPiiEnabled()) {
            Logger.warn(TAG, "Telemetry PII/OII is enabled by the developer.");
            return properties;
        }
        HashMap<String, String> nonPiiProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (TelemetryPiiOiiRules.getInstance().isPiiOrOii(entry.getKey())) continue;
            nonPiiProperties.put(entry.getKey(), entry.getValue());
        }
        return nonPiiProperties;
    }

    public static class Builder {
        private Context mContext;
        private TelemetryConfiguration mDefaultConfiguration;
        private TelemetryContext mTelemetryContext;
        private Boolean mIsDebugging;

        public Builder withContext(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.mContext = context.getApplicationContext();
            if (this.mContext == null) {
                throw new IllegalArgumentException("Application context must not be null.");
            }
            this.mTelemetryContext = TelemetryContext.create(this.mContext);
            try {
                String packageName = context.getPackageName();
                int flags = context.getPackageManager().getApplicationInfo((String)packageName, (int)0).flags;
                this.mIsDebugging = (flags & 2) != 0;
            }
            catch (PackageManager.NameNotFoundException exception) {
                Logger.warn(TAG, "The application is not found from PackageManager.");
                this.mIsDebugging = false;
            }
            return this;
        }

        public Builder defaultConfiguration(TelemetryConfiguration configuration) {
            this.mDefaultConfiguration = configuration;
            return this;
        }

        public Telemetry build() throws IllegalArgumentException {
            return Telemetry.prepareInstance(this);
        }
    }
}

