/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.result;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.util.BiConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ResultFuture<T>
implements Future<T> {
    private final CountDownLatch mCountDownLatch = new CountDownLatch(1);
    private T mResult = null;
    private Exception mException = null;
    private final List<BiConsumer<T, Throwable>> mConsumers = new ArrayList<BiConsumer<T, Throwable>>();

    @Override
    public boolean cancel(boolean b) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.mCountDownLatch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.mCountDownLatch.await();
        if (null != this.mException) {
            throw new ExecutionException(this.mException);
        }
        return this.mResult;
    }

    @Override
    public T get(long l, @NonNull TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        if (this.mCountDownLatch.await(l, timeUnit)) {
            if (null != this.mException) {
                throw new ExecutionException(this.mException);
            }
            return this.mResult;
        }
        throw new TimeoutException("Timed out waiting for: " + l + timeUnit.name());
    }

    public synchronized void setException(@NonNull Exception exception) {
        this.mException = exception;
        this.mCountDownLatch.countDown();
        for (BiConsumer<T, Throwable> consumer : this.mConsumers) {
            consumer.accept(this.mResult, exception);
        }
    }

    public synchronized void setResult(@Nullable T result) {
        this.mResult = result;
        this.mCountDownLatch.countDown();
        for (BiConsumer<T, Throwable> consumer : this.mConsumers) {
            consumer.accept(result, this.mException);
        }
        this.mConsumers.clear();
    }

    public synchronized void whenComplete(@NonNull BiConsumer<T, Throwable> consumerToAdd) {
        if (this.isDone()) {
            consumerToAdd.accept(this.mResult, this.mException);
            return;
        }
        this.mConsumers.add(consumerToAdd);
    }
}

