/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiEndEvent;
import com.microsoft.identity.common.logging.DiagnosticContext;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public abstract class CurrentTaskAuthorizationFragment
extends Fragment {
    private static final String TAG = AuthorizationFragment.class.getSimpleName();
    private Bundle mInstanceState;
    private final BroadcastReceiver mCancelRequestReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            CurrentTaskAuthorizationFragment.this.cancelAuthorization(intent.getBooleanExtra("com.microsoft.identity.client.request.cancelled.by.user", false));
        }
    };

    void setInstanceState(@NonNull Bundle instanceStateBundle) {
        this.mInstanceState = instanceStateBundle;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void onCreate(@Nullable Bundle savedInstanceState) {
        String methodName = "#onCreate";
        super.onCreate(savedInstanceState);
        LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver(this.mCancelRequestReceiver, new IntentFilter("cancel_interactive_request"));
        if (savedInstanceState == null) {
            Logger.verbose(TAG + "#onCreate", "Extract state from the intent bundle.");
            this.extractState(this.mInstanceState);
        } else {
            Logger.verbose(TAG + "#onCreate", "Extract state from the saved bundle.");
            this.extractState(savedInstanceState);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    void finish() {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof AuthorizationActivity) {
            activity.finish();
        } else if (this.getFragmentManager() != null) {
            this.getFragmentManager().beginTransaction().setTransitionStyle(4099).remove((Fragment)this).commit();
        }
    }

    void extractState(@NonNull Bundle state) {
        CurrentTaskAuthorizationFragment.setDiagnosticContextForNewThread(state.getString("correlation_id"));
    }

    private static String setDiagnosticContextForNewThread(@NonNull String correlationId) {
        String methodName = ":setDiagnosticContextForAuthorizationActivity";
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":setDiagnosticContextForAuthorizationActivity", "Initializing diagnostic context for CurrentTaskAuthorizationActivity");
        return correlationId;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void onDestroy() {
        LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver(this.mCancelRequestReceiver);
        super.onDestroy();
    }

    public boolean onBackPressed() {
        return false;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    void sendResult(int resultCode, Intent resultIntent) {
        Logger.info(TAG, "Sending result from Authorization Activity, resultCode: " + resultCode);
        resultIntent.setAction("return_interactive_request_result");
        resultIntent.putExtra("com.microsoft.identity.client.request.code", 1001);
        resultIntent.putExtra("com.microsoft.identity.client.result.code", resultCode);
        LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(resultIntent);
    }

    void cancelAuthorization(boolean isCancelledByUser) {
        Intent resultIntent = new Intent();
        resultIntent.setFlags(0x4000000);
        if (isCancelledByUser) {
            Logger.info(TAG, "Received Authorization flow cancelled by the user");
            this.sendResult(2001, resultIntent);
        } else {
            Logger.info(TAG, "Received Authorization flow cancel request from SDK");
            this.sendResult(2008, resultIntent);
        }
        Telemetry.emit(new UiEndEvent().isUserCancelled());
        this.finish();
    }
}

