/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.logging.Logger;
import java.util.HashMap;
import java.util.Map;

public class AzureActiveDirectoryAccount
extends MicrosoftAccount {
    private static final String TAG = AzureActiveDirectoryAccount.class.getSimpleName();
    private String mIdentityProvider;

    public AzureActiveDirectoryAccount() {
    }

    public AzureActiveDirectoryAccount(@NonNull IDToken idToken, @NonNull ClientInfo clientInfo) {
        super(idToken, clientInfo);
        HashMap claims = new HashMap(idToken.getTokenClaims());
        this.mIdentityProvider = (String)claims.get("idp");
        Logger.verbose(TAG, "Init: " + TAG);
    }

    public synchronized void setIdentityProvider(String idp) {
        this.mIdentityProvider = idp;
    }

    public synchronized String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    @Override
    public String getAuthorityType() {
        return "MSSTS";
    }

    @Override
    protected String getDisplayableId(Map<String, ?> claims) {
        String methodName = "getDisplayableId";
        String displayableId = null;
        if (!StringExtensions.isNullOrBlank((String)claims.get("upn"))) {
            Logger.info(TAG + ":" + "getDisplayableId", "Returning upn as displayableId");
            displayableId = (String)claims.get("upn");
        } else if (!StringExtensions.isNullOrBlank((String)claims.get("email"))) {
            Logger.info(TAG + ":" + "getDisplayableId", "Returning email as displayableId");
            displayableId = (String)claims.get("email");
        }
        return displayableId;
    }

    @Override
    public String toString() {
        return "AzureActiveDirectoryAccount{} " + super.toString() + ", mIdentityProvider='" + this.mIdentityProvider + '\'';
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureActiveDirectoryAccount)) {
            return false;
        }
        AzureActiveDirectoryAccount other = (AzureActiveDirectoryAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mIdentityProvider = this.mIdentityProvider;
        String other$mIdentityProvider = other.mIdentityProvider;
        return !(this$mIdentityProvider == null ? other$mIdentityProvider != null : !this$mIdentityProvider.equals(other$mIdentityProvider));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AzureActiveDirectoryAccount;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mIdentityProvider = this.mIdentityProvider;
        result = result * 59 + ($mIdentityProvider == null ? 43 : $mIdentityProvider.hashCode());
        return result;
    }
}

