/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.internal.platform.Device;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import com.microsoft.identity.common.internal.result.GenerateShrResult;
import com.microsoft.identity.common.internal.util.IClockSkewManager;
import java.net.URL;

public class DevicePoPUtils {
    private DevicePoPUtils() {
    }

    public static synchronized GenerateShrResult generateSignedHttpRequest(@NonNull Context context, @NonNull IClockSkewManager clockSkewManager, @NonNull IPoPAuthenticationSchemeParams popSchemeParams) throws ClientException {
        long ONE_SECOND_MILLIS = 1000L;
        long timestampMillis = clockSkewManager.getAdjustedReferenceTime().getTime();
        String httpMethodStr = popSchemeParams.getHttpMethod();
        URL resourceUrl = popSchemeParams.getUrl();
        String nonce = popSchemeParams.getNonce();
        String clientClaims = popSchemeParams.getClientClaims();
        IDevicePopManager popMgr = Device.getDevicePoPManagerInstance();
        if (!popMgr.asymmetricKeyExists()) {
            popMgr.generateAsymmetricKey(context);
        }
        String shr = popMgr.mintSignedHttpRequest(httpMethodStr, timestampMillis / 1000L, resourceUrl, nonce, clientClaims);
        GenerateShrResult result = new GenerateShrResult();
        result.setShr(shr);
        return result;
    }
}

