/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.platform.AsymmetricRsaKey;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import com.microsoft.identity.common.internal.platform.SecureHardwareState;
import java.security.cert.Certificate;
import java.util.Date;

public class AndroidKeystoreAsymmetricRsaKey
implements AsymmetricRsaKey {
    @RequiresApi(api=18)
    public static final IDevicePopManager.Cipher RSA_ECB_PKCS_1_PADDING = IDevicePopManager.Cipher.RSA_ECB_PKCS1_PADDING;
    @RequiresApi(api=18)
    public static final IDevicePopManager.SigningAlgorithm SHA_256_WITH_RSA = IDevicePopManager.SigningAlgorithm.SHA_256_WITH_RSA;
    private final IDevicePopManager mDevicePopManager;
    private final String mAlias;

    AndroidKeystoreAsymmetricRsaKey(@NonNull Context context, @NonNull IDevicePopManager popManager, @NonNull String alias) throws ClientException {
        this.mDevicePopManager = popManager;
        this.mAlias = alias;
        if (!this.mDevicePopManager.asymmetricKeyExists()) {
            this.mDevicePopManager.generateAsymmetricKey(context);
        }
    }

    @Override
    public String getAlias() {
        return this.mAlias;
    }

    @Override
    public Date getCreatedOn() throws ClientException {
        return this.mDevicePopManager.getAsymmetricKeyCreationDate();
    }

    @Override
    public String getThumbprint() throws ClientException {
        return this.mDevicePopManager.getAsymmetricKeyThumbprint();
    }

    @Override
    public String getPublicKey() throws ClientException {
        return this.mDevicePopManager.getPublicKey(IDevicePopManager.PublicKeyFormat.JWK);
    }

    @Override
    @RequiresApi(api=18)
    public String sign(@NonNull String data) throws ClientException {
        return this.mDevicePopManager.sign(SHA_256_WITH_RSA, data);
    }

    @Override
    @RequiresApi(api=18)
    public boolean verify(@NonNull String plainText, @NonNull String signatureStr) {
        return this.mDevicePopManager.verify(SHA_256_WITH_RSA, plainText, signatureStr);
    }

    @Override
    @RequiresApi(api=18)
    public String encrypt(@NonNull String plaintext) throws ClientException {
        return this.mDevicePopManager.encrypt(RSA_ECB_PKCS_1_PADDING, plaintext);
    }

    @Override
    @RequiresApi(api=18)
    public String decrypt(@NonNull String ciphertext) throws ClientException {
        return this.mDevicePopManager.decrypt(RSA_ECB_PKCS_1_PADDING, ciphertext);
    }

    @Override
    public SecureHardwareState getSecureHardwareState() throws ClientException {
        return this.mDevicePopManager.getSecureHardwareState();
    }

    @Override
    @RequiresApi(api=18)
    public byte[] encrypt(byte[] plaintext) throws ClientException {
        return this.mDevicePopManager.encrypt(RSA_ECB_PKCS_1_PADDING, plaintext);
    }

    @Override
    @RequiresApi(api=18)
    public byte[] decrypt(byte[] ciphertext) throws ClientException {
        return this.mDevicePopManager.encrypt(RSA_ECB_PKCS_1_PADDING, ciphertext);
    }

    @Override
    @RequiresApi(api=18)
    public byte[] sign(byte[] text) throws ClientException {
        return this.mDevicePopManager.sign(SHA_256_WITH_RSA, text);
    }

    @Override
    @RequiresApi(api=18)
    public boolean verify(byte[] text, byte[] signature) throws ClientException {
        return this.mDevicePopManager.verify(SHA_256_WITH_RSA, text, signature);
    }

    @Override
    public Certificate[] getCertificateChain() throws ClientException {
        return this.mDevicePopManager.getCertificateChain();
    }
}

