/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.migration;

import android.util.Pair;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.internal.migration.IMigrationAdapter;
import com.microsoft.identity.common.internal.migration.TokenMigrationCallback;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.logging.Logger;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TokenMigrationUtility<T extends BaseAccount, U extends RefreshToken> {
    private static final String TAG = TokenMigrationUtility.class.getName();
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();

    public void _import(final IMigrationAdapter<T, U> adapter, final Map<String, String> credentials, final IShareSingleSignOnState<T, U> destination, final TokenMigrationCallback callback) {
        sBackgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                int accountsAdded = 0;
                for (Pair accountTokenPair : adapter.adapt(credentials)) {
                    try {
                        destination.setSingleSignOnState((BaseAccount)accountTokenPair.first, (RefreshToken)accountTokenPair.second);
                        ++accountsAdded;
                    }
                    catch (ClientException e) {
                        Logger.warn(TAG, "Failed to save account/refresh token . Skipping ");
                    }
                }
                callback.onMigrationFinished(accountsAdded);
            }
        });
    }
}

