/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.eststelemetry.ICurrentTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.RequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.TelemetryUtils;

public class CurrentRequestTelemetry
extends RequestTelemetry
implements ICurrentTelemetry {
    private String mApiId;
    private boolean mForceRefresh;

    CurrentRequestTelemetry() {
        super("2");
    }

    String getApiId() {
        return this.mApiId;
    }

    boolean getForceRefresh() {
        return this.mForceRefresh;
    }

    @Override
    public String getHeaderStringForFields() {
        return TelemetryUtils.getSchemaCompliantString(this.mApiId) + "," + TelemetryUtils.getSchemaCompliantStringFromBoolean(this.mForceRefresh);
    }

    @Override
    public void put(@NonNull String key, @NonNull String value) {
        switch (key) {
            case "Microsoft.MSAL.api_id": {
                this.mApiId = value;
                break;
            }
            case "Microsoft.MSAL.force_refresh": {
                this.mForceRefresh = TelemetryUtils.getBooleanFromSchemaString(value);
                break;
            }
            default: {
                this.putInPlatformTelemetry(key, value);
            }
        }
    }
}

