/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.util.LruCache;
import com.microsoft.identity.common.internal.commands.BaseCommand;
import com.microsoft.identity.common.internal.controllers.CommandResult;
import com.microsoft.identity.common.internal.controllers.CommandResultCacheItem;

public class CommandResultCache {
    private static final int DEFAULT_ITEM_COUNT = 250;
    private LruCache<BaseCommand, CommandResultCacheItem> mCache;

    public CommandResultCache() {
        this.mCache = new LruCache(250);
    }

    public CommandResultCache(int maxItemCount) {
        this.mCache = new LruCache(maxItemCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult get(BaseCommand key) {
        LruCache<BaseCommand, CommandResultCacheItem> lruCache = this.mCache;
        synchronized (lruCache) {
            CommandResultCacheItem item = (CommandResultCacheItem)this.mCache.get((Object)key);
            if (item != null) {
                if (item.isExpired()) {
                    this.mCache.remove((Object)key);
                    return null;
                }
                return item.getValue();
            }
            return null;
        }
    }

    public void put(BaseCommand key, CommandResult value) {
        CommandResultCacheItem cacheItem = new CommandResultCacheItem(value);
        this.mCache.put((Object)key, (Object)cacheItem);
    }

    public int getSize() {
        return this.mCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LruCache<BaseCommand, CommandResultCacheItem> lruCache = this.mCache;
        synchronized (lruCache) {
            this.mCache = new LruCache(250);
        }
    }
}

