/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.LruCache;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.cache.IStorageHelper;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SharedPreferencesFileManager
implements ISharedPreferencesFileManager {
    private static final String TAG = SharedPreferencesFileManager.class.getSimpleName();
    private final Object cacheLock = new Object();
    @GuardedBy(value="cacheLock")
    private final LruCache<String, String> fileCache = new LruCache(256);
    private final String mSharedPreferencesFileName;
    @GuardedBy(value="cacheLock")
    private final SharedPreferences mSharedPreferences;
    private final IStorageHelper mStorageHelper;
    private static final ConcurrentMap<String, SharedPreferencesFileManager> objectCache = new ConcurrentHashMap<String, SharedPreferencesFileManager>(16, 0.75f, 1);

    @Deprecated
    public static SharedPreferencesFileManager getSharedPreferences(Context context, String name, int operatingMode, IStorageHelper storageHelper) {
        String key = name + "/" + context.getPackageName() + "/" + (operatingMode == -1 ? 0 : operatingMode) + "/" + (storageHelper == null ? "clear" : storageHelper.getClass().getCanonicalName());
        SharedPreferencesFileManager cachedFileManager = (SharedPreferencesFileManager)objectCache.get(key);
        if (cachedFileManager == null && (cachedFileManager = objectCache.putIfAbsent(key, new SharedPreferencesFileManager(context, name, operatingMode, storageHelper))) == null) {
            cachedFileManager = (SharedPreferencesFileManager)objectCache.get(key);
        }
        return cachedFileManager;
    }

    public static void clearSingletonCache() {
        objectCache.clear();
    }

    public static SharedPreferencesFileManager getSharedPreferences(Context context, String name, IStorageHelper storageHelper) {
        return SharedPreferencesFileManager.getSharedPreferences(context, name, 0, storageHelper);
    }

    public SharedPreferencesFileManager(Context context, String name) {
        this(context, name, -1, null);
        Logger.verbose(TAG, "Init: " + TAG);
    }

    public SharedPreferencesFileManager(Context context, String name, int operatingMode) {
        this(context, name, operatingMode, null);
    }

    public SharedPreferencesFileManager(Context context, String name, IStorageHelper storageHelper) {
        this(context, name, -1, storageHelper);
    }

    public SharedPreferencesFileManager(Context context, String name, int operatingMode, IStorageHelper storageHelper) {
        if (operatingMode == -1 && storageHelper == null) {
            Logger.verbose(TAG, "Init: ");
        } else if (storageHelper == null) {
            Logger.verbose(TAG, "Init with operating mode: " + TAG);
        } else if (operatingMode == -1) {
            Logger.verbose(TAG, "Init with storage helper:  " + TAG);
        } else {
            Logger.verbose(TAG, "Init with operating mode and storage helper " + TAG);
        }
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, operatingMode == -1 ? 0 : operatingMode);
        this.mStorageHelper = storageHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void putString(String key, String value) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (value != null) {
                this.fileCache.put((Object)key, (Object)value);
            } else {
                this.fileCache.remove((Object)key);
            }
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            if (null == this.mStorageHelper) {
                editor.putString(key, value);
            } else {
                String encryptedValue = this.encrypt(value);
                editor.putString(key, encryptedValue);
            }
            editor.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String getString(String key) {
        Object object = this.cacheLock;
        synchronized (object) {
            String memCache = (String)this.fileCache.get((Object)key);
            if (memCache != null) {
                return memCache;
            }
            String restoredValue = this.mSharedPreferences.getString(key, null);
            if (null != this.mStorageHelper && !StringExtensions.isNullOrBlank(restoredValue) && StringExtensions.isNullOrBlank(restoredValue = this.decrypt(restoredValue))) {
                this.logWarningAndRemoveKey(key);
            }
            return restoredValue;
        }
    }

    @Override
    public void putLong(String key, long value) {
        this.putString(key, String.valueOf(value));
    }

    @Override
    public long getLong(String key) {
        String result = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)result)) {
            return Long.parseLong(result);
        }
        return 0L;
    }

    private void logWarningAndRemoveKey(String key) {
        Logger.warn(TAG, "Failed to decrypt value! This usually signals an issue with KeyStore or the provided SecretKeys.");
        this.remove(key);
    }

    @Override
    public final String getSharedPreferencesFileName() {
        return this.mSharedPreferencesFileName;
    }

    @Override
    public final Map<String, String> getAll() {
        Map entries = this.mSharedPreferences.getAll();
        if (null != this.mStorageHelper) {
            for (Map.Entry entry : entries.entrySet()) {
                String decryptedValue = this.getString((String)entry.getKey());
                if (TextUtils.isEmpty((CharSequence)decryptedValue)) continue;
                entry.setValue(decryptedValue);
            }
        }
        return entries;
    }

    @Override
    public final Iterator<Map.Entry<String, String>> getAllFilteredByKey(final @NonNull Predicate<String> keyFilter) {
        final Map entries = this.mSharedPreferences.getAll();
        return new Iterator<Map.Entry<String, String>>(){
            final Iterator<Map.Entry<String, String>> iterator;
            Map.Entry<String, String> nextEntry;
            {
                this.iterator = entries.entrySet().iterator();
                this.nextEntry = null;
            }

            @Override
            public boolean hasNext() {
                if (this.nextEntry != null) {
                    return true;
                }
                if (!this.iterator.hasNext()) {
                    return false;
                }
                do {
                    Map.Entry<String, String> nextElement;
                    if (!keyFilter.test((nextElement = this.iterator.next()).getKey())) continue;
                    if (SharedPreferencesFileManager.this.mStorageHelper != null) {
                        String decryptedValue = SharedPreferencesFileManager.this.getString(nextElement.getKey());
                        if (TextUtils.isEmpty((CharSequence)decryptedValue)) continue;
                        this.nextEntry = new AbstractMap.SimpleEntry<String, String>(nextElement.getKey(), decryptedValue);
                        continue;
                    }
                    this.nextEntry = nextElement;
                } while (this.nextEntry == null && this.iterator.hasNext());
                return this.nextEntry != null;
            }

            @Override
            public Map.Entry<String, String> next() {
                if (this.nextEntry == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<String, String> tmp = this.nextEntry;
                this.nextEntry = null;
                return tmp;
            }
        };
    }

    @Override
    public final boolean contains(String key) {
        return !TextUtils.isEmpty((CharSequence)this.getString(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Object object = this.cacheLock;
        synchronized (object) {
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            editor.clear();
            this.fileCache.evictAll();
            editor.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        Logger.info(TAG, "Removing cache key");
        Object object = this.cacheLock;
        synchronized (object) {
            this.fileCache.remove((Object)key);
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            editor.remove(key);
            editor.apply();
        }
        Logger.infoPII(TAG, "Removed cache key [" + key + "]");
    }

    @Nullable
    private String encrypt(@NonNull String clearText) {
        return this.encryptDecryptInternal(clearText, true);
    }

    @Nullable
    private String decrypt(@NonNull String encryptedBlob) {
        return this.encryptDecryptInternal(encryptedBlob, false);
    }

    @Nullable
    private String encryptDecryptInternal(@NonNull String inputText, boolean encrypt) {
        String result;
        String methodName = "encryptDecryptInternal";
        try {
            result = encrypt ? this.mStorageHelper.encrypt(inputText) : this.mStorageHelper.decrypt(inputText);
        }
        catch (IOException | GeneralSecurityException e) {
            Logger.error(TAG + ":" + "encryptDecryptInternal", "Failed to " + (encrypt ? "encrypt" : "decrypt") + " value", encrypt ? null : e);
            result = null;
        }
        return result;
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

