/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.internal.cache.BrokerApplicationMetadata;
import com.microsoft.identity.common.internal.cache.IBrokerApplicationMetadataCache;
import com.microsoft.identity.common.internal.cache.SharedPreferencesSimpleCacheImpl;
import com.microsoft.identity.common.logging.Logger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SharedPreferencesBrokerApplicationMetadataCache
extends SharedPreferencesSimpleCacheImpl<BrokerApplicationMetadata>
implements IBrokerApplicationMetadataCache {
    private static final String TAG = SharedPreferencesBrokerApplicationMetadataCache.class.getSimpleName();
    private static final String DEFAULT_APP_METADATA_CACHE_NAME = "com.microsoft.identity.app-meta-cache";
    private static final String KEY_CACHE_LIST = "app-meta-cache";

    public SharedPreferencesBrokerApplicationMetadataCache(@NonNull Context context) {
        super(context, DEFAULT_APP_METADATA_CACHE_NAME, KEY_CACHE_LIST);
    }

    @Override
    public boolean insert(@NonNull BrokerApplicationMetadata brokerApplicationMetadata) {
        this.disposeOfDuplicateRecords(brokerApplicationMetadata.getClientId(), brokerApplicationMetadata.getEnvironment(), brokerApplicationMetadata.getUid());
        return super.insert(brokerApplicationMetadata);
    }

    public void remove(@NonNull String clientId, int processUid) {
        List allMetadata = this.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!clientId.equalsIgnoreCase(metadata.getClientId()) || processUid != metadata.getUid()) continue;
            this.remove(metadata);
        }
    }

    private void disposeOfDuplicateRecords(@NonNull String clientId, @NonNull String environment, int uid) {
        List allMetadata = this.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!clientId.equalsIgnoreCase(metadata.getClientId()) || !environment.equalsIgnoreCase(metadata.getEnvironment()) || uid != metadata.getUid()) continue;
            this.remove(metadata);
        }
    }

    @Override
    public Set<String> getAllClientIds() {
        String methodName = ":getAllClientIds";
        HashSet<String> allClientIds = new HashSet<String>();
        for (BrokerApplicationMetadata metadata : this.getAll()) {
            allClientIds.add(metadata.getClientId());
        }
        Logger.verbose(TAG + ":getAllClientIds", "Found [" + allClientIds.size() + "] client ids.");
        return allClientIds;
    }

    @Override
    public Set<String> getAllFociClientIds() {
        return this.getAllFociClientIds(false);
    }

    @Override
    public Set<String> getAllNonFociClientIds() {
        return this.getAllFociClientIds(true);
    }

    @Override
    public List<BrokerApplicationMetadata> getAllFociApplicationMetadata() {
        Set<String> fociClientIds = this.getAllFociClientIds();
        ArrayList<BrokerApplicationMetadata> result = new ArrayList<BrokerApplicationMetadata>();
        List allMetadata = this.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!fociClientIds.contains(metadata.getClientId())) continue;
            result.add(metadata);
        }
        return result;
    }

    private Set<String> getAllFociClientIds(boolean inverseMatch) {
        String methodName = ":getAllFociClientIds";
        HashSet<String> allFociClientIds = new HashSet<String>();
        for (BrokerApplicationMetadata metadata : this.getAll()) {
            if (!inverseMatch) {
                if (TextUtils.isEmpty((CharSequence)metadata.getFoci())) continue;
                allFociClientIds.add(metadata.getClientId());
                continue;
            }
            if (!TextUtils.isEmpty((CharSequence)metadata.getFoci())) continue;
            allFociClientIds.add(metadata.getClientId());
        }
        Logger.verbose(TAG + ":getAllFociClientIds", "Found [" + allFociClientIds.size() + "] client ids.");
        return allFociClientIds;
    }

    @Override
    @Nullable
    public BrokerApplicationMetadata getMetadata(@NonNull String clientId, @NonNull String environment, int processUid) {
        String methodName = ":getMetadata";
        List allMetadata = this.getAll();
        BrokerApplicationMetadata result = null;
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!clientId.equals(metadata.getClientId()) || !environment.equals(metadata.getEnvironment()) || processUid != metadata.getUid()) continue;
            Logger.verbose(TAG + metadata, "Metadata located.");
            result = metadata;
            break;
        }
        if (null == result) {
            Logger.warn(TAG + ":getMetadata", "Metadata could not be found for clientId, environment: [" + clientId + ", " + environment + "]");
        }
        return result;
    }

    @Override
    protected Type getListTypeToken() {
        return new TypeToken<List<BrokerApplicationMetadata>>(){}.getType();
    }
}

