/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BrokerData {
    public static final BrokerData MICROSOFT_AUTHENTICATOR_DEBUG = new BrokerData("com.azure.authenticator", "N1jdcbbnKDr0LaFZlqdhXgm2luE=");
    public static final BrokerData MICROSOFT_AUTHENTICATOR_PROD = new BrokerData("com.azure.authenticator", "ho040S3ffZkmxqtQrSwpTVOn9r0=");
    public static final BrokerData COMPANY_PORTAL = new BrokerData("com.microsoft.windowsintune.companyportal", "1L4Z9FJCgn5c0VLhyAxC5O9LdlE=");
    public static final BrokerData BROKER_HOST = new BrokerData("com.microsoft.identity.testuserapp", "1wIqXSqBj7w+h11ZifsnqwgyKrY=");
    private static final Set<BrokerData> DEBUG_BROKERS = Collections.unmodifiableSet(new HashSet<BrokerData>(){
        {
            this.add(MICROSOFT_AUTHENTICATOR_DEBUG);
            this.add(BROKER_HOST);
        }
    });
    private static final Set<BrokerData> PROD_BROKERS = Collections.unmodifiableSet(new HashSet<BrokerData>(){
        {
            this.add(MICROSOFT_AUTHENTICATOR_PROD);
            this.add(COMPANY_PORTAL);
        }
    });
    private static final Set<BrokerData> ALL_BROKERS = Collections.unmodifiableSet(new HashSet<BrokerData>(){
        {
            this.addAll(DEBUG_BROKERS);
            this.addAll(PROD_BROKERS);
        }
    });
    public final String packageName;
    public final String signatureHash;

    private BrokerData(@NonNull String packageName, @NonNull String hash) {
        this.packageName = packageName;
        this.signatureHash = hash;
    }

    @NonNull
    public static BrokerData getBrokerDataForBrokerApp(@NonNull Context context, @NonNull String brokerPackageName) throws ClientException {
        BrokerValidator validator = new BrokerValidator(context);
        return new BrokerData(brokerPackageName, validator.verifySignatureAndThrow(brokerPackageName));
    }

    public static Set<BrokerData> getProdBrokers() {
        return PROD_BROKERS;
    }

    public static Set<BrokerData> getDebugBrokers() {
        return DEBUG_BROKERS;
    }

    public static Set<BrokerData> getAllBrokers() {
        return ALL_BROKERS;
    }
}

