/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.net;

import android.os.Build;
import com.microsoft.identity.common.adal.internal.net.HttpWebRequest;
import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import com.microsoft.identity.common.adal.internal.net.IWebRequestHandler;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;

public class WebRequestHandler
implements IWebRequestHandler {
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_JSON = "application/json";
    private UUID mRequestCorrelationId = null;
    private String mCurrentClientVersion = "";

    @Override
    public HttpWebResponse sendGet(URL url, Map<String, String> headers) throws IOException {
        HttpWebRequest request = new HttpWebRequest(url, "GET", this.updateHeaders(headers));
        return request.send();
    }

    @Override
    public HttpWebResponse sendPost(URL url, Map<String, String> headers, byte[] content, String contentType) throws IOException {
        HttpWebRequest request = new HttpWebRequest(url, "POST", this.updateHeaders(headers), content, contentType);
        return request.send();
    }

    private Map<String, String> updateHeaders(Map<String, String> headers) {
        if (this.mRequestCorrelationId != null) {
            headers.put("client-request-id", this.mRequestCorrelationId.toString());
        }
        headers.put("x-client-SKU", "Android");
        headers.put("x-client-Ver", this.mCurrentClientVersion);
        headers.put("x-client-OS", "" + Build.VERSION.SDK_INT);
        headers.put("x-client-DM", Build.MODEL);
        return headers;
    }

    @Override
    public void setRequestCorrelationId(UUID requestCorrelationId) {
        this.mRequestCorrelationId = requestCorrelationId;
    }

    @Override
    public void setClientVersion(String clientVersion) {
        if (!StringExtensions.isNullOrBlank(clientVersion)) {
            this.mCurrentClientVersion = clientVersion;
        }
    }
}

