/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.security.KeyChain;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.logging.Logger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public final class ClientCertAuthChallengeHandler
implements IChallengeHandler<ClientCertRequest, Void> {
    private static final String TAG = ClientCertAuthChallengeHandler.class.getSimpleName();
    private static final String ACCEPTABLE_ISSUER = "CN=MS-Organization-Access";
    private Activity mActivity;

    public ClientCertAuthChallengeHandler(@NonNull Activity activity) {
        this.mActivity = activity;
    }

    @Override
    @TargetApi(value=21)
    public Void processChallenge(final @NonNull ClientCertRequest request) {
        Principal[] acceptableCertIssuers = request.getPrincipals();
        if (acceptableCertIssuers != null) {
            for (Principal issuer : acceptableCertIssuers) {
                if (!issuer.getName().contains(ACCEPTABLE_ISSUER)) continue;
                Logger.info(TAG, "Cancelling the TLS request, not respond to TLS challenge triggered by device authentication.");
                request.cancel();
                return null;
            }
        }
        KeyChain.choosePrivateKeyAlias((Activity)this.mActivity, (KeyChainAliasCallback)new KeyChainAliasCallback(){

            public void alias(String alias) {
                if (alias == null) {
                    Logger.info(TAG, "No certificate chosen by user, cancelling the TLS request.");
                    request.cancel();
                    return;
                }
                try {
                    X509Certificate[] certChain = KeyChain.getCertificateChain((Context)ClientCertAuthChallengeHandler.this.mActivity.getApplicationContext(), (String)alias);
                    PrivateKey privateKey = KeyChain.getPrivateKey((Context)ClientCertAuthChallengeHandler.this.mActivity, (String)alias);
                    Logger.info(TAG, "Certificate is chosen by user, proceed with TLS request.");
                    request.proceed(privateKey, certChain);
                    return;
                }
                catch (KeyChainException e) {
                    Logger.errorPII(TAG, "KeyChain exception", e);
                }
                catch (InterruptedException e) {
                    Logger.errorPII(TAG, "InterruptedException exception", e);
                }
                request.cancel();
            }
        }, (String[])request.getKeyTypes(), (Principal[])request.getPrincipals(), (String)request.getHost(), (int)request.getPort(), null);
        return null;
    }
}

