/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.configuration.LibraryConfiguration;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.CurrentTaskBrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.browser.BrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.browser.BrowserDescriptor;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.ui.webview.EmbeddedWebViewAuthorizationStrategy;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;

public class AuthorizationStrategyFactory<GenericAuthorizationStrategy extends AuthorizationStrategy> {
    private static final String TAG = AuthorizationStrategyFactory.class.getSimpleName();
    private static AuthorizationStrategyFactory sInstance = null;

    public static AuthorizationStrategyFactory getInstance() {
        if (sInstance == null) {
            sInstance = new AuthorizationStrategyFactory();
        }
        return sInstance;
    }

    public GenericAuthorizationStrategy getAuthorizationStrategy(@NonNull InteractiveTokenCommandParameters parameters) {
        Context context = parameters.getAndroidApplicationContext();
        AuthorizationAgent validatedAuthorizationAgent = this.validAuthorizationAgent(parameters.getAuthorizationAgent(), context);
        boolean isBrokerRequest = parameters instanceof BrokerInteractiveTokenCommandParameters;
        if (validatedAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
            Logger.info(TAG, "Use webView for authorization.");
            return this.getGenericAuthorizationStrategy(parameters, context);
        }
        if (validatedAuthorizationAgent == AuthorizationAgent.DEFAULT) {
            block4: {
                try {
                    BrowserSelector.select(context, parameters.getBrowserSafeList());
                }
                catch (ClientException exception) {
                    Logger.info(TAG, "No supported browser available found. Fallback to the webView authorization agent.");
                    if (!"No available browser installed on the device.".equalsIgnoreCase(exception.getErrorCode())) break block4;
                    return this.getGenericAuthorizationStrategy(parameters, context);
                }
            }
            Logger.info(TAG, "Use browser for authorization.");
            return this.getBrowserAuthorizationStrategy(context, parameters.getActivity(), parameters.getFragment(), isBrokerRequest, parameters.getBrowserSafeList());
        }
        Logger.info(TAG, "Use browser for authorization.");
        return this.getBrowserAuthorizationStrategy(context, parameters.getActivity(), parameters.getFragment(), isBrokerRequest, parameters.getBrowserSafeList());
    }

    private GenericAuthorizationStrategy getBrowserAuthorizationStrategy(@NonNull Context applicationContext, @NonNull Activity activity, @Nullable Fragment fragment, @NonNull boolean isBrokerRequest, @NonNull List<BrowserDescriptor> browserSafeList) {
        AuthorizationStrategy genericAuthorizationStrategy = null;
        if (LibraryConfiguration.getInstance().isAuthorizationInCurrentTask()) {
            CurrentTaskBrowserAuthorizationStrategy currentTaskBrowserAuthorizationStrategy = new CurrentTaskBrowserAuthorizationStrategy(applicationContext, activity, fragment);
            currentTaskBrowserAuthorizationStrategy.setBrowserSafeList(browserSafeList);
            genericAuthorizationStrategy = currentTaskBrowserAuthorizationStrategy;
        } else {
            BrowserAuthorizationStrategy browserAuthorizationStrategy = new BrowserAuthorizationStrategy(applicationContext, activity, fragment, isBrokerRequest);
            browserAuthorizationStrategy.setBrowserSafeList(browserSafeList);
            genericAuthorizationStrategy = browserAuthorizationStrategy;
        }
        return (GenericAuthorizationStrategy)genericAuthorizationStrategy;
    }

    private GenericAuthorizationStrategy getGenericAuthorizationStrategy(@NonNull InteractiveTokenCommandParameters parameters, Context context) {
        return (GenericAuthorizationStrategy)new EmbeddedWebViewAuthorizationStrategy(context, parameters.getActivity(), parameters.getFragment());
    }

    private AuthorizationAgent validAuthorizationAgent(AuthorizationAgent agent, Context context) {
        if (agent != AuthorizationAgent.WEBVIEW && BrowserSelector.getAllBrowsers(context).isEmpty()) {
            Logger.verbose(TAG, "Unable to use browser to do the authorization because No available browser installed on the device. Use embedded webView instead.");
            return AuthorizationAgent.WEBVIEW;
        }
        return agent;
    }
}

