/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.internal.configuration.LibraryConfiguration;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.BrokerAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.BrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskBrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.WebViewAuthorizationFragment;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiStartEvent;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.util.ProcessUtil;
import com.microsoft.identity.common.logging.DiagnosticContext;
import java.io.Serializable;
import java.util.HashMap;

public class AuthorizationActivityFactory {
    public static Intent getAuthorizationActivityIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, HashMap<String, String> requestHeaders, AuthorizationAgent authorizationAgent, boolean webViewZoomEnabled, boolean webViewZoomControlsEnabled) {
        LibraryConfiguration libraryConfig = LibraryConfiguration.getInstance();
        Intent intent = ProcessUtil.isBrokerProcess(context) ? new Intent(context, BrokerAuthorizationActivity.class) : (libraryConfig.isAuthorizationInCurrentTask() ? new Intent(context, CurrentTaskAuthorizationActivity.class) : new Intent(context, AuthorizationActivity.class));
        intent.putExtra("com.microsoft.identity.auth.intent", (Parcelable)authIntent);
        intent.putExtra("com.microsoft.identity.request.url", requestUrl);
        intent.putExtra("com.microsoft.identity.request.redirect.uri", redirectUri);
        intent.putExtra("com.microsoft.identity.request.headers", requestHeaders);
        intent.putExtra("com.microsoft.identity.client.authorization.agent", (Serializable)((Object)authorizationAgent));
        intent.putExtra("com.microsoft.identity.web.view.zoom.controls.enabled", webViewZoomControlsEnabled);
        intent.putExtra("com.microsoft.identity.web.view.zoom.enabled", webViewZoomEnabled);
        intent.putExtra("correlation_id", (String)DiagnosticContext.getRequestContext().get("correlation_id"));
        return intent;
    }

    public static Fragment getAuthorizationFragmentFromStartIntent(@NonNull Intent intent) {
        AuthorizationAgent authorizationAgent = (AuthorizationAgent)((Object)intent.getSerializableExtra("com.microsoft.identity.client.authorization.agent"));
        Telemetry.emit(new UiStartEvent().putUserAgent(authorizationAgent));
        LibraryConfiguration libraryConfig = LibraryConfiguration.getInstance();
        Fragment fragment = authorizationAgent == AuthorizationAgent.WEBVIEW ? new WebViewAuthorizationFragment() : (libraryConfig.isAuthorizationInCurrentTask() ? new CurrentTaskBrowserAuthorizationFragment() : new BrowserAuthorizationFragment());
        return fragment;
    }
}

