/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyInfo;
import android.security.keystore.StrongBoxUnavailableException;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.platform.DeviceKeyManager;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import com.microsoft.identity.common.internal.platform.IKeyManager;
import com.microsoft.identity.common.internal.platform.SecureHardwareState;
import com.microsoft.identity.common.internal.util.DateUtilities;
import com.microsoft.identity.common.internal.util.Supplier;
import com.microsoft.identity.common.logging.Logger;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.impl.RSAKeyUtils;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.x500.X500Principal;
import org.json.JSONException;
import org.json.JSONObject;

class DevicePopManager
implements IDevicePopManager {
    private static final String TAG = DevicePopManager.class.getSimpleName();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String DEFAULT_KEYSTORE_ENTRY_ALIAS = "microsoft-device-pop";
    private static final int RSA_KEY_SIZE = 2048;
    private static final String PRIVATE_KEY_NOT_FOUND = "Not an instance of a PrivateKeyEntry";
    public static final Type MAP_STRING_STRING_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    public static final Gson GSON = new Gson();
    private final IKeyManager<KeyStore.PrivateKeyEntry> mKeyManager;
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    private static final ExecutorService sThreadExecutor = Executors.newFixedThreadPool(5);

    DevicePopManager() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this(DEFAULT_KEYSTORE_ENTRY_ALIAS);
    }

    @Override
    public IKeyManager<KeyStore.PrivateKeyEntry> getKeyManager() {
        return this.mKeyManager;
    }

    DevicePopManager(@NonNull String alias) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore instance = KeyStore.getInstance(ANDROID_KEYSTORE);
        instance.load(null);
        this.mKeyManager = DeviceKeyManager.builder().keyAlias(alias).keyStore(instance).thumbprintSupplier(new Supplier<byte[]>(){

            @Override
            public byte[] get() {
                return DevicePopManager.this.getAsymmetricKeyThumbprint().getBytes(UTF8);
            }
        }).build();
    }

    @Override
    public boolean asymmetricKeyExists() {
        return this.mKeyManager.exists();
    }

    @Override
    public boolean asymmetricKeyExists(@NonNull String thumbprint) {
        return this.mKeyManager.hasThumbprint(thumbprint.getBytes(UTF8));
    }

    @Override
    public String getAsymmetricKeyThumbprint() throws ClientException {
        String errCode;
        Throwable exception;
        try {
            KeyStore.PrivateKeyEntry entry = this.mKeyManager.getEntry();
            return DevicePopManager.getRsaThumbprint(entry);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    public static String getRsaThumbprint(@NonNull KeyStore.PrivateKeyEntry entry) throws JOSEException {
        KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(entry);
        RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
        return DevicePopManager.getThumbprintForRsaKey(rsaKey);
    }

    @Override
    public void generateAsymmetricKey(final @NonNull Context context, final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onTaskCompleted(DevicePopManager.this.generateAsymmetricKey(context));
                }
                catch (ClientException e) {
                    callback.onError(e);
                }
            }
        });
    }

    @Override
    public String generateAsymmetricKey(@NonNull Context context) throws ClientException {
        String errCode;
        Throwable exception;
        try {
            KeyPair keyPair = this.generateNewRsaKeyPair(context, 2048);
            RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(keyPair);
            return DevicePopManager.getThumbprintForRsaKey(rsaKey);
        }
        catch (UnsupportedOperationException e) {
            exception = e;
            errCode = "keystore_produced_invalid_cert";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (NoSuchProviderException e) {
            exception = e;
            errCode = "android_keystore_unavailable";
        }
        catch (InvalidAlgorithmParameterException e) {
            exception = e;
            errCode = "keystore_initialization_failed";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    @Nullable
    public Date getAsymmetricKeyCreationDate() throws ClientException {
        return this.mKeyManager.getCreationDate();
    }

    @Override
    public boolean clearAsymmetricKey() {
        return this.mKeyManager.clear();
    }

    @Override
    public String getRequestConfirmation() throws ClientException {
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] result = new String[1];
        final ClientException[] errorResult = new ClientException[1];
        this.getRequestConfirmation(new TaskCompletedCallbackWithError<String, ClientException>(){

            @Override
            public void onTaskCompleted(@NonNull String reqCnf) {
                result[0] = reqCnf;
                latch.countDown();
            }

            @Override
            public void onError(@NonNull ClientException error) {
                errorResult[0] = error;
                latch.countDown();
            }
        });
        try {
            latch.await();
            if (null != result[0]) {
                return result[0];
            }
            throw errorResult[0];
        }
        catch (InterruptedException e) {
            Logger.error(TAG, "Interrupted while waiting on callback.", e);
            throw new ClientException("operation_interrupted", e.getMessage(), e);
        }
    }

    @Override
    public void getRequestConfirmation(final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                String errCode;
                Throwable exception;
                try {
                    KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)DevicePopManager.this.mKeyManager.getEntry();
                    KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
                    RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
                    String base64UrlEncodedJwkJsonStr = DevicePopManager.getReqCnfForRsaKey(rsaKey);
                    callback.onTaskCompleted(base64UrlEncodedJwkJsonStr);
                    return;
                }
                catch (KeyStoreException e) {
                    exception = e;
                    errCode = "keystore_not_initialized";
                }
                catch (NoSuchAlgorithmException e) {
                    exception = e;
                    errCode = "no_such_algorithm";
                }
                catch (UnrecoverableEntryException e) {
                    exception = e;
                    errCode = "protection_params_invalid";
                }
                catch (JOSEException e) {
                    exception = e;
                    errCode = "failed_to_compute_thumbprint_with_sha256";
                }
                catch (JSONException e) {
                    exception = e;
                    errCode = "json_construction_failed";
                }
                ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
                Logger.error(TAG, clientException.getMessage(), clientException);
                callback.onError(clientException);
            }
        });
    }

    @Override
    @NonNull
    public String sign(@NonNull IDevicePopManager.SigningAlgorithm alg, @NonNull String input) throws ClientException {
        return Base64.encodeToString((byte[])this.sign(alg, input.getBytes(UTF8)), (int)2);
    }

    @Override
    public byte[] sign(@NonNull IDevicePopManager.SigningAlgorithm alg, @NonNull byte[] inputBytesToSign) throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        String methodName = ":sign";
        try {
            KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
            if (!(keyEntry instanceof KeyStore.PrivateKeyEntry)) {
                Logger.warn(TAG + ":sign", PRIVATE_KEY_NOT_FOUND);
                throw new ClientException("invalid_key_private_key_missing");
            }
            Signature signature = Signature.getInstance(alg.toString());
            signature.initSign(keyEntry.getPrivateKey());
            signature.update(inputBytesToSign);
            return signature.sign();
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (InvalidKeyException e) {
            exception = e;
            errCode = "invalid_key";
        }
        catch (SignatureException e) {
            exception = e;
            errCode = "failed_to_sign";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG + ":sign", clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    public boolean verify(@NonNull IDevicePopManager.SigningAlgorithm alg, @NonNull String plainText, @NonNull String signatureStr) {
        return this.verify(alg, plainText.getBytes(UTF8), Base64.decode((String)signatureStr, (int)2));
    }

    @Override
    public boolean verify(@NonNull IDevicePopManager.SigningAlgorithm alg, @NonNull byte[] inputBytesToVerify, @NonNull byte[] signatureBytes) {
        GeneralSecurityException exception;
        String errCode;
        String methodName = ":verify";
        try {
            KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
            if (!(keyEntry instanceof KeyStore.PrivateKeyEntry)) {
                Logger.warn(TAG + methodName, PRIVATE_KEY_NOT_FOUND);
                return false;
            }
            Signature signature = Signature.getInstance(alg.toString());
            signature.initVerify(keyEntry.getCertificate());
            signature.update(inputBytesToVerify);
            return signature.verify(signatureBytes);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (SignatureException e) {
            errCode = "failed_to_sign";
            exception = e;
        }
        Logger.error(TAG + methodName, errCode, exception);
        return false;
    }

    @Override
    public String encrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull String plaintext) throws ClientException {
        return Base64.encodeToString((byte[])this.encrypt(cipher, plaintext.getBytes(UTF8)), (int)3);
    }

    @Override
    public byte[] encrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull byte[] plaintext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        String methodName = ":encrypt";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.mKeyManager.getEntry();
            PublicKey publicKey = privateKeyEntry.getCertificate().getPublicKey();
            Cipher input = Cipher.getInstance(cipher.toString());
            if (cipher.getParameters() != null) {
                input.init(1, (Key)publicKey, cipher.getParameters());
            } else {
                input.init(1, publicKey);
            }
            return input.doFinal(plaintext);
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG + ":encrypt", errCode, exception);
        throw clientException;
    }

    @Override
    public String decrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull String ciphertext) throws ClientException {
        return new String(this.decrypt(cipher, Base64.decode((String)ciphertext, (int)3)), UTF8);
    }

    @Override
    public byte[] decrypt(@NonNull IDevicePopManager.Cipher cipher, byte[] ciphertext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        String methodName = ":decrypt";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.mKeyManager.getEntry();
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            Cipher outputCipher = Cipher.getInstance(cipher.toString());
            if (cipher.getParameters() != null) {
                outputCipher.init(2, (Key)privateKey, cipher.getParameters());
            } else {
                outputCipher.init(2, privateKey);
            }
            return outputCipher.doFinal(ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG + ":decrypt", errCode, exception);
        throw clientException;
    }

    @Override
    public SecureHardwareState getSecureHardwareState() throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        try {
            KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(this.mKeyManager.getEntry());
            return this.getSecureHardwareState(rsaKeyPair);
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG + ":getSecureHardwareState", errCode, exception);
        throw clientException;
    }

    @Override
    @NonNull
    public String getPublicKey(@NonNull IDevicePopManager.PublicKeyFormat format) throws ClientException {
        String methodName = ":getPublicKey";
        switch (format) {
            case X_509_SubjectPublicKeyInfo_ASN_1: {
                return this.getX509SubjectPublicKeyInfo();
            }
            case JWK: {
                return this.getJwkPublicKey();
            }
        }
        String errMsg = "Unrecognized or unsupported key format: " + (Object)((Object)format);
        ClientException clientException = new ClientException("unknown_public_key_export_format", errMsg);
        Logger.error(TAG + ":getPublicKey", errMsg, clientException);
        throw clientException;
    }

    @Override
    public Certificate[] getCertificateChain() throws ClientException {
        return this.mKeyManager.getCertificateChain();
    }

    @NonNull
    private String getJwkPublicKey() throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        try {
            Map<String, Object> jwkMap = this.getDevicePopJwkMinifiedJson();
            return GSON.toJson(jwkMap.get("jwk"), MAP_STRING_STRING_TYPE);
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    private String getX509SubjectPublicKeyInfo() throws ClientException {
        String errCode;
        GeneralSecurityException exception;
        try {
            KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
            KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
            PublicKey publicKey = rsaKeyPair.getPublic();
            byte[] publicKeybytes = publicKey.getEncoded();
            byte[] bytesBase64Encoded = Base64.encode((byte[])publicKeybytes, (int)0);
            return new String(bytesBase64Encoded);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    public String mintSignedAccessToken(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @NonNull String accessToken, @Nullable String nonce) throws ClientException {
        return this.mintSignedAccessToken(httpMethod, timestamp, requestUrl, accessToken, nonce, null);
    }

    @Override
    public String mintSignedAccessToken(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @NonNull String accessToken, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        return this.mintSignedHttpRequestInternal(httpMethod, timestamp, requestUrl, accessToken, nonce, clientClaims);
    }

    @Override
    public String mintSignedHttpRequest(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        return this.mintSignedHttpRequestInternal(httpMethod, timestamp, requestUrl, null, nonce, clientClaims);
    }

    private String mintSignedHttpRequestInternal(@Nullable String httpMethod, long timestamp, @NonNull URL requestUrl, @Nullable String accessToken, @Nullable String nonce, @Nullable String clientClaims) throws ClientException {
        String errCode;
        Throwable exception;
        try {
            JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder();
            if (!TextUtils.isEmpty((CharSequence)accessToken)) {
                claimsBuilder.claim("at", (Object)accessToken);
            }
            claimsBuilder.claim("ts", (Object)timestamp);
            claimsBuilder.claim("u", (Object)requestUrl.getAuthority());
            claimsBuilder.claim("cnf", this.getDevicePopJwkMinifiedJson());
            if (!TextUtils.isEmpty((CharSequence)requestUrl.getPath())) {
                claimsBuilder.claim("p", (Object)requestUrl.getPath());
            }
            if (!TextUtils.isEmpty((CharSequence)httpMethod)) {
                claimsBuilder.claim("m", (Object)httpMethod);
            }
            if (!TextUtils.isEmpty((CharSequence)nonce)) {
                claimsBuilder.claim("nonce", (Object)nonce);
            }
            if (!TextUtils.isEmpty((CharSequence)clientClaims)) {
                claimsBuilder.claim("client_claims", (Object)clientClaims);
            }
            JWTClaimsSet claimsSet = claimsBuilder.build();
            KeyStore.PrivateKeyEntry entry = this.mKeyManager.getEntry();
            PrivateKey privateKey = entry.getPrivateKey();
            RSASSASigner signer = new RSASSASigner(privateKey);
            SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.getAsymmetricKeyThumbprint()).build(), claimsSet);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_sign_jwt";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @SuppressLint(value={"NewApi"})
    private KeyPair generateNewRsaKeyPair(@NonNull Context context, int minKeySize) throws UnsupportedOperationException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        int MAX_RETRIES = 4;
        for (int ii = 0; ii < 4; ++ii) {
            KeyPair kp = null;
            boolean tryStrongBox = true;
            boolean tryImport = true;
            boolean generated = false;
            while (!generated) {
                try {
                    kp = this.generateNewKeyPair(context, tryStrongBox, tryImport);
                    generated = true;
                }
                catch (ProviderException e) {
                    if (tryStrongBox && e.getClass().getSimpleName().equals("StrongBoxUnavailableException")) {
                        Logger.error(TAG, "StrongBox unsupported - skipping hardware flags.", e);
                        tryStrongBox = false;
                        continue;
                    }
                    if (tryImport && e.getClass().getSimpleName().equals("SecureKeyImportUnavailableException")) {
                        Logger.error(TAG, "Import unsupported - skipping import flags.", e);
                        tryImport = false;
                        continue;
                    }
                    throw e;
                }
            }
            int length = RSAKeyUtils.keyBitLength((PrivateKey)kp.getPrivate());
            if (length < minKeySize && length >= 0) continue;
            this.getSecureHardwareState(kp);
            return kp;
        }
        this.clearAsymmetricKey();
        throw new UnsupportedOperationException("Failed to generate valid KeyPair. Attempted 4 times.");
    }

    private SecureHardwareState getSecureHardwareState(@NonNull KeyPair kp) {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                PrivateKey privateKey = kp.getPrivate();
                KeyFactory factory = KeyFactory.getInstance(privateKey.getAlgorithm(), ANDROID_KEYSTORE);
                KeyInfo info = factory.getKeySpec(privateKey, KeyInfo.class);
                boolean isInsideSecureHardware = info.isInsideSecureHardware();
                Logger.info(TAG, "SecretKey is secure hardware backed? " + isInsideSecureHardware);
                return isInsideSecureHardware ? SecureHardwareState.TRUE_UNATTESTED : SecureHardwareState.FALSE;
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                Logger.error(TAG, "Failed to query secure hardware state.", e);
                return SecureHardwareState.UNKNOWN_QUERY_ERROR;
            }
        }
        Logger.info(TAG, "Cannot query secure hardware state (API unavailable <23)");
        return SecureHardwareState.UNKNOWN_DOWNLEVEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=18)
    private KeyPair generateNewKeyPair(@NonNull Context context, boolean useStrongbox, boolean enableImport) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StrongBoxUnavailableException {
        Object object = DateUtilities.isLocaleCalendarNonGregorian(Locale.getDefault()) ? DateUtilities.LOCALE_CHANGE_LOCK : new Object();
        synchronized (object) {
            KeyPair keyPair;
            Locale currentLocale = Locale.getDefault();
            StorageHelper.applyKeyStoreLocaleWorkarounds(currentLocale);
            try {
                KeyPair keyPair2;
                KeyPairGenerator kpg = this.getInitializedRsaKeyPairGenerator(context, 2048, useStrongbox, enableImport);
                keyPair = keyPair2 = kpg.generateKeyPair();
            }
            catch (Throwable throwable) {
                Locale.setDefault(currentLocale);
                throw throwable;
            }
            Locale.setDefault(currentLocale);
            return keyPair;
        }
    }

    @RequiresApi(api=18)
    private KeyPairGenerator getInitializedRsaKeyPairGenerator(@NonNull Context context, int keySize, boolean useStrongbox, boolean enableImport) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE);
        this.initialize(context, keyPairGenerator, keySize, useStrongbox, enableImport);
        return keyPairGenerator;
    }

    @RequiresApi(api=18)
    private void initialize(@NonNull Context context, @NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox, boolean enableImport) throws InvalidAlgorithmParameterException {
        if (Build.VERSION.SDK_INT < 23) {
            this.initializePre23(context, keyPairGenerator, keySize);
        } else if (Build.VERSION.SDK_INT < 28) {
            this.initialize23(keyPairGenerator, keySize, useStrongbox);
        } else {
            this.initialize28(keyPairGenerator, keySize, useStrongbox, enableImport);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresApi(api=23)
    private void initialize23(@NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox) throws InvalidAlgorithmParameterException {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.mKeyManager.getKeyAlias(), 15).setKeySize(keySize).setSignaturePaddings(new String[]{"PKCS1", "PSS"}).setDigests(new String[]{"MD5", "NONE", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}).setEncryptionPaddings(new String[]{"OAEPPadding", "PKCS1Padding"});
        if (Build.VERSION.SDK_INT >= 24) {
            builder = this.setAttestationChallenge(builder);
        }
        if (Build.VERSION.SDK_INT >= 28 && useStrongbox) {
            Logger.verbose(TAG, "Attempting to apply StrongBox isolation.");
            builder = DevicePopManager.applyHardwareIsolation(builder);
        }
        KeyGenParameterSpec spec = builder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=24)
    @NonNull
    private KeyGenParameterSpec.Builder setAttestationChallenge(@NonNull KeyGenParameterSpec.Builder builder) {
        return builder.setAttestationChallenge(new byte[0]);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=28)
    @NonNull
    private static KeyGenParameterSpec.Builder applyHardwareIsolation(@NonNull KeyGenParameterSpec.Builder builder) {
        return builder.setIsStrongBoxBacked(true);
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresApi(api=28)
    private void initialize28(@NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox, boolean enableImport) throws InvalidAlgorithmParameterException {
        int purposes = 15;
        if (enableImport && Build.VERSION.SDK_INT >= 28) {
            purposes |= 0x20;
        }
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.mKeyManager.getKeyAlias(), purposes).setKeySize(keySize).setSignaturePaddings(new String[]{"PKCS1", "PSS"}).setDigests(new String[]{"MD5", "NONE", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}).setEncryptionPaddings(new String[]{"OAEPPadding", "PKCS1Padding"});
        if (Build.VERSION.SDK_INT >= 24) {
            builder = this.setAttestationChallenge(builder);
        }
        if (Build.VERSION.SDK_INT >= 28 && useStrongbox) {
            Logger.verbose(TAG, "Attempting to apply StrongBox isolation.");
            builder = DevicePopManager.applyHardwareIsolation(builder);
        }
        KeyGenParameterSpec spec = builder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=18)
    private void initializePre23(@NonNull Context context, @NonNull KeyPairGenerator keyPairGenerator, int keySize) throws InvalidAlgorithmParameterException {
        Calendar calendar = Calendar.getInstance();
        Date start = DevicePopManager.getNow(calendar);
        calendar.add(1, 99);
        Date end = calendar.getTime();
        KeyPairGeneratorSpec.Builder specBuilder = new KeyPairGeneratorSpec.Builder(context).setAlias(this.mKeyManager.getKeyAlias()).setStartDate(start).setEndDate(end).setSerialNumber(CertificateProperties.SERIAL_NUMBER).setSubject(new X500Principal("CN=device-pop"));
        if (Build.VERSION.SDK_INT >= 19) {
            specBuilder.setAlgorithmParameterSpec((AlgorithmParameterSpec)new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4));
        }
        KeyPairGeneratorSpec spec = specBuilder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    private static Date getNow(@NonNull Calendar calendar) {
        return calendar.getTime();
    }

    private static KeyPair getKeyPairForEntry(@NonNull KeyStore.PrivateKeyEntry entry) {
        PrivateKey privateKey = entry.getPrivateKey();
        PublicKey publicKey = entry.getCertificate().getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    @Override
    public PublicKey getPublicKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
        return keyEntry.getCertificate().getPublicKey();
    }

    private static RSAKey getRsaKeyForKeyPair(@NonNull KeyPair keyPair) {
        return new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).keyUse(null).build();
    }

    private static String getReqCnfForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException, JSONException {
        String thumbprintStr = DevicePopManager.getThumbprintForRsaKey(rsaKey);
        String thumbprintMinifiedJson = new JSONObject().put("kid", (Object)thumbprintStr).toString();
        return DevicePopManager.base64UrlEncode(thumbprintMinifiedJson);
    }

    private static String getThumbprintForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException {
        Base64URL thumbprint = rsaKey.computeThumbprint();
        return thumbprint.toString();
    }

    private static String base64UrlEncode(@NonNull String input) {
        byte[] encodeBytes = input.getBytes(UTF8);
        return Base64.encodeToString((byte[])encodeBytes, (int)11);
    }

    private Map<String, Object> getDevicePopJwkMinifiedJson() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.PrivateKeyEntry keyEntry = this.mKeyManager.getEntry();
        KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
        RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
        RSAKey publicRsaKey = rsaKey.toPublicJWK();
        Map jwkContents = publicRsaKey.toJSONObject();
        HashMap<String, Object> wrappedJwk = new HashMap<String, Object>();
        wrappedJwk.put("jwk", jwkContents);
        return wrappedJwk;
    }

    static final class KeyPairGeneratorAlgorithms {
        static final String RSA = "RSA";

        KeyPairGeneratorAlgorithms() {
        }
    }

    private static final class SignedHttpRequestJwtClaims {
        private static final String ACCESS_TOKEN = "at";
        private static final String TIMESTAMP = "ts";
        private static final String HTTP_METHOD = "m";
        private static final String HTTP_HOST = "u";
        private static final String HTTP_PATH = "p";
        private static final String CNF = "cnf";
        private static final String NONCE = "nonce";
        private static final String CLIENT_CLAIMS = "client_claims";
        public static final String JWK = "jwk";

        private SignedHttpRequestJwtClaims() {
        }
    }

    private static final class CertificateProperties {
        static final int CERTIFICATE_VALIDITY_YEARS = 99;
        static final BigInteger SERIAL_NUMBER = BigInteger.ONE;
        static final String COMMON_NAME = "CN=device-pop";

        private CertificateProperties() {
        }
    }
}

