/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import com.microsoft.identity.common.logging.Logger;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class CustomTabsManager {
    private static final String TAG = CustomTabsManager.class.getSimpleName();
    private static final long CUSTOM_TABS_MAX_CONNECTION_TIMEOUT = 1L;
    private final CountDownLatch mClientLatch;
    private final WeakReference<Context> mContextRef;
    private final AtomicReference<CustomTabsClient> mCustomTabsClient;
    private boolean mCustomTabsServiceIsBound;
    private CustomTabsIntent mCustomTabsIntent;
    private CustomTabsServiceConnection mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

        public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
            Logger.info(TAG, "CustomTabsService is connected");
            client.warmup(0L);
            CustomTabsManager.this.mCustomTabsServiceIsBound = true;
            CustomTabsManager.this.mCustomTabsClient.set(client);
            CustomTabsManager.this.mClientLatch.countDown();
        }

        public void onServiceDisconnected(ComponentName name) {
            Logger.info(TAG, "CustomTabsService is disconnected");
            CustomTabsManager.this.mCustomTabsServiceIsBound = false;
            CustomTabsManager.this.mCustomTabsClient.set(null);
            CustomTabsManager.this.mClientLatch.countDown();
        }
    };

    public CustomTabsIntent getCustomTabsIntent() {
        return this.mCustomTabsIntent;
    }

    public CustomTabsManager(@NonNull Context context) {
        this.mContextRef = new WeakReference<Context>(context);
        this.mCustomTabsClient = new AtomicReference();
        this.mClientLatch = new CountDownLatch(1);
    }

    public synchronized boolean bind(@NonNull Context context, @NonNull String browserPackage) {
        if (context == null || !CustomTabsClient.bindCustomTabsService((Context)context, (String)browserPackage, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection)) {
            Logger.info(TAG, "Unable to bind custom tabs service " + (context == null ? "because the context was null" : "because the bind call failed"));
            this.mClientLatch.countDown();
            return false;
        }
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.createSession(null));
        this.mCustomTabsIntent = builder.setShowTitle(true).build();
        this.mCustomTabsIntent.intent.setPackage(browserPackage);
        return true;
    }

    private CustomTabsSession createSession(@Nullable CustomTabsCallback callback) {
        CustomTabsClient client = this.getClient();
        if (client == null) {
            Logger.warn(TAG, "Failed to create custom tabs session with null CustomTabClient.");
            return null;
        }
        CustomTabsSession session = client.newSession(callback);
        if (session == null) {
            Logger.warn(TAG, "Failed to create custom tabs session through custom tabs client.");
        }
        return session;
    }

    public CustomTabsClient getClient() {
        try {
            this.mClientLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.info(TAG, "Interrupted while waiting for browser connection");
            this.mClientLatch.countDown();
        }
        return this.mCustomTabsClient.get();
    }

    public synchronized void unbind() {
        if (this.mContextRef.get() != null && this.mCustomTabsServiceIsBound) {
            ((Context)this.mContextRef.get()).unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
        }
        this.mCustomTabsServiceIsBound = false;
        this.mCustomTabsClient.set(null);
        Logger.info(TAG, "CustomTabsService is unbound.");
    }
}

