/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.platform.AndroidKeystoreAsymmetricRsaKey;
import com.microsoft.identity.common.internal.platform.AsymmetricRsaKey;
import com.microsoft.identity.common.internal.platform.AsymmetricRsaKeyFactory;
import com.microsoft.identity.common.internal.platform.DevicePopManager;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class AndroidKeystoreAsymmetricRsaKeyFactory
implements AsymmetricRsaKeyFactory {
    private final Context mContext;

    public AndroidKeystoreAsymmetricRsaKeyFactory(@NonNull Context context) {
        this.mContext = context;
    }

    @Override
    public synchronized AsymmetricRsaKey generateAsymmetricKey(@NonNull String alias) throws ClientException {
        String errCode;
        Exception exception;
        try {
            return new AndroidKeystoreAsymmetricRsaKey(this.mContext, new DevicePopManager(alias), alias);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (CertificateException e) {
            exception = e;
            errCode = "certificate_load_failure";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (IOException e) {
            exception = e;
            errCode = "io_error";
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    public synchronized AsymmetricRsaKey loadAsymmetricKey(@NonNull String alias) throws ClientException {
        return this.generateAsymmetricKey(alias);
    }

    @Override
    public synchronized boolean clearAsymmetricKey(@NonNull String alias) throws ClientException {
        String errCode;
        Exception exception;
        try {
            return new DevicePopManager(alias).clearAsymmetricKey();
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (CertificateException e) {
            exception = e;
            errCode = "certificate_load_failure";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (IOException e) {
            exception = e;
            errCode = "io_error";
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }
}

