/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.platform.CryptoSuite;
import com.microsoft.identity.common.internal.platform.KeyAccessor;
import com.microsoft.identity.common.internal.platform.KeyStoreAccessor;
import com.microsoft.identity.common.internal.platform.SP800108KeyGen;
import com.microsoft.identity.common.internal.platform.SecureHardwareState;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public class RawKeyAccessor
implements KeyAccessor {
    private final CryptoSuite suite;
    private final byte[] key;
    private static final SecureRandom mRandom = new SecureRandom();

    public byte[] getRawKey() {
        return Arrays.copyOf(this.key, this.key.length);
    }

    @Override
    public byte[] encrypt(@NonNull byte[] plaintext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (plaintext == null) {
            throw new NullPointerException("plaintext is marked non-null but is null");
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.key, this.suite.cipher().name());
            Cipher c = Cipher.getInstance(keySpec.getAlgorithm());
            byte[] iv = new byte[12];
            mRandom.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            c.init(1, (Key)keySpec, ivSpec);
            c.update(plaintext);
            byte[] tmp = c.doFinal();
            byte[] output = new byte[iv.length + tmp.length];
            System.arraycopy(iv, 0, output, 0, iv.length);
            System.arraycopy(tmp, 0, output, iv.length, tmp.length);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage());
    }

    @Override
    public byte[] decrypt(@NonNull byte[] ciphertext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (ciphertext == null) {
            throw new NullPointerException("ciphertext is marked non-null but is null");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(this.key, this.suite.cipher().name());
            Cipher c = Cipher.getInstance(key.getAlgorithm());
            IvParameterSpec ivSpec = new IvParameterSpec(ciphertext, 0, 12);
            c.init(2, (Key)key, ivSpec);
            byte[] out = Arrays.copyOfRange(ciphertext, 12, ciphertext.length);
            return c.doFinal(out);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    public byte[] sign(@NonNull byte[] text) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(this.key, this.suite.cipher().name());
            Mac mac = Mac.getInstance(this.suite.macName());
            mac.init(key);
            return mac.doFinal(text);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage());
    }

    @Override
    public boolean verify(@NonNull byte[] text, @NonNull byte[] signature) throws ClientException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        return Arrays.equals(signature, this.sign(text));
    }

    @Override
    public byte[] getThumprint() throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        SecretKeySpec keySpec = new SecretKeySpec(this.key, this.suite.cipher().name());
        try {
            Cipher cipher = Cipher.getInstance(keySpec.getAlgorithm());
            MessageDigest digest = MessageDigest.getInstance("SHA256");
            return digest.digest(cipher.doFinal((keySpec.getAlgorithm() + cipher.getBlockSize() + cipher.getParameters()).getBytes(KeyStoreAccessor.UTF8)));
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    @Nullable
    public Certificate[] getCertificateChain() {
        return null;
    }

    @Override
    public SecureHardwareState getSecureHardwareState() {
        return SecureHardwareState.FALSE;
    }

    public byte[] generateDerivedKey(@NonNull byte[] label, @NonNull byte[] ctx) throws ClientException {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        try {
            return SP800108KeyGen.generateDerivedKey(this.key, label, ctx);
        }
        catch (IOException e) {
            throw new ClientException("io_error", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
    }

    public KeyAccessor generateDerivedKey(@NonNull byte[] label, @NonNull byte[] ctx, @NonNull CryptoSuite suite) throws ClientException {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (suite == null) {
            throw new NullPointerException("suite is marked non-null but is null");
        }
        try {
            return new RawKeyAccessor(suite, SP800108KeyGen.generateDerivedKey(this.key, label, ctx));
        }
        catch (IOException e) {
            throw new ClientException("io_error", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
    }

    RawKeyAccessor(CryptoSuite suite, byte[] key) {
        this.suite = suite;
        this.key = key;
    }

    public static RawKeyAccessorBuilder builder() {
        return new RawKeyAccessorBuilder();
    }

    public static class RawKeyAccessorBuilder {
        private CryptoSuite suite;
        private byte[] key;

        RawKeyAccessorBuilder() {
        }

        public RawKeyAccessorBuilder suite(CryptoSuite suite) {
            this.suite = suite;
            return this;
        }

        public RawKeyAccessorBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        public RawKeyAccessor build() {
            return new RawKeyAccessor(this.suite, this.key);
        }

        public String toString() {
            return "RawKeyAccessor.RawKeyAccessorBuilder(suite=" + this.suite + ", key=" + Arrays.toString(this.key) + ")";
        }
    }
}

