/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.util.Base64;
import java.nio.charset.Charset;
import org.json.JSONException;
import org.json.JSONObject;

public class JweResponse {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    JweHeader mJweHeader;
    String mEncryptedKey;
    String mIv;
    String mPayload;
    String mAuthenticationTag;

    public JweHeader getJweHeader() {
        return this.mJweHeader;
    }

    public String getEncryptedKey() {
        return this.mEncryptedKey;
    }

    public String getIV() {
        return this.mIv;
    }

    public String getPayload() {
        return this.mPayload;
    }

    public String getAuthenticationTag() {
        return this.mAuthenticationTag;
    }

    public static JweResponse parseJwe(String jwe) throws JSONException {
        JweResponse response = new JweResponse();
        String[] split = jwe.split("\\.");
        if (split.length < 4) {
            throw new IllegalArgumentException("Invalid JWE");
        }
        String header = split[0];
        response.mEncryptedKey = split[1];
        response.mIv = split[2];
        response.mPayload = split[3];
        if (split.length > 4) {
            response.mAuthenticationTag = split[4];
        }
        byte[] headerDecodedBytes = Base64.decode((String)header, (int)8);
        String decodedHeader = new String(headerDecodedBytes, UTF_8);
        JSONObject jsonObject = new JSONObject(decodedHeader);
        JweHeader headerJson = new JweHeader();
        headerJson.mHeaderAlg = jsonObject.optString("alg");
        headerJson.mHeaderType = jsonObject.optString("typ");
        headerJson.mHeaderX509CertificateThumbprint = jsonObject.optString("x5t");
        headerJson.mHeaderX509Certificate = jsonObject.optString("x5c");
        headerJson.mHeaderKeyID = jsonObject.optString("kid");
        headerJson.mHeaderKeyUse = jsonObject.optString("use");
        headerJson.mHeaderEncryptionAlgorithm = jsonObject.optString("enc");
        headerJson.mHeaderContext = jsonObject.optString("ctx");
        response.mJweHeader = headerJson;
        return response;
    }

    public static class JweHeader {
        public String mHeaderAlg;
        public String mHeaderType;
        public String mHeaderX509CertificateThumbprint;
        public String mHeaderX509Certificate;
        public String mHeaderKeyID;
        public String mHeaderKeyUse;
        public String mHeaderEncryptionAlgorithm;
        public String mHeaderContext;
    }
}

