/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net;

import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.microsoft.identity.common.internal.commands.parameters.IHasExtraParameters;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public final class ObjectMapper {
    public static final String ENCODING_SCHEME = "UTF-8";
    public static final String TAG = ObjectMapper.class.getSimpleName();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new UnknownParamTypeAdapterFactory()).create();

    private ObjectMapper() {
    }

    public static String serializeObjectToJsonString(Object object) {
        return GSON.toJson(object);
    }

    public static String serializeExposedFieldsOfObjectToJsonString(Object object) {
        GsonBuilder builder = new GsonBuilder();
        builder.excludeFieldsWithoutExposeAnnotation();
        Gson gson = builder.create();
        return gson.toJson(object);
    }

    public static <T> T deserializeJsonStringToObject(String json, Class<T> objectClass) {
        return (T)GSON.fromJson(json, objectClass);
    }

    public static String serializeObjectToFormUrlEncoded(Object object) throws UnsupportedEncodingException {
        Map<String, String> fields = ObjectMapper.constuctMapFromObject(object);
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            builder.append(URLEncoder.encode(entry.getKey(), ENCODING_SCHEME));
            builder.append('=');
            builder.append(URLEncoder.encode(entry.getValue(), ENCODING_SCHEME));
            if (!iterator.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    public static Map<String, String> constuctMapFromObject(Object object) {
        IHasExtraParameters params;
        String json = ObjectMapper.serializeObjectToJsonString(object);
        Type stringMap = new TypeToken<TreeMap<String, String>>(){}.getType();
        TreeMap fields = (TreeMap)new Gson().fromJson(json, stringMap);
        if (object instanceof IHasExtraParameters && (params = (IHasExtraParameters)object).getExtraParameters() != null) {
            for (Map.Entry<String, String> e : params.getExtraParameters()) {
                if (e.getKey() == null) continue;
                fields.put(e.getKey(), e.getValue());
            }
        }
        return fields;
    }

    public static Map<String, Object> serializeObjectHashMap(Object object) {
        String json = ObjectMapper.serializeObjectToJsonString(object);
        Map objectHashMap = (Map)GSON.fromJson(json, Map.class);
        return objectHashMap;
    }

    public static Map<String, String> deserializeQueryStringToMap(String queryString) {
        HashMap<String, String> decodedUrlMap = new HashMap<String, String>();
        if (StringUtil.isEmpty(queryString)) {
            return decodedUrlMap;
        }
        StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
        while (tokenizer.hasMoreTokens()) {
            String pair = tokenizer.nextToken();
            String[] elements = pair.split("=");
            if (elements.length != 2) continue;
            try {
                String key = URLDecoder.decode(elements[0], ENCODING_SCHEME);
                String value = URLDecoder.decode(elements[1], ENCODING_SCHEME);
                if (StringUtil.isEmpty(key) || StringUtil.isEmpty(value)) continue;
                decodedUrlMap.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(TAG, null, "Decode failed.", e);
            }
        }
        return decodedUrlMap;
    }

    public static class UnknownParamTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final TypeAdapter adapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            if (IHasExtraParameters.class.isAssignableFrom(type.getRawType())) {
                return new TypeAdapter<T>(){

                    public void write(JsonWriter out, T value) throws IOException {
                        adapter.write(out, value);
                    }

                    public T read(final JsonReader in) throws IOException {
                        final LinkedHashMap otherKeys = new LinkedHashMap();
                        Reader reader = new Reader(){

                            @Override
                            public int read(char[] cbuf, int off, int len) throws IOException {
                                return 0;
                            }

                            @Override
                            public void close() throws IOException {
                            }
                        };
                        JsonReader jsonReader = new JsonReader(reader){
                            String lastName;
                            {
                                super(x0);
                                this.lastName = null;
                            }

                            public void beginArray() throws IOException {
                                in.beginArray();
                            }

                            public void endArray() throws IOException {
                                in.endArray();
                            }

                            public void beginObject() throws IOException {
                                in.beginObject();
                            }

                            public void endObject() throws IOException {
                                in.endObject();
                            }

                            public boolean hasNext() throws IOException {
                                return in.hasNext();
                            }

                            public JsonToken peek() throws IOException {
                                return in.peek();
                            }

                            public String nextName() throws IOException {
                                String name;
                                this.lastName = name = in.nextName();
                                return name;
                            }

                            public String nextString() throws IOException {
                                return in.nextString();
                            }

                            public boolean nextBoolean() throws IOException {
                                return in.nextBoolean();
                            }

                            public void nextNull() throws IOException {
                                in.nextNull();
                            }

                            public double nextDouble() throws IOException {
                                return in.nextDouble();
                            }

                            public long nextLong() throws IOException {
                                return in.nextLong();
                            }

                            public int nextInt() throws IOException {
                                return in.nextInt();
                            }

                            public void close() throws IOException {
                                in.close();
                            }

                            public void skipValue() throws IOException {
                                JsonToken token = in.peek();
                                if (token == JsonToken.STRING) {
                                    otherKeys.put(this.lastName, in.nextString());
                                } else {
                                    in.skipValue();
                                }
                            }

                            @NonNull
                            public String toString() {
                                return in.toString();
                            }

                            public String getPath() {
                                return in.getPath();
                            }
                        };
                        Object output = adapter.read(jsonReader);
                        ((IHasExtraParameters)output).setExtraParameters(Collections.unmodifiableMap(otherKeys).entrySet());
                        return output;
                    }
                };
            }
            return null;
        }
    }
}

