/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.configuration;

import com.microsoft.identity.common.internal.logging.Logger;
import lombok.NonNull;

public class LibraryConfiguration {
    private static final String TAG = LibraryConfiguration.class.getSimpleName();
    private static LibraryConfiguration sInstance = null;
    private boolean authorizationInCurrentTask;

    public static synchronized LibraryConfiguration getInstance() {
        if (sInstance == null) {
            sInstance = LibraryConfiguration.createDefaultInstance();
        }
        return sInstance;
    }

    public static synchronized void intializeLibraryConfiguration(@NonNull LibraryConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (sInstance == null) {
            sInstance = config;
        } else {
            Logger.warn(TAG, "MsalConfiguration was already initialized");
        }
    }

    private static synchronized LibraryConfiguration createDefaultInstance() {
        return LibraryConfiguration.builder().authorizationInCurrentTask(false).build();
    }

    LibraryConfiguration(boolean authorizationInCurrentTask) {
        this.authorizationInCurrentTask = authorizationInCurrentTask;
    }

    public static LibraryConfigurationBuilder builder() {
        return new LibraryConfigurationBuilder();
    }

    public boolean isAuthorizationInCurrentTask() {
        return this.authorizationInCurrentTask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LibraryConfiguration)) {
            return false;
        }
        LibraryConfiguration other = (LibraryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isAuthorizationInCurrentTask() == other.isAuthorizationInCurrentTask();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LibraryConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthorizationInCurrentTask() ? 79 : 97);
        return result;
    }

    public static class LibraryConfigurationBuilder {
        private boolean authorizationInCurrentTask;

        LibraryConfigurationBuilder() {
        }

        public LibraryConfigurationBuilder authorizationInCurrentTask(boolean authorizationInCurrentTask) {
            this.authorizationInCurrentTask = authorizationInCurrentTask;
            return this;
        }

        public LibraryConfiguration build() {
            return new LibraryConfiguration(this.authorizationInCurrentTask);
        }

        public String toString() {
            return "LibraryConfiguration.LibraryConfigurationBuilder(authorizationInCurrentTask=" + this.authorizationInCurrentTask + ")";
        }
    }
}

