/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.logging.Logger;
import java.util.Map;

public final class SchemaUtil {
    private static final String TAG = SchemaUtil.class.getSimpleName();
    private static final String EXCEPTION_CONSTRUCTING_IDTOKEN = "Exception constructing IDToken. ";
    public static final String MISSING_FROM_THE_TOKEN_RESPONSE = "Missing from the token response";

    private SchemaUtil() {
    }

    public static String getAuthority(IDToken idToken) {
        String methodName = "getAuthority";
        String issuer = null;
        if (null != idToken) {
            Map<String, ?> idTokenClaims = idToken.getTokenClaims();
            if (null != idTokenClaims) {
                issuer = (String)idTokenClaims.get("iss");
                Logger.verbosePII(TAG + ":" + "getAuthority", "Issuer: " + issuer);
                if (null == issuer) {
                    Logger.warn(TAG + ":" + "getAuthority", "Environment was null or could not be parsed.");
                }
            } else {
                Logger.warn(TAG + ":" + "getAuthority", "IDToken claims were null");
            }
        } else {
            Logger.warn(TAG + ":" + "getAuthority", "IDToken was null");
        }
        return issuer;
    }

    public static String getAvatarUrl(IDToken idToken) {
        String methodName = "getAvatarUrl";
        String avatarUrl = null;
        if (null != idToken) {
            Map<String, ?> idTokenClaims = idToken.getTokenClaims();
            if (null != idTokenClaims) {
                avatarUrl = (String)idTokenClaims.get("picture");
                Logger.verbosePII(TAG + ":" + "getAvatarUrl", "Avatar URL: " + avatarUrl);
                if (null == avatarUrl) {
                    Logger.warn(TAG + ":" + "getAvatarUrl", "Avatar URL was null.");
                }
            } else {
                Logger.warn(TAG + ":" + "getAvatarUrl", "IDToken claims were null.");
            }
        } else {
            Logger.warn(TAG + ":" + "getAvatarUrl", "IDToken was null.");
        }
        return avatarUrl;
    }

    public static String getAlternativeAccountId(IDToken idToken) {
        String methodName = "getAlternativeAccountId";
        String alternativeAccountId = null;
        if (null != idToken) {
            Map<String, ?> idTokenClaims = idToken.getTokenClaims();
            if (null != idTokenClaims) {
                alternativeAccountId = (String)idTokenClaims.get("altsecid");
                Logger.verbosePII(TAG + ":" + "getAlternativeAccountId", "alternative_account_id: " + alternativeAccountId);
                if (null == alternativeAccountId) {
                    Logger.warn(TAG + ":" + "getAlternativeAccountId", "alternative_account_id was null.");
                }
            } else {
                Logger.warn(TAG + ":" + "getAlternativeAccountId", "IDToken claims were null.");
            }
        } else {
            Logger.warn(TAG + ":" + "getAlternativeAccountId", "IDToken was null.");
        }
        return alternativeAccountId;
    }

    public static String getCredentialTypeFromVersion(@Nullable String idTokenString) {
        String methodName = "getCredentialTypeFromVersion";
        String idTokenVersion = CredentialType.IdToken.name();
        if (!TextUtils.isEmpty((CharSequence)idTokenString)) {
            try {
                IDToken idToken = new IDToken(idTokenString);
                Map<String, ?> idTokenClaims = idToken.getTokenClaims();
                String aadVersion = (String)idTokenClaims.get("ver");
                if ("1.0".equalsIgnoreCase(aadVersion)) {
                    idTokenVersion = CredentialType.V1IdToken.name();
                }
            }
            catch (ServiceException e) {
                Logger.warn(TAG + ":" + "getCredentialTypeFromVersion", EXCEPTION_CONSTRUCTING_IDTOKEN + e.getMessage());
            }
        }
        return idTokenVersion;
    }

    public static String getIdentityProvider(String idTokenString) {
        String idp;
        block6: {
            String methodName = "getIdentityProvider";
            idp = null;
            if (null != idTokenString) {
                try {
                    IDToken idToken = new IDToken(idTokenString);
                    Map<String, ?> idTokenClaims = idToken.getTokenClaims();
                    if (null != idTokenClaims) {
                        idp = (String)idTokenClaims.get("idp");
                        Logger.verbosePII(TAG + ":" + "getIdentityProvider", "idp: " + idp);
                        if (null == idp) {
                            Logger.info(TAG + ":" + "getIdentityProvider", "idp claim was null.");
                        }
                        break block6;
                    }
                    Logger.warn(TAG + ":" + "getIdentityProvider", "IDToken claims were null.");
                }
                catch (ServiceException e) {
                    Logger.warn(TAG + ":" + "getIdentityProvider", EXCEPTION_CONSTRUCTING_IDTOKEN + e.getMessage());
                }
            } else {
                Logger.warn(TAG + ":" + "getIdentityProvider", "IDToken was null.");
            }
        }
        return idp;
    }

    public static String getHomeAccountId(ClientInfo clientInfo) {
        String methodName = ":getHomeAccountId";
        String homeAccountId = null;
        if (null != clientInfo) {
            String uid = clientInfo.getUid();
            String utid = clientInfo.getUtid();
            if (StringExtensions.isNullOrBlank(uid)) {
                Logger.warn(TAG + ":" + ":getHomeAccountId", "uid was null/blank");
            }
            if (StringExtensions.isNullOrBlank(utid)) {
                Logger.warn(TAG + ":" + ":getHomeAccountId", "utid was null/blank");
            }
            if (!StringExtensions.isNullOrBlank(uid) && !StringExtensions.isNullOrBlank(utid)) {
                homeAccountId = uid + "." + utid;
            }
            Logger.verbosePII(TAG + ":" + ":getHomeAccountId", "home_account_id: " + homeAccountId);
        } else {
            Logger.warn(TAG + ":" + ":getHomeAccountId", "ClientInfo was null.");
        }
        return homeAccountId;
    }

    @Nullable
    public static String getTenantId(@Nullable String clientInfoString, @Nullable String idTokenString) {
        String tenantId = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)idTokenString) && !TextUtils.isEmpty((CharSequence)clientInfoString)) {
                IDToken idToken = new IDToken(idTokenString);
                ClientInfo clientInfo = new ClientInfo(clientInfoString);
                Map<String, ?> claims = idToken.getTokenClaims();
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)claims.get("tid")))) {
                    tenantId = (String)claims.get("tid");
                } else if (!TextUtils.isEmpty((CharSequence)clientInfo.getUtid())) {
                    Logger.warn(TAG, "realm is not returned from server. Use utid as realm.");
                    tenantId = clientInfo.getUtid();
                } else {
                    Logger.warn(TAG, "realm and utid is not returned from server. Using empty string as default tid.");
                }
            }
        }
        catch (ServiceException e) {
            Logger.errorPII(TAG, "Failed to construct IDToken or ClientInfo", e);
        }
        return tenantId;
    }

    public static String getDisplayableId(@NonNull Map<String, ?> claims) {
        if (!StringExtensions.isNullOrBlank((String)claims.get("preferred_username"))) {
            return (String)claims.get("preferred_username");
        }
        if (!StringExtensions.isNullOrBlank((String)claims.get("email"))) {
            return (String)claims.get("email");
        }
        if (!StringExtensions.isNullOrBlank((String)claims.get("upn"))) {
            return (String)claims.get("upn");
        }
        Logger.warn(TAG, "The preferred username is not returned from the IdToken.");
        return MISSING_FROM_THE_TOKEN_RESPONSE;
    }
}

