/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.cache.AccountDeletionRecord;
import com.microsoft.identity.common.internal.cache.BrokerApplicationMetadata;
import com.microsoft.identity.common.internal.cache.CacheKeyValueDelegate;
import com.microsoft.identity.common.internal.cache.CacheRecord;
import com.microsoft.identity.common.internal.cache.IBrokerApplicationMetadataCache;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.cache.MicrosoftFamilyOAuth2TokenCache;
import com.microsoft.identity.common.internal.cache.MicrosoftStsAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.cache.SharedPreferencesAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BrokerOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends MicrosoftTokenResponse, GenericAccount extends MicrosoftAccount, GenericRefreshToken extends MicrosoftRefreshToken>
extends OAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse> {
    private static final String TAG = BrokerOAuth2TokenCache.class.getSimpleName();
    private static final String UNCHECKED = "unchecked";
    private final IBrokerApplicationMetadataCache mApplicationMetadataCache;
    private final MicrosoftFamilyOAuth2TokenCache mFociCache;
    private final int mCallingProcessUid;
    private ProcessUidCacheFactory mDelegate = null;

    public BrokerOAuth2TokenCache(@NonNull Context context, int callingProcessUid, @NonNull IBrokerApplicationMetadataCache applicationMetadataCache) {
        super(context);
        Logger.verbose(TAG + "ctor", "Init::" + TAG);
        this.mCallingProcessUid = callingProcessUid;
        this.mFociCache = BrokerOAuth2TokenCache.initializeFociCache(context);
        this.mApplicationMetadataCache = applicationMetadataCache;
    }

    @VisibleForTesting
    public BrokerOAuth2TokenCache(@NonNull Context context, int callingProcessUid, @NonNull IBrokerApplicationMetadataCache applicationMetadataCache, @NonNull ProcessUidCacheFactory delegate, @NonNull MicrosoftFamilyOAuth2TokenCache fociCache) {
        super(context);
        Logger.verbose(TAG + "ctor", "Init::" + TAG);
        this.mDelegate = delegate;
        this.mApplicationMetadataCache = applicationMetadataCache;
        this.mCallingProcessUid = callingProcessUid;
        this.mFociCache = fociCache;
    }

    @Deprecated
    public ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable String familyId) throws ClientException {
        ICacheRecord result;
        String methodName = ":save (4 args)";
        boolean isFoci = !StringExtensions.isNullOrBlank(familyId);
        Logger.info(TAG + ":save (4 args)", "Saving to FOCI cache? [" + isFoci + "]");
        if (isFoci) {
            result = this.mFociCache.save(accountRecord, idTokenRecord, accessTokenRecord);
        } else {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(idTokenRecord.getClientId(), idTokenRecord.getEnvironment(), this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.warn(TAG + ":save (4 args)", "Existing cache not found. A new one will be created.");
                targetCache = this.initializeProcessUidCache(this.getContext(), this.mCallingProcessUid);
            }
            result = targetCache.save(accountRecord, idTokenRecord, accessTokenRecord);
        }
        this.updateApplicationMetadataCache(result.getAccessToken().getClientId(), result.getAccessToken().getEnvironment(), familyId, this.mCallingProcessUid);
        return result;
    }

    public ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable RefreshTokenRecord refreshTokenRecord, @Nullable String familyId) throws ClientException {
        ICacheRecord result;
        String methodName = ":save (5 args)";
        boolean isFoci = !StringExtensions.isNullOrBlank(familyId);
        Logger.info(TAG + ":save (5 args)", "Saving to FOCI cache? [" + isFoci + "]");
        if (isFoci) {
            result = this.mFociCache.save(accountRecord, idTokenRecord, accessTokenRecord, refreshTokenRecord);
        } else {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(idTokenRecord.getClientId(), idTokenRecord.getEnvironment(), this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.warn(TAG + ":save (5 args)", "Existing cache not found. A new one will be created.");
                targetCache = this.initializeProcessUidCache(this.getContext(), this.mCallingProcessUid);
            }
            result = targetCache.save(accountRecord, idTokenRecord, accessTokenRecord, refreshTokenRecord);
        }
        this.updateApplicationMetadataCache(result.getAccessToken().getClientId(), result.getAccessToken().getEnvironment(), familyId, this.mCallingProcessUid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable String familyId, @NonNull AbstractAuthenticationScheme authScheme) throws ClientException {
        BrokerOAuth2TokenCache brokerOAuth2TokenCache = this;
        synchronized (brokerOAuth2TokenCache) {
            ICacheRecord cacheRecord = this.save(accountRecord, idTokenRecord, accessTokenRecord, familyId);
            return this.loadAggregatedAccountData(authScheme, cacheRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable RefreshTokenRecord refreshTokenRecord, @Nullable String familyId, @NonNull AbstractAuthenticationScheme authScheme) throws ClientException {
        BrokerOAuth2TokenCache brokerOAuth2TokenCache = this;
        synchronized (brokerOAuth2TokenCache) {
            ICacheRecord cacheRecord = this.save(accountRecord, idTokenRecord, accessTokenRecord, refreshTokenRecord, familyId);
            return this.loadAggregatedAccountData(authScheme, cacheRecord);
        }
    }

    private List<ICacheRecord> loadAggregatedAccountData(@NonNull AbstractAuthenticationScheme authScheme, @NonNull ICacheRecord cacheRecord) {
        String clientId = cacheRecord.getAccessToken().getClientId();
        String target = cacheRecord.getAccessToken().getTarget();
        String environment = cacheRecord.getAccessToken().getEnvironment();
        MsalOAuth2TokenCache cache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
        return cache.loadWithAggregatedAccountData(clientId, target, cacheRecord.getAccount(), authScheme);
    }

    @Override
    public ICacheRecord save(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        MsalOAuth2TokenCache targetCache;
        boolean isFoci;
        String methodName = ":save";
        boolean bl = isFoci = !StringExtensions.isNullOrBlank(((MicrosoftTokenResponse)response).getFamilyId());
        if (isFoci) {
            Logger.verbose(TAG + ":save", "Received FOCI value: [" + ((MicrosoftTokenResponse)response).getFamilyId() + "]");
        }
        Logger.info(TAG + ":save", "Saving to FOCI cache? [" + isFoci + "]");
        if (isFoci) {
            targetCache = this.mFociCache;
        } else {
            String environment = ((OAuth2Strategy)oAuth2Strategy).getIssuerCacheIdentifier(request);
            targetCache = this.getTokenCacheForClient(((AuthorizationRequest)request).getClientId(), environment, this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.warn(TAG + ":save", "Existing cache not found. A new one will be created.");
                targetCache = this.initializeProcessUidCache(this.getContext(), this.mCallingProcessUid);
            }
        }
        ICacheRecord result = ((OAuth2TokenCache)targetCache).save(oAuth2Strategy, request, response);
        this.updateApplicationMetadataCache(result.getRefreshToken().getClientId(), result.getRefreshToken().getEnvironment(), result.getRefreshToken().getFamilyId(), this.mCallingProcessUid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        BrokerOAuth2TokenCache brokerOAuth2TokenCache = this;
        synchronized (brokerOAuth2TokenCache) {
            MsalOAuth2TokenCache targetCache;
            String methodName = ":saveAndLoadAggregatedAccountData";
            boolean isFoci = !StringExtensions.isNullOrBlank(((MicrosoftTokenResponse)response).getFamilyId());
            Logger.info(TAG + ":saveAndLoadAggregatedAccountData", "Saving to FOCI cache? [" + isFoci + "]");
            if (isFoci) {
                targetCache = this.mFociCache;
            } else {
                targetCache = this.getTokenCacheForClient(((AuthorizationRequest)request).getClientId(), ((OAuth2Strategy)oAuth2Strategy).getIssuerCacheIdentifier(request), this.mCallingProcessUid);
                if (null == targetCache) {
                    Logger.warn(TAG + ":saveAndLoadAggregatedAccountData", "Existing cache not found. A new one will be created.");
                    targetCache = this.initializeProcessUidCache(this.getContext(), this.mCallingProcessUid);
                }
            }
            List<ICacheRecord> result = ((OAuth2TokenCache)targetCache).saveAndLoadAggregatedAccountData(oAuth2Strategy, request, response);
            ICacheRecord justSavedRecord = result.get(0);
            this.updateApplicationMetadataCache(justSavedRecord.getRefreshToken().getClientId(), justSavedRecord.getRefreshToken().getEnvironment(), justSavedRecord.getRefreshToken().getFamilyId(), this.mCallingProcessUid);
            return result;
        }
    }

    private void updateApplicationMetadataCache(@NonNull String clientId, @NonNull String environment, @Nullable String familyId, int callingProcessUid) {
        String methodName = ":updateApplicationMetadataCache";
        BrokerApplicationMetadata applicationMetadata = new BrokerApplicationMetadata();
        applicationMetadata.setClientId(clientId);
        applicationMetadata.setEnvironment(environment);
        applicationMetadata.setFoci(familyId);
        applicationMetadata.setUid(callingProcessUid);
        Logger.verbose(TAG + ":updateApplicationMetadataCache", "Adding cache entry for clientId: [" + clientId + "]");
        boolean success = this.mApplicationMetadataCache.insert(applicationMetadata);
        Logger.info(TAG + ":updateApplicationMetadataCache", "Cache updated successfully? [" + success + "]");
    }

    @Override
    public ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    @Override
    public ICacheRecord load(@NonNull String clientId, @Nullable String target, @NonNull AccountRecord account, @NonNull AbstractAuthenticationScheme authScheme) {
        MsalOAuth2TokenCache targetCache;
        String methodName = ":load";
        Logger.verbose(TAG + ":load", "Performing lookup in app-specific cache.");
        BrokerApplicationMetadata appMetadata = this.mApplicationMetadataCache.getMetadata(clientId, account.getEnvironment(), this.mCallingProcessUid);
        boolean isKnownFoci = false;
        if (null != appMetadata) {
            isKnownFoci = null != appMetadata.getFoci();
            Logger.info(TAG + ":load", "App is known foci? " + isKnownFoci);
        }
        boolean shouldUseFociCache = null == (targetCache = this.getTokenCacheForClient(clientId, account.getEnvironment(), this.mCallingProcessUid)) || isKnownFoci;
        Logger.info(TAG + ":load", "Loading from FOCI cache? [" + shouldUseFociCache + "]");
        ICacheRecord resultRecord = shouldUseFociCache ? this.mFociCache.loadByFamilyId(clientId, target, account, authScheme) : ((OAuth2TokenCache)targetCache).load(clientId, target, account, authScheme);
        boolean resultFound = null != resultRecord.getRefreshToken();
        Logger.verbose(TAG + ":load", "Result found? [" + resultFound + "]");
        return resultRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> loadWithAggregatedAccountData(@NonNull String clientId, @Nullable String target, @NonNull AccountRecord account, @NonNull AbstractAuthenticationScheme authScheme) {
        BrokerOAuth2TokenCache brokerOAuth2TokenCache = this;
        synchronized (brokerOAuth2TokenCache) {
            List<Object> resultRecords;
            MsalOAuth2TokenCache targetCache;
            String methodName = ":loadWithAggregatedAccountData";
            BrokerApplicationMetadata appMetadata = this.mApplicationMetadataCache.getMetadata(clientId, account.getEnvironment(), this.mCallingProcessUid);
            boolean isKnownFoci = false;
            if (null != appMetadata) {
                isKnownFoci = null != appMetadata.getFoci();
                Logger.info(TAG + ":loadWithAggregatedAccountData", "App is known foci? " + isKnownFoci);
            }
            boolean appIsUnknownUseFociAsFallback = null == (targetCache = this.getTokenCacheForClient(clientId, account.getEnvironment(), this.mCallingProcessUid));
            Logger.info(TAG + ":loadWithAggregatedAccountData", "Loading from FOCI cache? [" + (isKnownFoci || appIsUnknownUseFociAsFallback) + "]");
            if (appIsUnknownUseFociAsFallback) {
                resultRecords = new ArrayList<ICacheRecord>();
                resultRecords.add(this.mFociCache.loadByFamilyId(clientId, target, account, authScheme));
            } else {
                resultRecords = isKnownFoci ? this.mFociCache.loadByFamilyIdWithAggregatedAccountData(clientId, target, account, authScheme) : ((OAuth2TokenCache)targetCache).loadWithAggregatedAccountData(clientId, target, account, authScheme);
            }
            boolean resultFound = !resultRecords.isEmpty() && null != ((ICacheRecord)resultRecords.get(0)).getRefreshToken();
            Logger.verbose(TAG + ":loadWithAggregatedAccountData", "Result found? [" + resultFound + "]");
            return resultRecords;
        }
    }

    @Override
    public boolean removeCredential(@NonNull Credential credential) {
        String methodName = ":removeCredential";
        MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(credential.getClientId(), credential.getEnvironment(), this.mCallingProcessUid);
        boolean removed = false;
        if (null != targetCache) {
            removed = ((OAuth2TokenCache)targetCache).removeCredential(credential);
        } else {
            Logger.warn(TAG + ":removeCredential", "Could not remove credential. Cache not found.");
        }
        Logger.verbose(TAG + ":removeCredential", "Credential removed? [" + removed + "]");
        return removed;
    }

    @Override
    @Nullable
    public AccountRecord getAccount(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId, @Nullable String realm) {
        String methodName = ":getAccount";
        MsalOAuth2TokenCache targetCache = null;
        AccountRecord result = null;
        if (null != environment) {
            targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":getAccount", "Target cache was null. Using FOCI cache.");
                targetCache = this.mFociCache;
            }
            result = ((OAuth2TokenCache)targetCache).getAccount(environment, clientId, homeAccountId, realm);
        } else {
            List<OAuth2TokenCache> clientIdTokenCaches = this.getTokenCachesForClientId(clientId);
            Iterator<OAuth2TokenCache> cacheIterator = clientIdTokenCaches.iterator();
            while (null == result && cacheIterator.hasNext()) {
                result = cacheIterator.next().getAccount(environment, clientId, homeAccountId, realm);
            }
        }
        return result;
    }

    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        List<ICacheRecord> result;
        String methodName = ":getAccountsWithAggregatedAccountData";
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":getAccountsWithAggregatedAccountData", "Falling back to FoCI cache...");
                targetCache = this.mFociCache;
            }
            List<ICacheRecord> resultByAggregatedAccountData = ((OAuth2TokenCache)targetCache).getAccountsWithAggregatedAccountData(environment, clientId, homeAccountId);
            result = resultByAggregatedAccountData;
        } else {
            List<OAuth2TokenCache> caches = this.getTokenCachesForClientId(clientId);
            result = new ArrayList<ICacheRecord>();
            for (OAuth2TokenCache cache : caches) {
                List<ICacheRecord> accountsWithAggregatedAccountData = cache.getAccountsWithAggregatedAccountData(environment, clientId, homeAccountId);
                result.addAll(accountsWithAggregatedAccountData);
            }
        }
        return result;
    }

    private List<OAuth2TokenCache> getTokenCachesForClientId(@NonNull String clientId) {
        List allMetadata = this.mApplicationMetadataCache.getAll();
        ArrayList<OAuth2TokenCache> result = new ArrayList<OAuth2TokenCache>();
        boolean containsFoci = false;
        boolean processUidCacheInitialized = false;
        for (BrokerApplicationMetadata metadata : allMetadata) {
            MsalOAuth2TokenCache candidateCache;
            if (!clientId.equals(metadata.getClientId())) continue;
            if (null != metadata.getFoci() && !containsFoci) {
                result.add(this.mFociCache);
                containsFoci = true;
                continue;
            }
            if (processUidCacheInitialized || null == (candidateCache = this.initializeProcessUidCache(this.getContext(), this.mCallingProcessUid))) continue;
            result.add(candidateCache);
            processUidCacheInitialized = true;
        }
        return result;
    }

    @Override
    @Nullable
    public AccountRecord getAccountByLocalAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String localAccountId) {
        String methodName = ":getAccountByLocalAccountId";
        Logger.verbose(TAG + ":getAccountByLocalAccountId", "Loading account by local account id.");
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            Logger.info(TAG + ":getAccountByLocalAccountId", "Loading from FOCI cache? [" + (targetCache == null) + "]");
            if (null != targetCache) {
                return ((OAuth2TokenCache)targetCache).getAccountByLocalAccountId(environment, clientId, localAccountId);
            }
            return this.mFociCache.getAccountByLocalAccountId(environment, clientId, localAccountId);
        }
        AccountRecord result = null;
        List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
        Iterator<OAuth2TokenCache> cacheIterator = cachesToInspect.iterator();
        while (null == result && cacheIterator.hasNext()) {
            result = cacheIterator.next().getAccountByLocalAccountId(environment, clientId, localAccountId);
        }
        return result;
    }

    @Override
    @Nullable
    public ICacheRecord getAccountWithAggregatedAccountDataByLocalAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String localAccountId) {
        String methodName = ":getAccountWithAggregatedAccountDataByLocalAccountId";
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            Logger.info(TAG + ":getAccountWithAggregatedAccountDataByLocalAccountId", "Loading from FOCI cache? [" + (targetCache == null) + "]");
            if (null != targetCache) {
                return ((OAuth2TokenCache)targetCache).getAccountWithAggregatedAccountDataByLocalAccountId(environment, clientId, localAccountId);
            }
            return this.mFociCache.getAccountWithAggregatedAccountDataByLocalAccountId(environment, clientId, localAccountId);
        }
        ICacheRecord result = null;
        List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
        Iterator<OAuth2TokenCache> cacheIterator = cachesToInspect.iterator();
        while (null == result && cacheIterator.hasNext()) {
            result = cacheIterator.next().getAccountWithAggregatedAccountDataByLocalAccountId(environment, clientId, localAccountId);
        }
        return result;
    }

    @Override
    public List<AccountRecord> getAccounts(@Nullable String environment, @NonNull String clientId) {
        String methodName = ":getAccounts (2 param)";
        ArrayList<AccountRecord> result = new ArrayList<AccountRecord>();
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            if (null != targetCache) {
                result.addAll(((OAuth2TokenCache)targetCache).getAccounts(environment, clientId));
            } else {
                Logger.warn(TAG + ":getAccounts (2 param)", "No caches to inspect.");
            }
        } else {
            List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
            for (OAuth2TokenCache cache : cachesToInspect) {
                result.addAll(cache.getAccounts(environment, clientId));
            }
            Logger.verbose(TAG + ":getAccounts (2 param)", "Found [" + result.size() + "] accounts.");
        }
        return result;
    }

    @Override
    public List<AccountRecord> getAllTenantAccountsForAccountByClientId(@NonNull String clientId, @NonNull AccountRecord accountRecord) {
        MsalOAuth2TokenCache cache = this.getTokenCacheForClient(clientId, accountRecord.getEnvironment(), this.mCallingProcessUid);
        List<AccountRecord> tenantAccountsForAccountByClientId = ((OAuth2TokenCache)cache).getAllTenantAccountsForAccountByClientId(clientId, accountRecord);
        return tenantAccountsForAccountByClientId;
    }

    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(@Nullable String environment, @NonNull String clientId) {
        List<ICacheRecord> result;
        String methodName = ":getAccountsWithAggregatedAccountData";
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":getAccountsWithAggregatedAccountData", "Falling back to FoCI cache...");
                targetCache = this.mFociCache;
            }
            List<ICacheRecord> targetCacheAccountsWithAggregatedAccountData = ((OAuth2TokenCache)targetCache).getAccountsWithAggregatedAccountData(environment, clientId);
            result = targetCacheAccountsWithAggregatedAccountData;
        } else {
            List<OAuth2TokenCache> caches = this.getTokenCachesForClientId(clientId);
            result = new ArrayList<ICacheRecord>();
            for (OAuth2TokenCache cache : caches) {
                List<ICacheRecord> cacheAccountsWithAggregatedAccountData = cache.getAccountsWithAggregatedAccountData(environment, clientId);
                result.addAll(cacheAccountsWithAggregatedAccountData);
            }
        }
        return result;
    }

    @Override
    public List<IdTokenRecord> getIdTokensForAccountRecord(@NonNull String clientId, @NonNull AccountRecord accountRecord) {
        List<IdTokenRecord> cacheIdTokensForAccountRecord;
        String accountEnv = accountRecord.getEnvironment();
        if (null == clientId) {
            throw new UnsupportedOperationException("Aggregating IdTokens across ClientIds is not supported - do you have a feature request?");
        }
        MsalOAuth2TokenCache cache = this.getTokenCacheForClient(clientId, accountEnv, this.mCallingProcessUid);
        List<IdTokenRecord> result = cacheIdTokensForAccountRecord = ((OAuth2TokenCache)cache).getIdTokensForAccountRecord(clientId, accountRecord);
        return result;
    }

    public List<AccountRecord> getAccounts() {
        String methodName = ":getAccounts";
        HashSet<AccountRecord> allAccounts = new HashSet<AccountRecord>();
        List allMetadata = this.mApplicationMetadataCache.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            MsalOAuth2TokenCache candidateCache = this.getTokenCacheForClient(metadata);
            if (null == candidateCache) continue;
            allAccounts.addAll(candidateCache.getAccountCredentialCache().getAccounts());
        }
        allAccounts.addAll(this.mFociCache.getAccountCredentialCache().getAccounts());
        ArrayList<AccountRecord> allAccountsResult = new ArrayList<AccountRecord>(allAccounts);
        Logger.verbose(TAG + ":getAccounts", "Found [" + allAccountsResult.size() + "] accounts.");
        return allAccountsResult;
    }

    public AccountDeletionRecord removeAccountFromDevice(@NonNull AccountRecord accountRecord) {
        String methodName = ":removeAccountFromDevice";
        if (null == accountRecord) {
            Logger.error(TAG + ":removeAccountFromDevice", "Illegal arg. Cannot delete a null AccountRecord!", null);
            throw new IllegalArgumentException("AccountRecord may not be null.");
        }
        Set<String> allClientIds = this.mApplicationMetadataCache.getAllClientIds();
        Logger.info(TAG + ":removeAccountFromDevice", "Found [" + allClientIds.size() + "] client ids.");
        ArrayList<AccountDeletionRecord> deletionRecordList = new ArrayList<AccountDeletionRecord>();
        for (String clientId : allClientIds) {
            deletionRecordList.add(this.removeAccountInternal(accountRecord.getEnvironment(), clientId, accountRecord.getHomeAccountId(), null, true));
        }
        ArrayList<AccountRecord> deletedAccountRecords = new ArrayList<AccountRecord>();
        for (AccountDeletionRecord accountDeletionRecord : deletionRecordList) {
            deletedAccountRecords.addAll(accountDeletionRecord);
        }
        Logger.info(TAG + ":removeAccountFromDevice", "Deleted [" + deletedAccountRecords.size() + "] AccountRecords.");
        return new AccountDeletionRecord(deletedAccountRecords);
    }

    @Override
    public AccountDeletionRecord removeAccount(@Nullable String environment, @Nullable String clientId, @Nullable String homeAccountId, @Nullable String realm) {
        return this.removeAccountInternal(environment, clientId, homeAccountId, realm, false);
    }

    @Override
    public AccountDeletionRecord removeAccount(String environment, String clientId, String homeAccountId, String realm, CredentialType ... typesToRemove) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    @Override
    public void clearAll() {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public boolean isClientIdKnownToCache(@NonNull String clientId) {
        return this.getAllClientIds().contains(clientId);
    }

    public List<ICacheRecord> getFociCacheRecords() {
        String methodName = ":getFociCacheRecords";
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        List<BrokerApplicationMetadata> allFociApplicationMetadata = this.mApplicationMetadataCache.getAllFociApplicationMetadata();
        for (BrokerApplicationMetadata fociAppMetadata : allFociApplicationMetadata) {
            List<AccountRecord> accounts = this.mFociCache.getAccounts(fociAppMetadata.getEnvironment(), fociAppMetadata.getClientId());
            for (AccountRecord account : accounts) {
                String homeAccountId = account.getHomeAccountId();
                String environment = account.getEnvironment();
                String clientId = fociAppMetadata.getClientId();
                String realm = account.getRealm();
                List<Credential> refreshTokens = this.mFociCache.getAccountCredentialCache().getCredentialsFilteredBy(homeAccountId, environment, CredentialType.RefreshToken, clientId, null, null, null);
                List<Credential> v1IdTokens = this.mFociCache.getAccountCredentialCache().getCredentialsFilteredBy(homeAccountId, environment, CredentialType.V1IdToken, clientId, realm, null, null);
                List<Credential> idTokens = this.mFociCache.getAccountCredentialCache().getCredentialsFilteredBy(homeAccountId, environment, CredentialType.IdToken, clientId, realm, null, null);
                if (refreshTokens.isEmpty()) continue;
                CacheRecord.CacheRecordBuilder cacheRecord = CacheRecord.builder();
                cacheRecord.account(account);
                cacheRecord.refreshToken((RefreshTokenRecord)refreshTokens.get(0));
                if (!v1IdTokens.isEmpty()) {
                    Logger.verbose(TAG + ":getFociCacheRecords", "Found [" + v1IdTokens.size() + "] V1IdTokens");
                    cacheRecord.v1IdToken((IdTokenRecord)v1IdTokens.get(0));
                } else {
                    Logger.warn(TAG + ":getFociCacheRecords", "No V1IdTokens exist for this account.");
                }
                if (!idTokens.isEmpty()) {
                    Logger.verbose(TAG + ":getFociCacheRecords", "Found [" + idTokens.size() + "] IdTokens");
                    cacheRecord.idToken((IdTokenRecord)idTokens.get(0));
                } else {
                    Logger.warn(TAG + ":getFociCacheRecords", "No IdTokens exist for this account.");
                }
                result.add(cacheRecord.build());
            }
        }
        return result;
    }

    private AccountDeletionRecord removeAccountInternal(@Nullable String environment, @Nullable String clientId, @Nullable String homeAccountId, @Nullable String realm, boolean deviceWide) {
        String methodName = ":removeAccountInternal";
        List allMetadata = this.mApplicationMetadataCache.getAll();
        ArrayList<AccountDeletionRecord> deletionRecordList = new ArrayList<AccountDeletionRecord>();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            MsalOAuth2TokenCache candidateCache = this.getTokenCacheForClient(metadata.getClientId(), metadata.getEnvironment(), deviceWide ? metadata.getUid() : this.mCallingProcessUid);
            if (null == candidateCache) continue;
            deletionRecordList.add(((OAuth2TokenCache)candidateCache).removeAccount(environment, clientId, homeAccountId, realm));
        }
        ArrayList<AccountRecord> deletedAccountRecords = new ArrayList<AccountRecord>();
        for (AccountDeletionRecord accountDeletionRecord : deletionRecordList) {
            deletedAccountRecords.addAll(accountDeletionRecord);
        }
        Logger.info(TAG + ":removeAccountInternal", "Deleted [" + deletedAccountRecords.size() + "] AccountRecords.");
        return new AccountDeletionRecord(deletedAccountRecords);
    }

    @Override
    protected Set<String> getAllClientIds() {
        return this.mApplicationMetadataCache.getAllClientIds();
    }

    @Override
    public AccountRecord getAccountByHomeAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        String methodName = "getAccountByHomeAccountId";
        Logger.verbose(TAG + "getAccountByHomeAccountId", "Loading account by home account id.");
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            Logger.info(TAG + "getAccountByHomeAccountId", "Loading from FOCI cache? [" + (targetCache == null) + "]");
            if (null != targetCache) {
                return ((OAuth2TokenCache)targetCache).getAccountByHomeAccountId(environment, clientId, homeAccountId);
            }
            return this.mFociCache.getAccountByHomeAccountId(environment, clientId, homeAccountId);
        }
        AccountRecord result = null;
        List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
        Iterator<OAuth2TokenCache> cacheIterator = cachesToInspect.iterator();
        while (null == result && cacheIterator.hasNext()) {
            result = cacheIterator.next().getAccountByHomeAccountId(environment, clientId, homeAccountId);
        }
        return result;
    }

    private MsalOAuth2TokenCache initializeProcessUidCache(@NonNull Context context, int bindingProcessUid) {
        String methodName = ":initializeProcessUidCache";
        Logger.verbose(TAG + ":initializeProcessUidCache", "Initializing uid cache.");
        if (null != this.mDelegate) {
            Logger.warn(TAG + ":initializeProcessUidCache", "Using swapped delegate cache.");
            return this.mDelegate.getTokenCache(context, bindingProcessUid);
        }
        StorageHelper storageHelper = new StorageHelper(context);
        SharedPreferencesFileManager sharedPreferencesFileManager = SharedPreferencesFileManager.getSharedPreferences(context, SharedPreferencesAccountCredentialCache.getBrokerUidSequesteredFilename(bindingProcessUid), -1, storageHelper);
        return BrokerOAuth2TokenCache.getTokenCache(context, sharedPreferencesFileManager, false);
    }

    private static MicrosoftFamilyOAuth2TokenCache initializeFociCache(@NonNull Context context) {
        String methodName = ":initializeFociCache";
        Logger.verbose(TAG + ":initializeFociCache", "Initializing foci cache");
        StorageHelper storageHelper = new StorageHelper(context);
        SharedPreferencesFileManager sharedPreferencesFileManager = SharedPreferencesFileManager.getSharedPreferences(context, "com.microsoft.identity.client.account_credential_cache.foci-1", -1, storageHelper);
        return (MicrosoftFamilyOAuth2TokenCache)BrokerOAuth2TokenCache.getTokenCache(context, sharedPreferencesFileManager, true);
    }

    private static <T extends MsalOAuth2TokenCache> T getTokenCache(@NonNull Context context, @NonNull ISharedPreferencesFileManager spfm, boolean isFoci) {
        CacheKeyValueDelegate cacheKeyValueDelegate = new CacheKeyValueDelegate();
        SharedPreferencesAccountCredentialCache accountCredentialCache = new SharedPreferencesAccountCredentialCache(cacheKeyValueDelegate, spfm);
        MicrosoftStsAccountCredentialAdapter accountCredentialAdapter = new MicrosoftStsAccountCredentialAdapter();
        return (T)(isFoci ? new MicrosoftFamilyOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken>(context, accountCredentialCache, accountCredentialAdapter) : new MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken>(context, accountCredentialCache, accountCredentialAdapter));
    }

    @Nullable
    private MsalOAuth2TokenCache getTokenCacheForClient(@Nullable BrokerApplicationMetadata metadata) {
        String methodName = ":getTokenCacheForClient(bam)";
        MsalOAuth2TokenCache targetCache = null;
        if (null != metadata) {
            boolean isFoci = null != metadata.getFoci();
            Logger.verbose(TAG + ":getTokenCacheForClient(bam)", "is Foci? [" + isFoci + "]");
            targetCache = isFoci ? this.mFociCache : this.initializeProcessUidCache(this.getContext(), metadata.getUid());
        }
        if (null == targetCache) {
            Logger.warn(TAG + ":getTokenCacheForClient(bam)", "Could not locate a cache for this app.");
        }
        return targetCache;
    }

    @Nullable
    private MsalOAuth2TokenCache getTokenCacheForClient(@NonNull String clientId, @NonNull String environment, int callingProcessUid) {
        String methodName = ":getTokenCacheForClient(id, env, uid)";
        BrokerApplicationMetadata metadata = this.mApplicationMetadataCache.getMetadata(clientId, environment, callingProcessUid);
        Logger.info(TAG + ":getTokenCacheForClient(id, env, uid)", "Found metadata? " + (null != metadata));
        return this.getTokenCacheForClient(metadata);
    }

    public void setSingleSignOnState(@NonNull String uidStr, @NonNull GenericAccount account, @NonNull GenericRefreshToken refreshToken) {
        MsalOAuth2TokenCache targetCache;
        String methodName = ":setSingleSignOnState";
        boolean isFrt = ((MicrosoftRefreshToken)refreshToken).getIsFamilyRefreshToken();
        int uid = Integer.valueOf(uidStr);
        if (isFrt) {
            Logger.verbose(TAG + ":setSingleSignOnState", "Saving tokens to foci cache.");
            targetCache = this.mFociCache;
        } else {
            targetCache = this.getTokenCacheForClient(((MicrosoftRefreshToken)refreshToken).getClientId(), ((MicrosoftRefreshToken)refreshToken).getEnvironment(), this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":setSingleSignOnState", "Existing cache could not be found. Creating a new one...");
                targetCache = this.initializeProcessUidCache(this.getContext(), uid);
            }
        }
        try {
            this.targetCacheSetSingleSignOnState(account, refreshToken, targetCache);
            this.updateApplicationMetadataCache(((MicrosoftRefreshToken)refreshToken).getClientId(), ((MicrosoftRefreshToken)refreshToken).getEnvironment(), ((MicrosoftRefreshToken)refreshToken).getFamilyId(), uid);
        }
        catch (ClientException e) {
            Logger.warn(TAG + ":setSingleSignOnState", "Failed to save account/refresh token. Skipping.");
        }
    }

    private void targetCacheSetSingleSignOnState(@NonNull GenericAccount account, @NonNull GenericRefreshToken refreshToken, MsalOAuth2TokenCache targetCache) throws ClientException {
        targetCache.setSingleSignOnState(account, refreshToken);
    }

    @VisibleForTesting
    public static interface ProcessUidCacheFactory {
        public MsalOAuth2TokenCache getTokenCache(Context var1, int var2);
    }
}

