/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.result.ResultFuture;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.ui.browser.BrowserDescriptor;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.ui.browser.CustomTabsManager;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;
import java.util.concurrent.Future;

public class BrowserAuthorizationStrategy<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest>
extends AuthorizationStrategy<GenericOAuth2Strategy, GenericAuthorizationRequest> {
    private static final String TAG = BrowserAuthorizationStrategy.class.getSimpleName();
    private CustomTabsManager mCustomTabManager;
    private ResultFuture<AuthorizationResult> mAuthorizationResultFuture;
    private List<BrowserDescriptor> mBrowserSafeList;
    private boolean mDisposed;
    private GenericOAuth2Strategy mOAuth2Strategy;
    private GenericAuthorizationRequest mAuthorizationRequest;
    private boolean mIsRequestFromBroker;

    public BrowserAuthorizationStrategy(@NonNull Context applicationContext, @NonNull Activity activity, @Nullable Fragment fragment, boolean isRequestFromBroker) {
        super(applicationContext, activity, fragment);
        this.mIsRequestFromBroker = isRequestFromBroker;
    }

    public void setBrowserSafeList(List<BrowserDescriptor> browserSafeList) {
        this.mBrowserSafeList = browserSafeList;
    }

    @Override
    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest authorizationRequest, GenericOAuth2Strategy oAuth2Strategy) throws ClientException {
        Intent authIntent;
        String methodName = ":requestAuthorization";
        this.checkNotDisposed();
        Context context = this.getApplicationContext();
        this.mOAuth2Strategy = oAuth2Strategy;
        this.mAuthorizationRequest = authorizationRequest;
        this.mAuthorizationResultFuture = new ResultFuture();
        Browser browser = BrowserSelector.select(context, this.mBrowserSafeList);
        if (browser.isCustomTabsServiceSupported()) {
            Logger.info(TAG + ":requestAuthorization", "CustomTabsService is supported.");
            this.mCustomTabManager = new CustomTabsManager(context);
            authIntent = !this.mCustomTabManager.bind(context, browser.getPackageName()) ? new Intent("android.intent.action.VIEW") : this.mCustomTabManager.getCustomTabsIntent().intent;
        } else {
            Logger.warn(TAG + ":requestAuthorization", "CustomTabsService is NOT supported");
            authIntent = new Intent("android.intent.action.VIEW");
        }
        authIntent.setPackage(browser.getPackageName());
        Uri requestUrl = ((AuthorizationRequest)authorizationRequest).getAuthorizationRequestAsHttpRequest();
        authIntent.setData(requestUrl);
        Intent intent = this.buildAuthorizationActivityStartIntent(authIntent, requestUrl);
        if (this.mIsRequestFromBroker) {
            intent.setFlags(0x10008000);
        } else {
            intent.setFlags(0x10000000);
        }
        this.launchIntent(intent);
        return this.mAuthorizationResultFuture;
    }

    private Intent buildAuthorizationActivityStartIntent(Intent authIntent, Uri requestUrl) {
        return AuthorizationActivity.createStartIntent(this.getApplicationContext(), authIntent, requestUrl.toString(), ((AuthorizationRequest)this.mAuthorizationRequest).getRedirectUri(), ((AuthorizationRequest)this.mAuthorizationRequest).getRequestHeaders(), AuthorizationAgent.BROWSER, true, true);
    }

    private void checkNotDisposed() {
        if (this.mDisposed) {
            throw new IllegalStateException("Service has been disposed and rendered inoperable");
        }
    }

    @Override
    public void completeAuthorization(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            this.dispose();
            Object result = ((OAuth2Strategy)this.mOAuth2Strategy).getAuthorizationResultFactory().createAuthorizationResult(resultCode, data, this.mAuthorizationRequest);
            this.mAuthorizationResultFuture.setResult((AuthorizationResult)result);
        } else {
            Logger.warnPII(TAG, "Unknown request code " + requestCode);
        }
    }

    public void dispose() {
        if (this.mDisposed) {
            return;
        }
        if (this.mCustomTabManager != null) {
            this.mCustomTabManager.unbind();
        }
        this.mDisposed = true;
    }
}

