/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.content.pm.PackageInfoCompat;
import com.microsoft.identity.common.internal.telemetry.Properties;
import com.microsoft.identity.common.internal.telemetry.TelemetryPropertiesCache;
import com.microsoft.identity.common.logging.Logger;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class TelemetryContext
extends Properties {
    private static final String TAG = TelemetryContext.class.getSimpleName();
    private TelemetryPropertiesCache mTelemetryPropsCache;

    private TelemetryContext(ConcurrentHashMap<String, String> delegate, @NonNull Context context) {
        super(delegate);
        this.mTelemetryPropsCache = new TelemetryPropertiesCache(context);
    }

    static synchronized TelemetryContext create(@NonNull Context context) {
        TelemetryContext telemetryContext = new TelemetryContext(new ConcurrentHashMap<String, String>(), context);
        telemetryContext.addApplicationInfo(context);
        telemetryContext.addDeviceInfo(context);
        telemetryContext.addOsInfo();
        telemetryContext.put("Microsoft.MSAL.time_zone", TimeZone.getDefault().getID());
        return telemetryContext;
    }

    void addApplicationInfo(@NonNull Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            this.put("Microsoft.MSAL.application_name", packageInfo.applicationInfo.packageName);
            this.put("Microsoft.MSAL.application_version", packageInfo.versionName);
            long versionCode = PackageInfoCompat.getLongVersionCode((PackageInfo)packageInfo);
            this.put("Microsoft.MSAL.application_build", String.valueOf(versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn(TAG, "Unable to find the app's package name from PackageManager.");
        }
    }

    void addDeviceInfo(@NonNull Context context) {
        this.put("Microsoft.MSAL.device_manufacturer", Build.MANUFACTURER);
        this.put("Microsoft.MSAL.device_model", Build.MODEL);
        this.put("Microsoft.MSAL.device_name", Build.DEVICE);
        this.put("Microsoft.MSAL.device_id", this.mTelemetryPropsCache.getOrCreateRandomStableDeviceId());
    }

    void addOsInfo() {
        this.put("Microsoft.MSAL.os_name", "android");
        this.put("Microsoft.MSAL.os_version", Build.VERSION.RELEASE);
        if (Build.VERSION.SDK_INT >= 23) {
            this.put("Microsoft.MSAL.security_patch", Build.VERSION.SECURITY_PATCH);
        }
    }

    public void isNetworkDisabledFromOptimizations(boolean isDozed) {
        this.put("Microsoft.MSAL.power_optimization", String.valueOf(isDozed));
    }

    public void isNetworkConnected(boolean isConnected) {
        this.put("Microsoft.MSAL.network_connection", String.valueOf(isConnected));
    }
}

