/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonSyntaxException;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.DeviceRegistrationRequiredException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.exception.UiRequiredException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.telemetry.CliTelemInfo;
import com.microsoft.identity.common.internal.util.HeaderSerializationUtil;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;

public class ExceptionAdapter {
    private static final String TAG = ExceptionAdapter.class.getSimpleName();

    @Nullable
    public static BaseException exceptionFromAcquireTokenResult(AcquireTokenResult result) {
        String methodName = ":exceptionFromAcquireTokenResult";
        AuthorizationResult authorizationResult = result.getAuthorizationResult();
        if (null != authorizationResult) {
            Object authorizationErrorResponse = authorizationResult.getAuthorizationErrorResponse();
            if (!authorizationResult.getSuccess()) {
                switch (result.getAuthorizationResult().getAuthorizationStatus()) {
                    case FAIL: {
                        MicrosoftAuthorizationErrorResponse microsoftAuthorizationErrorResponse;
                        if (authorizationErrorResponse instanceof MicrosoftAuthorizationErrorResponse && (microsoftAuthorizationErrorResponse = (MicrosoftAuthorizationErrorResponse)authorizationErrorResponse).getError().equals("device_registration_needed")) {
                            return new DeviceRegistrationRequiredException(microsoftAuthorizationErrorResponse.getError(), microsoftAuthorizationErrorResponse.getErrorDescription(), microsoftAuthorizationErrorResponse.getUserName());
                        }
                        return new ServiceException(((AuthorizationErrorResponse)authorizationErrorResponse).getError(), ((AuthorizationErrorResponse)authorizationErrorResponse).getErrorDescription(), 0, null);
                    }
                    case SDK_CANCEL: {
                        return new ClientException(((AuthorizationErrorResponse)authorizationErrorResponse).getError(), ((AuthorizationErrorResponse)authorizationErrorResponse).getErrorDescription());
                    }
                    case USER_CANCEL: {
                        return new UserCancelException();
                    }
                }
            }
        } else {
            Logger.warn(TAG + ":exceptionFromAcquireTokenResult", "AuthorizationResult was null -- expected for ATS cases.");
        }
        return ExceptionAdapter.exceptionFromTokenResult(result.getTokenResult());
    }

    public static ServiceException exceptionFromTokenResult(TokenResult tokenResult) {
        ServiceException outErr;
        String methodName = ":exceptionFromTokenResult";
        if (tokenResult != null && !tokenResult.getSuccess() && tokenResult.getErrorResponse() != null && !StringUtil.isEmpty(tokenResult.getErrorResponse().getError())) {
            outErr = ExceptionAdapter.getExceptionFromTokenErrorResponse(tokenResult.getErrorResponse());
            ExceptionAdapter.applyCliTelemInfo(tokenResult.getCliTelemInfo(), outErr);
        } else {
            Logger.warn(TAG + ":exceptionFromTokenResult", "Unknown error, Token result is null [" + (tokenResult == null) + "]");
            outErr = new ServiceException("unknown_error", "Request failed, but no error returned back from service.", null);
        }
        return outErr;
    }

    private static boolean shouldBeConvertedToUiRequiredException(String oAuthError) {
        return "invalid_grant".equalsIgnoreCase(oAuthError) || "interaction_required".equalsIgnoreCase(oAuthError);
    }

    public static ServiceException getExceptionFromTokenErrorResponse(@NonNull TokenErrorResponse errorResponse) {
        String methodName = ":getExceptionFromTokenErrorResponse";
        ServiceException outErr = ExceptionAdapter.shouldBeConvertedToUiRequiredException(errorResponse.getError()) ? new UiRequiredException(errorResponse.getError(), errorResponse.getErrorDescription()) : new ServiceException(errorResponse.getError(), errorResponse.getErrorDescription(), null);
        outErr.setOauthSubErrorCode(errorResponse.getSubError());
        try {
            outErr.setHttpResponse(ExceptionAdapter.synthesizeHttpResponse(errorResponse.getStatusCode(), errorResponse.getResponseHeadersJson(), errorResponse.getResponseBody()));
        }
        catch (JSONException e) {
            Logger.warn(TAG + ":getExceptionFromTokenErrorResponse", "Failed to deserialize error data: status, headers, response body.");
        }
        return outErr;
    }

    public static void applyCliTelemInfo(@Nullable CliTelemInfo cliTelemInfo, @NonNull BaseException outErr) {
        if (null != cliTelemInfo) {
            outErr.setSpeRing(cliTelemInfo.getSpeRing());
            outErr.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
            outErr.setCliTelemErrorCode(cliTelemInfo.getServerErrorCode());
            outErr.setCliTelemSubErrorCode(cliTelemInfo.getServerSubErrorCode());
        }
    }

    private static HttpResponse synthesizeHttpResponse(int statusCode, @Nullable String responseHeadersJson, @Nullable String responseBody) {
        String methodName = ":applyHttpErrorResponseData";
        if (null != responseHeadersJson && null != responseBody) {
            try {
                return new HttpResponse(statusCode, responseBody, HeaderSerializationUtil.fromJson(responseHeadersJson));
            }
            catch (JsonSyntaxException e) {
                Logger.warn(TAG + ":applyHttpErrorResponseData", "Failed to deserialize error data: status, headers, response body.");
            }
        }
        return null;
    }

    public static BaseException baseExceptionFromException(Throwable exception) {
        Throwable e = exception;
        if (exception instanceof ExecutionException) {
            e = exception.getCause();
        }
        if (e instanceof IOException) {
            return new ClientException("io_error", "An IO error occurred with message: " + e.getMessage(), e);
        }
        if (e instanceof BaseException) {
            return (BaseException)e;
        }
        return new ClientException("unknown_error", e.getMessage(), e);
    }
}

