/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.commands.BaseCommand;
import com.microsoft.identity.common.internal.commands.InteractiveTokenCommand;
import com.microsoft.identity.common.internal.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.CommandResult;
import com.microsoft.identity.common.internal.controllers.CommandResultCache;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.FinalizableResultFuture;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.util.BiConsumer;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.internal.util.ThreadUtils;
import com.microsoft.identity.common.logging.DiagnosticContext;
import com.microsoft.identity.common.logging.Logger;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CommandDispatcher {
    private static final String TAG = CommandDispatcher.class.getSimpleName();
    private static final int SILENT_REQUEST_THREAD_POOL_SIZE = 5;
    private static final int INTERACTIVE_REQUEST_THREAD_POOL_SIZE = 1;
    private static final ExecutorService sInteractiveExecutor = ThreadUtils.getNamedThreadPoolExecutor(1, 1, -1, 0L, TimeUnit.MINUTES, "interactive");
    private static final ExecutorService sSilentExecutor = ThreadUtils.getNamedThreadPoolExecutor(1, 5, -1, 1L, TimeUnit.MINUTES, "silent");
    private static final Object sLock = new Object();
    private static InteractiveTokenCommand sCommand = null;
    private static final CommandResultCache sCommandResultCache = new CommandResultCache();
    private static final Object mapAccessLock = new Object();
    @GuardedBy(value="mapAccessLock")
    private static ConcurrentMap<BaseCommand, FinalizableResultFuture<CommandResult>> sExecutingCommandMap = new ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>>();

    private static void cleanMap(BaseCommand command) {
        ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>> newMap = new ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>>();
        for (Map.Entry e : sExecutingCommandMap.entrySet()) {
            if (command == e.getKey()) continue;
            newMap.put((BaseCommand)e.getKey(), (FinalizableResultFuture<CommandResult>)e.getValue());
        }
        sExecutingCommandMap = newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    public static int outstandingCommands() {
        Object object = mapAccessLock;
        synchronized (object) {
            return sExecutingCommandMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    public static boolean isCommandOutstanding(BaseCommand c) {
        Object object = mapAccessLock;
        synchronized (object) {
            for (Map.Entry e : sExecutingCommandMap.entrySet()) {
                if (e.getKey() != c) continue;
                System.out.println("Command out there " + c);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    public static void clearState() throws Exception {
        Object object = mapAccessLock;
        synchronized (object) {
            sExecutingCommandMap.clear();
        }
        sSilentExecutor.shutdownNow();
        sInteractiveExecutor.shutdownNow();
        Field f = CommandDispatcher.class.getDeclaredField("sSilentExecutor");
        f.setAccessible(true);
        f.set(null, Executors.newFixedThreadPool(5));
        f.setAccessible(false);
        f = CommandDispatcher.class.getDeclaredField("sInteractiveExecutor");
        f.setAccessible(true);
        f.set(null, Executors.newSingleThreadExecutor());
        f.setAccessible(false);
    }

    public static void submitSilent(@NonNull BaseCommand command) {
        CommandDispatcher.submitSilentReturningFuture(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=2)
    public static FinalizableResultFuture<CommandResult> submitSilentReturningFuture(final @NonNull BaseCommand command) {
        String methodName = ":submitSilent";
        final CommandParameters commandParameters = command.getParameters();
        final String correlationId = CommandDispatcher.initializeDiagnosticContext(commandParameters.getCorrelationId(), commandParameters.getSdkType() == null ? SdkType.UNKNOWN.getProductName() : commandParameters.getSdkType().getProductName(), commandParameters.getSdkVersion());
        commandParameters.setCorrelationId(correlationId);
        CommandDispatcher.logParameters(TAG + ":submitSilent", correlationId, commandParameters, command.getPublicApiId());
        Handler handler = new Handler(Looper.getMainLooper());
        Object object = mapAccessLock;
        synchronized (object) {
            FinalizableResultFuture<CommandResult> finalFuture;
            if (command.isEligibleForCaching()) {
                FinalizableResultFuture<CommandResult> future = (FinalizableResultFuture<CommandResult>)sExecutingCommandMap.get(command);
                if (null == future) {
                    future = new FinalizableResultFuture<CommandResult>();
                    FinalizableResultFuture<CommandResult> putValue = sExecutingCommandMap.putIfAbsent(command, future);
                    if (null != putValue) {
                        putValue.whenComplete(CommandDispatcher.getCommandResultConsumer(command, handler));
                        return putValue;
                    }
                } else {
                    future.whenComplete(CommandDispatcher.getCommandResultConsumer(command, handler));
                    return future;
                }
                future.whenComplete(CommandDispatcher.getCommandResultConsumer(command, handler));
                finalFuture = future;
            } else {
                finalFuture = new FinalizableResultFuture<CommandResult>();
                finalFuture.whenComplete(CommandDispatcher.getCommandResultConsumer(command, handler));
            }
            sSilentExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object commandResult;
                    try {
                        CommandDispatcher.initializeDiagnosticContext(correlationId, commandParameters.getSdkType() == null ? SdkType.UNKNOWN.getProductName() : commandParameters.getSdkType().getProductName(), commandParameters.getSdkVersion());
                        EstsTelemetry.getInstance().initTelemetryForCommand(command);
                        EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                        commandResult = null;
                        if (command.getParameters() instanceof SilentTokenCommandParameters) {
                            EstsTelemetry.getInstance().emitForceRefresh(((SilentTokenCommandParameters)command.getParameters()).isForceRefresh());
                        }
                        if ((commandResult = sCommandResultCache.get(command)) == null) {
                            commandResult = CommandDispatcher.executeCommand(command);
                            CommandDispatcher.cacheCommandResult(command, (CommandResult)commandResult);
                            Logger.info(TAG + ":submitSilent", "Completed silent request as owner for correlation id : **" + correlationId + ", with the status : " + ((CommandResult)commandResult).getStatus().getLogStatus() + " is cacheable : " + command.isEligibleForCaching());
                        } else {
                            Logger.info(TAG + ":submitSilent", "Silent command result returned from cache for correlation id : " + correlationId + " having status : " + ((CommandResult)commandResult).getStatus().getLogStatus());
                            commandResult = new CommandResult(((CommandResult)commandResult).getStatus(), ((CommandResult)commandResult).getResult(), ((CommandResult)commandResult).getCorrelationId());
                        }
                        CommandDispatcher.setCorrelationIdOnResult((CommandResult)commandResult, correlationId);
                        Telemetry.getInstance().flush(correlationId);
                        EstsTelemetry.getInstance().flush(command, (CommandResult)commandResult);
                        finalFuture.setResult(commandResult);
                    }
                    catch (Throwable t) {
                        Logger.info(TAG + ":submitSilent", "Request encountered an exception with correlation id : **" + correlationId);
                        finalFuture.setException(new ExecutionException(t));
                    }
                    finally {
                        commandResult = mapAccessLock;
                        synchronized (commandResult) {
                            FinalizableResultFuture mapFuture;
                            if (command.isEligibleForCaching() && (mapFuture = (FinalizableResultFuture)sExecutingCommandMap.remove(command)) == null) {
                                Logger.error(TAG, "The command in the map has mutated " + command.getClass().getCanonicalName() + " the calling application was " + command.getParameters().getApplicationName(), null);
                                CommandDispatcher.cleanMap(command);
                            }
                            finalFuture.setCleanedUp();
                        }
                        DiagnosticContext.clear();
                    }
                }
            });
            return finalFuture;
        }
    }

    private static void logParameters(@NonNull String tag, @NonNull String correlationId, @NonNull Object parameters, @Nullable String publicApiId) {
        String TAG = tag + ":" + parameters.getClass().getSimpleName();
        Logger.info(TAG, DiagnosticContext.getRequestContext().toJsonString(), "Starting request for correlation id : ##" + correlationId + ", with PublicApiId : " + publicApiId);
        if (Logger.getAllowPii()) {
            Logger.infoPII(TAG, ObjectMapper.serializeObjectToJsonString(parameters));
        } else {
            Logger.info(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(parameters));
        }
    }

    private static BiConsumer<CommandResult, Throwable> getCommandResultConsumer(final @NonNull BaseCommand command, final @NonNull Handler handler) {
        String methodName = ":getCommandResultConsumer";
        return new BiConsumer<CommandResult, Throwable>(){

            @Override
            public void accept(CommandResult result, final Throwable throwable) {
                if (null != throwable) {
                    Logger.info(TAG + ":getCommandResultConsumer", "Request encountered an exception (this maybe a duplicate request which caries the exception encountered by the original request)");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            CommandDispatcher.commandCallBackOnError(command, throwable);
                        }
                    });
                    return;
                }
                if (!StringUtil.isEmpty(result.getCorrelationId()) && !command.getParameters().getCorrelationId().equals(result.getCorrelationId())) {
                    Logger.info(TAG + ":getCommandResultConsumer", "Completed duplicate request with correlation id : **" + command.getParameters().getCorrelationId() + ", having the same result as : " + result.getCorrelationId() + ", with the status : " + result.getStatus().getLogStatus());
                }
                CommandDispatcher.returnCommandResult(command, result, handler);
            }
        };
    }

    private static void commandCallBackOnError(@NonNull BaseCommand command, Throwable throwable) {
        command.getCallback().onError(ExceptionAdapter.baseExceptionFromException(throwable));
    }

    static void clearCommandCache() {
        sCommandResultCache.clear();
    }

    private static CommandResult executeCommand(BaseCommand command) {
        Object result = null;
        BaseException baseException = null;
        try {
            result = command.execute();
        }
        catch (Exception e) {
            baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
        }
        CommandResult commandResult = baseException != null ? (baseException instanceof UserCancelException ? new CommandResult(CommandResult.ResultStatus.CANCEL, null, command.getParameters().getCorrelationId()) : new CommandResult(CommandResult.ResultStatus.ERROR, baseException, command.getParameters().getCorrelationId())) : (result != null && result instanceof AcquireTokenResult ? CommandDispatcher.getCommandResultFromTokenResult(baseException, result, command.getParameters().getCorrelationId()) : new CommandResult(CommandResult.ResultStatus.COMPLETED, result, command.getParameters().getCorrelationId()));
        return commandResult;
    }

    private static void returnCommandResult(final BaseCommand command, final CommandResult result, @NonNull Handler handler) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                switch (result.getStatus()) {
                    case ERROR: {
                        CommandDispatcher.commandCallbackOnError(command, result);
                        break;
                    }
                    case COMPLETED: {
                        CommandDispatcher.commandCallbackOnTaskCompleted(command, result);
                        break;
                    }
                    case CANCEL: {
                        command.getCallback().onCancel();
                        break;
                    }
                }
            }
        });
    }

    private static void commandCallbackOnError(BaseCommand command, CommandResult result) {
        command.getCallback().onError(ExceptionAdapter.baseExceptionFromException((Throwable)result.getResult()));
    }

    private static void commandCallbackOnTaskCompleted(BaseCommand command, CommandResult result) {
        command.getCallback().onTaskCompleted(result.getResult());
    }

    private static void cacheCommandResult(BaseCommand command, CommandResult commandResult) {
        if (command.isEligibleForCaching() && CommandDispatcher.eligibleToCache(commandResult)) {
            sCommandResultCache.put(command, commandResult);
        }
    }

    private static boolean eligibleToCache(CommandResult commandResult) {
        switch (commandResult.getStatus()) {
            case ERROR: {
                return CommandDispatcher.eligibleToCacheException((BaseException)commandResult.getResult());
            }
            case COMPLETED: {
                return true;
            }
        }
        return false;
    }

    private static boolean eligibleToCacheException(BaseException exception) {
        return !(exception instanceof IntuneAppProtectionPolicyRequiredException);
    }

    private static CommandResult getCommandResultFromTokenResult(BaseException baseException, @NonNull AcquireTokenResult result, @NonNull String correlationId) {
        if (result.getSucceeded().booleanValue()) {
            return new CommandResult(CommandResult.ResultStatus.COMPLETED, result.getLocalAuthenticationResult(), correlationId);
        }
        baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
        if (baseException instanceof UserCancelException) {
            return new CommandResult(CommandResult.ResultStatus.CANCEL, null, correlationId);
        }
        return new CommandResult(CommandResult.ResultStatus.ERROR, baseException, correlationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginInteractive(final InteractiveTokenCommand command) {
        String methodName = ":beginInteractive";
        Object object = sLock;
        synchronized (object) {
            final LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)command.getParameters().getAndroidApplicationContext());
            if (command.getParameters() instanceof BrokerInteractiveTokenCommandParameters) {
                localBroadcastManager.sendBroadcast(new Intent("cancel_interactive_request"));
            }
            sInteractiveExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CommandParameters commandParameters = command.getParameters();
                    String correlationId = CommandDispatcher.initializeDiagnosticContext(commandParameters.getCorrelationId(), commandParameters.getSdkType() == null ? SdkType.UNKNOWN.getProductName() : commandParameters.getSdkType().getProductName(), commandParameters.getSdkVersion());
                    try {
                        commandParameters.setCorrelationId(correlationId);
                        CommandDispatcher.logParameters(TAG + ":beginInteractive", correlationId, commandParameters, command.getPublicApiId());
                        EstsTelemetry.getInstance().initTelemetryForCommand(command);
                        EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                        BroadcastReceiver resultReceiver = new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                CommandDispatcher.completeInteractive(intent);
                            }
                        };
                        Handler handler = new Handler(Looper.getMainLooper());
                        localBroadcastManager.registerReceiver(resultReceiver, new IntentFilter("return_interactive_request_result"));
                        sCommand = command;
                        CommandResult commandResult = CommandDispatcher.executeCommand(command);
                        sCommand = null;
                        localBroadcastManager.unregisterReceiver(resultReceiver);
                        CommandDispatcher.setCorrelationIdOnResult(commandResult, correlationId);
                        Logger.info(TAG + ":beginInteractive", "Completed interactive request for correlation id : **" + correlationId + ", with the status : " + commandResult.getStatus().getLogStatus());
                        EstsTelemetry.getInstance().flush(command, commandResult);
                        Telemetry.getInstance().flush(correlationId);
                        CommandDispatcher.returnCommandResult(command, commandResult, handler);
                    }
                    finally {
                        DiagnosticContext.clear();
                    }
                }
            });
        }
    }

    private static void completeInteractive(Intent resultIntent) {
        String methodName = ":completeInteractive";
        int requestCode = resultIntent.getIntExtra("com.microsoft.identity.client.request.code", 0);
        int resultCode = resultIntent.getIntExtra("com.microsoft.identity.client.result.code", 0);
        if (sCommand != null) {
            sCommand.notify(requestCode, resultCode, resultIntent);
        } else {
            Logger.warn(TAG + ":completeInteractive", "sCommand is null, No interactive call in progress to complete.");
        }
    }

    public static String initializeDiagnosticContext(@Nullable String requestCorrelationId, String sdkType, String sdkVersion) {
        String methodName = ":initializeDiagnosticContext";
        String correlationId = TextUtils.isEmpty((CharSequence)requestCorrelationId) ? UUID.randomUUID().toString() : requestCorrelationId;
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        rc.put("x-client-SKU", sdkType);
        rc.put("x-client-Ver", sdkVersion);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":initializeDiagnosticContext", "Initialized new DiagnosticContext");
        return correlationId;
    }

    public static int getCachedResultCount() {
        return sCommandResultCache.getSize();
    }

    private static void setCorrelationIdOnResult(@NonNull CommandResult commandResult, @NonNull String correlationId) {
        if (commandResult.getResult() != null && commandResult.getResult() instanceof LocalAuthenticationResult) {
            LocalAuthenticationResult localAuthenticationResult = (LocalAuthenticationResult)commandResult.getResult();
            localAuthenticationResult.setCorrelationId(correlationId);
        }
    }
}

