/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.AuthenticationConstants;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.logging.Logger;

public class BrokerOperationBundle {
    private static final String TAG = BrokerOperationBundle.class.getName();
    @NonNull
    private final Operation operation;
    @NonNull
    private final String targetBrokerAppPackageName;
    @Nullable
    private final Bundle bundle;

    public Bundle getAccountManagerBundle() throws BrokerCommunicationException {
        Bundle requestBundle = this.bundle;
        if (requestBundle == null) {
            requestBundle = new Bundle();
        }
        requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", this.getAccountManagerAddAccountOperationKey());
        return requestBundle;
    }

    private String getAccountManagerAddAccountOperationKey() throws BrokerCommunicationException {
        String methodName = ":getAccountManagerAddAccountOperationKey";
        String accountManagerKey = this.operation.getAccountManagerOperation();
        if (accountManagerKey == null) {
            String errorMessage = "Operation " + this.operation.name() + " is not supported by AccountManager addAccount().";
            Logger.warn(TAG + ":getAccountManagerAddAccountOperationKey", errorMessage);
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE, IIpcStrategy.Type.ACCOUNT_MANAGER_ADD_ACCOUNT, errorMessage, null);
        }
        return accountManagerKey;
    }

    public String getContentProviderPath() throws BrokerCommunicationException {
        String methodName = ":getContentProviderUriPath";
        AuthenticationConstants.BrokerContentProvider.API contentApi = this.operation.getContentApi();
        if (contentApi == null) {
            String errorMessage = "Operation " + this.operation.name() + " is not supported by ContentProvider.";
            Logger.warn(TAG + ":getContentProviderUriPath", errorMessage);
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE, IIpcStrategy.Type.CONTENT_PROVIDER, errorMessage, null);
        }
        return contentApi.getPath();
    }

    public BrokerOperationBundle(@NonNull Operation operation, @NonNull String targetBrokerAppPackageName, @Nullable Bundle bundle) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (targetBrokerAppPackageName == null) {
            throw new NullPointerException("targetBrokerAppPackageName is marked non-null but is null");
        }
        this.operation = operation;
        this.targetBrokerAppPackageName = targetBrokerAppPackageName;
        this.bundle = bundle;
    }

    @NonNull
    public Operation getOperation() {
        return this.operation;
    }

    @NonNull
    public String getTargetBrokerAppPackageName() {
        return this.targetBrokerAppPackageName;
    }

    @Nullable
    public Bundle getBundle() {
        return this.bundle;
    }

    public static enum Operation {
        MSAL_HELLO(AuthenticationConstants.BrokerContentProvider.API.MSAL_HELLO, "HELLO"),
        MSAL_GET_INTENT_FOR_INTERACTIVE_REQUEST(AuthenticationConstants.BrokerContentProvider.API.ACQUIRE_TOKEN_INTERACTIVE, "GET_INTENT_FOR_INTERACTIVE_REQUEST"),
        MSAL_ACQUIRE_TOKEN_SILENT(AuthenticationConstants.BrokerContentProvider.API.ACQUIRE_TOKEN_SILENT, "ACQUIRE_TOKEN_SILENT"),
        MSAL_GET_ACCOUNTS(AuthenticationConstants.BrokerContentProvider.API.GET_ACCOUNTS, "GET_ACCOUNTS"),
        MSAL_REMOVE_ACCOUNT(AuthenticationConstants.BrokerContentProvider.API.BROKER_REMOVE_ACCOUNT, "REMOVE_ACCOUNT"),
        MSAL_GET_DEVICE_MODE(AuthenticationConstants.BrokerContentProvider.API.GET_DEVICE_MODE, "GET_DEVICE_MODE"),
        MSAL_GET_CURRENT_ACCOUNT_IN_SHARED_DEVICE(AuthenticationConstants.BrokerContentProvider.API.GET_CURRENT_ACCOUNT_SHARED_DEVICE, "GET_CURRENT_ACCOUNT"),
        MSAL_SIGN_OUT_FROM_SHARED_DEVICE(AuthenticationConstants.BrokerContentProvider.API.SIGN_OUT_FROM_SHARED_DEVICE, "REMOVE_ACCOUNT_FROM_SHARED_DEVICE"),
        MSAL_GENERATE_SHR(AuthenticationConstants.BrokerContentProvider.API.GENERATE_SHR, "GENERATE_SHR"),
        BROKER_GET_KEY_FROM_INACTIVE_BROKER(null, null),
        BROKER_API_HELLO(AuthenticationConstants.BrokerContentProvider.API.BROKER_HELLO, null),
        BROKER_API_GET_BROKER_ACCOUNTS(AuthenticationConstants.BrokerContentProvider.API.BROKER_GET_ACCOUNTS, null),
        BROKER_API_REMOVE_BROKER_ACCOUNT(AuthenticationConstants.BrokerContentProvider.API.BROKER_REMOVE_ACCOUNT, null),
        BROKER_API_UPDATE_BRT(AuthenticationConstants.BrokerContentProvider.API.BROKER_UPDATE_BRT, null),
        BROKER_SET_FLIGHTS(AuthenticationConstants.BrokerContentProvider.API.BROKER_SET_FLIGHTS, null),
        BROKER_GET_FLIGHTS(AuthenticationConstants.BrokerContentProvider.API.BROKER_GET_FLIGHTS, null),
        BROKER_ADD_FLIGHTS(AuthenticationConstants.BrokerContentProvider.API.BROKER_ADD_FLIGHTS, null),
        MSAL_SSO_TOKEN(AuthenticationConstants.BrokerContentProvider.API.GET_SSO_TOKEN, null);

        final AuthenticationConstants.BrokerContentProvider.API mContentApi;
        final String mAccountManagerOperation;

        private Operation(AuthenticationConstants.BrokerContentProvider.API contentApi, String accountManagerOperation) {
            this.mContentApi = contentApi;
            this.mAccountManagerOperation = accountManagerOperation;
        }

        public AuthenticationConstants.BrokerContentProvider.API getContentApi() {
            return this.mContentApi;
        }

        public String getAccountManagerOperation() {
            return this.mAccountManagerOperation;
        }
    }
}

