/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.aad.adal.IBrokerAccountService;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.BoundServiceClient;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;

public class BrokerAccountServiceClient
extends BoundServiceClient<IBrokerAccountService> {
    private static final String BROKER_ACCOUNT_SERVICE_INTENT_FILTER = "com.microsoft.workaccount.BrokerAccount";
    private static final String BROKER_ACCOUNT_SERVICE_CLASS_NAME = "com.microsoft.aad.adal.BrokerAccountService";

    public BrokerAccountServiceClient(@NonNull Context context) {
        super(context, BROKER_ACCOUNT_SERVICE_CLASS_NAME, BROKER_ACCOUNT_SERVICE_INTENT_FILTER);
    }

    public BrokerAccountServiceClient(@NonNull Context context, int timeOutInSeconds) {
        super(context, BROKER_ACCOUNT_SERVICE_CLASS_NAME, BROKER_ACCOUNT_SERVICE_INTENT_FILTER, timeOutInSeconds);
    }

    @Override
    @NonNull
    IBrokerAccountService getInterfaceFromIBinder(@NonNull IBinder binder) {
        IBrokerAccountService service = IBrokerAccountService.Stub.asInterface(binder);
        if (service == null) {
            throw new IllegalStateException("Failed to extract IBrokerAccountService from IBinder.", null);
        }
        return service;
    }

    @Override
    @Nullable
    public Bundle performOperationInternal(@NonNull BrokerOperationBundle brokerOperationBundle, @NonNull IBrokerAccountService brokerAccountService) throws RemoteException, BrokerCommunicationException {
        Bundle inputBundle = brokerOperationBundle.getBundle();
        switch (brokerOperationBundle.getOperation()) {
            case BROKER_GET_KEY_FROM_INACTIVE_BROKER: {
                return brokerAccountService.getInactiveBrokerKey(inputBundle);
            }
        }
        throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE, IIpcStrategy.Type.BOUND_SERVICE, "Operation not supported. Wrong BoundServiceClient used.", null);
    }
}

