/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;

public final class CacheRecord
implements ICacheRecord {
    private final AccountRecord mAccount;
    private final AccessTokenRecord mAccessToken;
    private final RefreshTokenRecord mRefreshToken;
    private final IdTokenRecord mIdToken;
    private final IdTokenRecord mV1IdToken;

    @Override
    public AccountRecord getAccount() {
        return this.mAccount;
    }

    @Override
    public AccessTokenRecord getAccessToken() {
        return this.mAccessToken;
    }

    @Override
    public RefreshTokenRecord getRefreshToken() {
        return this.mRefreshToken;
    }

    @Override
    public IdTokenRecord getIdToken() {
        return this.mIdToken;
    }

    @Override
    public IdTokenRecord getV1IdToken() {
        return this.mV1IdToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheRecord that = (CacheRecord)o;
        if (this.mAccount != null ? !this.mAccount.equals(that.mAccount) : that.mAccount != null) {
            return false;
        }
        if (this.mAccessToken != null ? !this.mAccessToken.equals(that.mAccessToken) : that.mAccessToken != null) {
            return false;
        }
        if (this.mRefreshToken != null ? !this.mRefreshToken.equals(that.mRefreshToken) : that.mRefreshToken != null) {
            return false;
        }
        return this.mIdToken != null ? this.mIdToken.equals(that.mIdToken) : that.mIdToken == null;
    }

    public int hashCode() {
        int result = this.mAccount != null ? this.mAccount.hashCode() : 0;
        result = 31 * result + (this.mAccessToken != null ? this.mAccessToken.hashCode() : 0);
        result = 31 * result + (this.mRefreshToken != null ? this.mRefreshToken.hashCode() : 0);
        result = 31 * result + (this.mIdToken != null ? this.mIdToken.hashCode() : 0);
        return result;
    }

    CacheRecord(AccountRecord mAccount, AccessTokenRecord mAccessToken, RefreshTokenRecord mRefreshToken, IdTokenRecord mIdToken, IdTokenRecord mV1IdToken) {
        this.mAccount = mAccount;
        this.mAccessToken = mAccessToken;
        this.mRefreshToken = mRefreshToken;
        this.mIdToken = mIdToken;
        this.mV1IdToken = mV1IdToken;
    }

    public static CacheRecordBuilder builder() {
        return new CacheRecordBuilder();
    }

    public AccountRecord getMAccount() {
        return this.mAccount;
    }

    public AccessTokenRecord getMAccessToken() {
        return this.mAccessToken;
    }

    public RefreshTokenRecord getMRefreshToken() {
        return this.mRefreshToken;
    }

    public IdTokenRecord getMIdToken() {
        return this.mIdToken;
    }

    public IdTokenRecord getMV1IdToken() {
        return this.mV1IdToken;
    }

    public String toString() {
        return "CacheRecord(mAccount=" + this.getMAccount() + ", mAccessToken=" + this.getMAccessToken() + ", mRefreshToken=" + this.getMRefreshToken() + ", mIdToken=" + this.getMIdToken() + ", mV1IdToken=" + this.getMV1IdToken() + ")";
    }

    public static class CacheRecordBuilder {
        private AccountRecord mAccount;
        private AccessTokenRecord mAccessToken;
        private RefreshTokenRecord mRefreshToken;
        private IdTokenRecord mIdToken;
        private IdTokenRecord mV1IdToken;

        public CacheRecordBuilder mAccount(@NonNull AccountRecord account) {
            if (account == null) {
                throw new NullPointerException("The account record for a CacheRecord may not be null");
            }
            this.mAccount = account;
            return this;
        }

        CacheRecordBuilder() {
        }

        public CacheRecordBuilder mAccessToken(AccessTokenRecord mAccessToken) {
            this.mAccessToken = mAccessToken;
            return this;
        }

        public CacheRecordBuilder mRefreshToken(RefreshTokenRecord mRefreshToken) {
            this.mRefreshToken = mRefreshToken;
            return this;
        }

        public CacheRecordBuilder mIdToken(IdTokenRecord mIdToken) {
            this.mIdToken = mIdToken;
            return this;
        }

        public CacheRecordBuilder mV1IdToken(IdTokenRecord mV1IdToken) {
            this.mV1IdToken = mV1IdToken;
            return this;
        }

        public CacheRecord build() {
            return new CacheRecord(this.mAccount, this.mAccessToken, this.mRefreshToken, this.mIdToken, this.mV1IdToken);
        }

        public String toString() {
            return "CacheRecord.CacheRecordBuilder(mAccount=" + this.mAccount + ", mAccessToken=" + this.mAccessToken + ", mRefreshToken=" + this.mRefreshToken + ", mIdToken=" + this.mIdToken + ", mV1IdToken=" + this.mV1IdToken + ")";
        }
    }
}

