/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PackageHelper {
    private static final String TAG = "CallerInfo";
    private PackageManager mPackageManager;

    public PackageHelper(PackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public String getCurrentSignatureForPackage(String packageName) {
        try {
            PackageInfo info = this.mPackageManager.getPackageInfo(packageName, 64);
            if (info != null && info.signatures != null && info.signatures.length > 0) {
                Signature signature = info.signatures[0];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)2);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(TAG, "Calling App's package does not exist in PackageManager. ", "", e);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(TAG, "Digest SHA algorithm does not exists. ", "", e);
        }
        return null;
    }

    public int getUIDForPackage(String packageName) {
        int callingUID = 0;
        try {
            ApplicationInfo info = this.mPackageManager.getApplicationInfo(packageName, 0);
            if (info != null) {
                callingUID = info.uid;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(TAG, "Package is not found. ", "Package name: " + packageName, e);
        }
        return callingUID;
    }

    public boolean isPackageInstalledAndEnabled(Context context, String packageName) {
        String methodName = "#isPackageInstalledAndEnabled";
        boolean enabled = false;
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 0);
            if (applicationInfo != null) {
                enabled = applicationInfo.enabled;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error("CallerInfo#isPackageInstalledAndEnabled", "Package is not found. Package name: " + packageName, e);
        }
        Logger.info("CallerInfo#isPackageInstalledAndEnabled", " Is package installed and enabled? [" + enabled + "]");
        return enabled;
    }

    public static String getBrokerRedirectUrl(String packageName, String signatureDigest) {
        if (!StringExtensions.isNullOrBlank(packageName) && !StringExtensions.isNullOrBlank(signatureDigest)) {
            if (packageName.equals("com.azure.authenticator") && (signatureDigest.equals(BrokerData.MICROSOFT_AUTHENTICATOR_PROD.signatureHash) || signatureDigest.equals(BrokerData.MICROSOFT_AUTHENTICATOR_DEBUG.signatureHash))) {
                return "urn:ietf:wg:oauth:2.0:oob";
            }
            try {
                return String.format("%s://%s/%s", "msauth", URLEncoder.encode(packageName, "UTF-8"), URLEncoder.encode(signatureDigest, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(TAG, "", "Encoding is not supported", e);
            }
        }
        return "";
    }
}

